// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.TreeNodeTagDeclaration}.
 */
public final class TreeNodeTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(TreeNodeTag.class);
  private javax.el.ValueExpression  marked;
  private javax.el.MethodExpression  treeExpansionListener;
  private javax.el.ValueExpression  markup;
  private javax.el.MethodExpression  treeMarkedListener;
  private javax.el.ValueExpression  expanded;
  private javax.el.ValueExpression  width;
  private javax.el.ValueExpression  tip;
  private javax.el.ValueExpression  disabled;
  private javax.el.ValueExpression  selected;

  @Override
  public String getComponentType() {
    return UITreeNode.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "TreeNode";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UITreeNode component = (UITreeNode) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (marked != null) {
      if (!marked.isLiteralText()) {
        component.setValueExpression("marked", marked);
      } else {
        component.setMarked(Boolean.parseBoolean(marked.getExpressionString()));
      }
    }
    if (treeExpansionListener != null) {
      component.addTreeExpansionListener(new org.apache.myfaces.tobago.event.MethodExpressionTreeExpansionListener(treeExpansionListener));
    }
    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (treeMarkedListener != null) {
      component.addTreeMarkedListener(new org.apache.myfaces.tobago.event.MethodExpressionTreeMarkedListener(treeMarkedListener));
    }
    if (expanded != null) {
      if (!expanded.isLiteralText()) {
        component.setValueExpression("expanded", expanded);
      } else {
        component.setExpanded(Boolean.parseBoolean(expanded.getExpressionString()));
      }
    }
    if (width != null) {
      if (!width.isLiteralText()) {
        component.setValueExpression("width", width);
      } else {
        component.setWidth(org.apache.myfaces.tobago.layout.Measure.valueOf(width.getExpressionString()));
      }
    }
    if (tip != null) {
      component.setValueExpression("tip", tip);
    }

    if (disabled != null) {
      if (!disabled.isLiteralText()) {
        component.setValueExpression("disabled", disabled);
      } else {
        component.setDisabled(Boolean.parseBoolean(disabled.getExpressionString()));
      }
    }
    if (selected != null) {
      if (!selected.isLiteralText()) {
        component.setValueExpression("selected", selected);
      } else {
        component.setSelected(Boolean.parseBoolean(selected.getExpressionString()));
      }
    }
  }

  public javax.el.ValueExpression getMarked() {
    return marked;
  }

  public void setMarked(final javax.el.ValueExpression marked) {
    this.marked = marked;
  }

  public javax.el.MethodExpression getTreeExpansionListener() {
    return treeExpansionListener;
  }

  public void setTreeExpansionListener(final javax.el.MethodExpression treeExpansionListener) {
    this.treeExpansionListener = treeExpansionListener;
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.MethodExpression getTreeMarkedListener() {
    return treeMarkedListener;
  }

  public void setTreeMarkedListener(final javax.el.MethodExpression treeMarkedListener) {
    this.treeMarkedListener = treeMarkedListener;
  }

  public javax.el.ValueExpression getExpanded() {
    return expanded;
  }

  public void setExpanded(final javax.el.ValueExpression expanded) {
    this.expanded = expanded;
  }

  public javax.el.ValueExpression getWidth() {
    return width;
  }

  public void setWidth(final javax.el.ValueExpression width) {
    this.width = width;
  }

  public javax.el.ValueExpression getTip() {
    return tip;
  }

  public void setTip(final javax.el.ValueExpression tip) {
    this.tip = tip;
  }

  public javax.el.ValueExpression getDisabled() {
    return disabled;
  }

  public void setDisabled(final javax.el.ValueExpression disabled) {
    this.disabled = disabled;
  }

  public javax.el.ValueExpression getSelected() {
    return selected;
  }

  public void setSelected(final javax.el.ValueExpression selected) {
    this.selected = selected;
  }



  @Override
  public void release() {
    super.release();
    marked = null;
    treeExpansionListener = null;
    markup = null;
    treeMarkedListener = null;
    expanded = null;
    width = null;
    tip = null;
    disabled = null;
    selected = null;
  }
}