/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import org.apache.myfaces.test.el.MockCompositeValueExpression;
import org.apache.myfaces.test.el.MockMethodExpression;
import org.apache.myfaces.test.el.MockVariableValueExpression;

public class MockExpressionFactory
extends ExpressionFactory {
    private static final Integer ZERO = new Integer(0);

    public Object coerceToType(Object object, Class targetType) {
        if (targetType == null || Object.class.equals((Object)targetType)) {
            return object;
        }
        if (String.class.equals((Object)targetType)) {
            if (object == null) {
                return "";
            }
            if (object instanceof String) {
                return (String)object;
            }
            return object.toString();
        }
        if (this.isNumeric(targetType)) {
            if (object == null) {
                return this.coerce(ZERO, targetType);
            }
            if ("".equals(object)) {
                return this.coerce(ZERO, targetType);
            }
            if (object instanceof String) {
                return this.coerce((String)object, targetType);
            }
            if (this.isNumeric(object.getClass())) {
                return this.coerce((Number)object, targetType);
            }
            throw new IllegalArgumentException("Cannot convert " + object + " to Number");
        }
        if (Boolean.class.equals((Object)targetType) || Boolean.TYPE == targetType) {
            if (object == null) {
                return Boolean.FALSE;
            }
            if ("".equals(object)) {
                return Boolean.FALSE;
            }
            if (object instanceof Boolean || object.getClass() == Boolean.TYPE) {
                return (Boolean)object;
            }
            if (object instanceof String) {
                return Boolean.valueOf((String)object);
            }
            throw new IllegalArgumentException("Cannot convert " + object + " to Boolean");
        }
        if (Character.class.equals((Object)targetType) || Character.TYPE == targetType) {
            if (object == null) {
                return new Character('\u0000');
            }
            if ("".equals(object)) {
                return new Character('\u0000');
            }
            if (object instanceof String) {
                return new Character(((String)object).charAt(0));
            }
            if (this.isNumeric(object.getClass())) {
                return new Character((char)((Number)object).shortValue());
            }
            if (object instanceof Character || object.getClass() == Character.TYPE) {
                return (Character)object;
            }
            throw new IllegalArgumentException("Cannot convert " + object + " to Character");
        }
        if (targetType.isEnum()) {
            if (object == null || "".equals(object)) {
                return null;
            }
            if (targetType.isAssignableFrom(object.getClass())) {
                return (Enum)object;
            }
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("Cannot convert " + object + " to Enum");
            }
            try {
                Object result = Enum.valueOf(targetType, (String)object);
                return result;
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Cannot convert " + object + " to Enum");
            }
        }
        if (object != null && targetType.isAssignableFrom(object.getClass())) {
            return object;
        }
        if (object == null) {
            return null;
        }
        throw new IllegalArgumentException("Cannot convert " + object + " to " + targetType.getName());
    }

    public MethodExpression createMethodExpression(ELContext context, String expression, Class expectedType, Class[] signature) {
        return new MockMethodExpression(expression, signature, expectedType);
    }

    public ValueExpression createValueExpression(ELContext context, String expression, Class expectedType) {
        return new MockCompositeValueExpression(expression, expectedType);
    }

    public ValueExpression createValueExpression(Object instance, Class expectedType) {
        return new MockVariableValueExpression(instance, expectedType);
    }

    private Number coerce(Number value, Class type) {
        if (type == Byte.TYPE || type == Byte.class) {
            return new Byte(value.byteValue());
        }
        if (type == Double.TYPE || type == Double.class) {
            return new Double(value.doubleValue());
        }
        if (type == Float.TYPE || type == Float.class) {
            return new Float(value.floatValue());
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return new Integer(value.intValue());
        }
        if (type == Long.TYPE || type == Long.class) {
            return new Long(value.longValue());
        }
        if (type == Short.TYPE || type == Short.class) {
            return new Short(value.shortValue());
        }
        if (type == BigDecimal.class) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            return new BigDecimal(value.doubleValue());
        }
        if (type == BigInteger.class) {
            if (value instanceof BigInteger) {
                return (BigInteger)value;
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toBigInteger();
            }
            return BigInteger.valueOf(value.longValue());
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to " + type.getName());
    }

    private Number coerce(String value, Class type) {
        if (type == Byte.TYPE || type == Byte.class) {
            return Byte.valueOf(value);
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.valueOf(value);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(value);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.valueOf(value);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.valueOf(value);
        }
        if (type == Short.TYPE || type == Short.class) {
            return Short.valueOf(value);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(value);
        }
        if (type == BigInteger.class) {
            return new BigInteger(value);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to " + type.getName());
    }

    private boolean isNumeric(Class type) {
        return type == Byte.TYPE || type == Byte.class || type == Double.TYPE || type == Double.class || type == Float.TYPE || type == Float.class || type == Integer.TYPE || type == Integer.class || type == Long.TYPE || type == Long.class || type == Short.TYPE || type == Short.class || type == BigDecimal.class || type == BigInteger.class;
    }
}

