/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.requestParameterProvider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;
import org.apache.myfaces.orchestra.lib.OrchestraException;
import org.apache.myfaces.orchestra.requestParameterProvider.RequestParameterProvider;
import org.apache.myfaces.orchestra.requestParameterProvider.RequestParameterServletFilter;

public class RequestParameterProviderManager
implements Serializable {
    private final Log LOG = LogFactory.getLog(RequestParameterProviderManager.class);
    private static final String PAGE_LINK_SEP = "#";
    private static final Set SCHEMES_TO_EXCLUDE = new HashSet();
    private static final String PAGE_PARAMETER_SEP = "?";
    private static final String PARAMETER_SEP = "&";
    private static final String PARAMETER_PROVIDER_MANAGER_KEY = RequestParameterProviderManager.class.getName();
    private transient List providers;

    private RequestParameterProviderManager() {
    }

    public static RequestParameterProviderManager getInstance() {
        FrameworkAdapter fa = FrameworkAdapter.getCurrentInstance();
        if (fa == null) {
            Log log = LogFactory.getLog(RequestParameterProviderManager.class);
            log.error((Object)"No framework adapter currently selected");
            throw new OrchestraException("No framework adapter currently selected");
        }
        RequestParameterProviderManager manager = (RequestParameterProviderManager)fa.getSessionAttribute(PARAMETER_PROVIDER_MANAGER_KEY);
        if (manager == null) {
            manager = new RequestParameterProviderManager();
            fa.setSessionAttribute(PARAMETER_PROVIDER_MANAGER_KEY, manager);
        }
        return manager;
    }

    public void register(RequestParameterProvider provider) {
        if (provider == null) {
            this.LOG.warn((Object)"RequestParameterProvider is null -> no registration!");
        } else {
            this.getProviders().add(provider);
        }
    }

    public String encodeAndAttachParameters(String url) {
        String probablyScheme;
        if (!this.isResponseIntercepted()) {
            throw new IllegalStateException("RequestParameterServletFilter not called. Please configure the filter " + RequestParameterServletFilter.class.getName() + " in your web.xml to cover your faces requests.");
        }
        if (url == null) {
            return null;
        }
        if (PAGE_LINK_SEP.equals(url)) {
            return url;
        }
        int pos = url.indexOf(":");
        if (pos > 0 && SCHEMES_TO_EXCLUDE.contains(probablyScheme = url.substring(0, pos))) {
            return url;
        }
        StringBuffer sb = new StringBuffer();
        int nuofParams = -1;
        String firstSeparator = url.indexOf(PAGE_PARAMETER_SEP) == -1 ? PAGE_PARAMETER_SEP : PARAMETER_SEP;
        int pageLinkPos = url.indexOf(PAGE_LINK_SEP);
        if (pageLinkPos < 0) {
            sb.append(url);
        } else {
            sb.append(url.substring(0, pageLinkPos));
        }
        for (RequestParameterProvider provider : this.getProviders()) {
            String[] fields = provider.getFields();
            if (fields == null) continue;
            for (int i = 0; i < fields.length; ++i) {
                ++nuofParams;
                if (url.indexOf(fields[i]) > 0) continue;
                sb.append(nuofParams == 0 ? firstSeparator : PARAMETER_SEP);
                sb.append(fields[i]);
                sb.append("=");
                sb.append(provider.getFieldValue(fields[i]));
            }
        }
        if (pageLinkPos > -1) {
            sb.append(url.substring(pageLinkPos));
        }
        return sb.toString();
    }

    protected boolean isResponseIntercepted() {
        FrameworkAdapter fa = FrameworkAdapter.getCurrentInstance();
        return Boolean.TRUE.equals(fa.getRequestAttribute(RequestParameterServletFilter.REQUEST_PARAM_FILTER_CALLED)) || Boolean.TRUE.equals(fa.getRequestAttribute(RequestParameterServletFilter.REQUEST_PARAM_RESPONSE_WRAPPED));
    }

    protected List getProviders() {
        if (this.providers == null) {
            this.providers = new ArrayList();
        }
        return this.providers;
    }

    static {
        SCHEMES_TO_EXCLUDE.add("javascript");
        SCHEMES_TO_EXCLUDE.add("ftp");
        SCHEMES_TO_EXCLUDE.add("mailto");
    }
}

