/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.conversation.Conversation;
import org.apache.myfaces.orchestra.conversation.ConversationFactory;
import org.apache.myfaces.orchestra.conversation.ConversationTimeoutableAspect;
import org.apache.myfaces.orchestra.lib.OrchestraException;
import org.apache.myfaces.orchestra.lib._ReentrantLock;

public class ConversationContext {
    private final Log log = LogFactory.getLog(ConversationContext.class);
    private final Long id;
    private final Map attributes = new TreeMap();
    private final ConversationContext parent;
    private final Map conversations = new TreeMap();
    private String name;
    private long lastAccess;
    private long timeoutMillis = 1800000L;
    private final _ReentrantLock lock = new _ReentrantLock();
    private Map childContexts = new HashMap();

    protected ConversationContext(long id) {
        this(null, id);
    }

    protected ConversationContext(ConversationContext parent, long id) {
        this.parent = parent;
        this.id = id;
        if (parent != null) {
            parent.addChild(this);
        }
        this.touch();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getId() {
        return this.id;
    }

    public Long getIdAsLong() {
        return this.id;
    }

    public ConversationContext getParent() {
        return this.parent;
    }

    public void addChild(ConversationContext context) {
        this.childContexts.put(context.getIdAsLong(), context);
    }

    protected Collection getChildren() {
        return this.childContexts.values();
    }

    public void removeChild(ConversationContext context) {
        Object o = this.childContexts.remove(context.getIdAsLong());
        if (o != context) {
            throw new OrchestraException("Invalid call of removeChild");
        }
    }

    public boolean hasChildren() {
        return !this.childContexts.isEmpty();
    }

    protected void touch() {
        this.lastAccess = System.currentTimeMillis();
        if (this.getParent() != null) {
            this.getParent().touch();
        }
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public long getTimeout() {
        return this.timeoutMillis;
    }

    public void setTimeout(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    protected void clear() {
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidate() {
        ConversationContext conversationContext = this;
        synchronized (conversationContext) {
            Conversation[] convArray = new Conversation[this.conversations.size()];
            this.conversations.values().toArray(convArray);
            for (int i = 0; i < convArray.length; ++i) {
                Conversation conversation = convArray[i];
                conversation.invalidate();
            }
            this.conversations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Conversation startConversation(String name, ConversationFactory factory) {
        ConversationContext conversationContext = this;
        synchronized (conversationContext) {
            this.touch();
            Conversation conversation = (Conversation)this.conversations.get(name);
            if (conversation == null) {
                conversation = factory.createConversation(this, name);
                this.conversations.put(name, conversation);
            }
            return conversation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConversation(Conversation conversation) {
        ConversationContext conversationContext = this;
        synchronized (conversationContext) {
            this.touch();
            this.conversations.remove(conversation.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConversation(String name) {
        ConversationContext conversationContext = this;
        synchronized (conversationContext) {
            this.touch();
            Conversation conversation = (Conversation)this.conversations.get(name);
            if (conversation != null) {
                this.removeConversation(conversation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasConversations() {
        ConversationContext conversationContext = this;
        synchronized (conversationContext) {
            this.touch();
            return this.conversations.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasConversation(String name) {
        ConversationContext conversationContext = this;
        synchronized (conversationContext) {
            this.touch();
            return this.conversations.get(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Conversation getConversation(String name) {
        ConversationContext conversationContext = this;
        synchronized (conversationContext) {
            this.touch();
            Conversation conv = (Conversation)this.conversations.get(name);
            if (conv != null) {
                conv.touch();
            }
            return conv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateConversations() {
        ConversationContext conversationContext = this;
        synchronized (conversationContext) {
            this.touch();
            Conversation[] convs = this.conversations.values().toArray(new Conversation[this.conversations.size()]);
            return Arrays.asList(convs).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConversationTimeout() {
        ConversationContext conversationContext = this;
        synchronized (conversationContext) {
            Conversation[] convArray = new Conversation[this.conversations.size()];
            this.conversations.values().toArray(convArray);
            for (int i = 0; i < convArray.length; ++i) {
                Conversation conversation = convArray[i];
                ConversationTimeoutableAspect timeoutAspect = (ConversationTimeoutableAspect)conversation.getAspect(ConversationTimeoutableAspect.class);
                if (timeoutAspect == null || !timeoutAspect.isTimeoutReached()) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("end conversation due to timeout: " + conversation.getName()));
                }
                conversation.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object attribute) {
        Map map = this.attributes;
        synchronized (map) {
            this.attributes.remove(name);
            this.attributes.put(name, attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAttribute(String name) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeAttribute(String name) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.remove(name);
        }
    }

    public void lockInterruptablyForCurrentThread() throws InterruptedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Locking context " + this.id));
        }
        this.lock.lockInterruptibly();
    }

    public void unlockForCurrentThread() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Unlocking context " + this.id));
        }
        this.lock.unlock();
    }

    public boolean isLockedForCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    public ConversationContext getRoot() {
        ConversationContext cctx = this;
        while (cctx != null && cctx.getParent() != null) {
            cctx = this.getParent();
        }
        return cctx;
    }
}

