/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.renderkit;

import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Logger;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import org.apache.myfaces.extensions.validator.core.renderkit.ExtValRendererWrapper;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

@UsageInformation(value={UsageCategory.INTERNAL})
public class ExtValRenderKit
extends RenderKit {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected RenderKit wrapped;

    public ExtValRenderKit(RenderKit wrapped) {
        this.wrapped = wrapped;
        this.logger.fine(((Object)((Object)this)).getClass().getName() + " instantiated");
    }

    public void addRenderer(String family, String rendererType, Renderer renderer) {
        if (renderer instanceof ExtValRendererWrapper) {
            this.wrapped.addRenderer(family, rendererType, renderer);
        } else {
            this.wrapped.addRenderer(family, rendererType, this.createWrapper(renderer));
        }
    }

    public Renderer getRenderer(String family, String rendererType) {
        Renderer renderer = this.wrapped.getRenderer(family, rendererType);
        if (renderer != null) {
            return renderer instanceof ExtValRendererWrapper ? renderer : this.createWrapper(renderer);
        }
        return renderer;
    }

    public ResponseStateManager getResponseStateManager() {
        return this.wrapped.getResponseStateManager();
    }

    public ResponseWriter createResponseWriter(Writer writer, String s, String s1) {
        return this.wrapped.createResponseWriter(writer, s, s1);
    }

    public ResponseStream createResponseStream(OutputStream outputStream) {
        return this.wrapped.createResponseStream(outputStream);
    }

    @UsageInformation(value={UsageCategory.REUSE})
    protected Renderer createWrapper(Renderer renderer) {
        return new ExtValRendererWrapper(renderer);
    }
}

