/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.trinidad.initializer.component;

import java.lang.reflect.Method;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.trinidad.initializer.component.TrinidadComponentInitializer;
import org.apache.myfaces.extensions.validator.trinidad.util.TrinidadUtils;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;
import org.apache.myfaces.trinidad.component.core.output.CoreOutputLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
class RequiredInitializer
extends TrinidadComponentInitializer {
    RequiredInitializer() {
    }

    @Override
    public boolean configureTrinidadComponent(FacesContext facesContext, UIComponent uiComponent, Map<String, Object> metaData) {
        if (!this.validateEmptyFields() || !ExtValUtils.isRequiredInitializationActive()) {
            return false;
        }
        if (metaData.containsKey("required") || metaData.containsKey("weak_required") || metaData.containsKey("skip_validation")) {
            if ((!Boolean.TRUE.equals(metaData.get("skip_validation")) && Boolean.TRUE.equals(metaData.get("weak_required")) || Boolean.TRUE.equals(metaData.get("required"))) && Boolean.TRUE.equals(this.isComponentRequired(uiComponent))) {
                if (uiComponent instanceof EditableValueHolder) {
                    ((EditableValueHolder)uiComponent).setRequired(true);
                } else if (uiComponent instanceof CoreOutputLabel) {
                    ((CoreOutputLabel)uiComponent).setShowRequired(true);
                }
                return true;
            }
            if (Boolean.TRUE.equals(metaData.get("skip_validation")) && !Boolean.TRUE.equals(metaData.get("required"))) {
                if (uiComponent instanceof EditableValueHolder && ExtValUtils.isRequiredResetActivated()) {
                    ((EditableValueHolder)uiComponent).setRequired(false);
                } else if (uiComponent instanceof CoreOutputLabel) {
                    ((CoreOutputLabel)uiComponent).setShowRequired(false);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean validateEmptyFields() {
        return ExtValUtils.validateEmptyFields();
    }

    protected Boolean isComponentRequired(UIComponent uiComponent) {
        if (uiComponent instanceof CoreOutputLabel && (uiComponent = TrinidadUtils.findLabeledEditableComponent((CoreOutputLabel)uiComponent)) == null) {
            return false;
        }
        boolean isReadOnly = !Boolean.FALSE.equals(ReflectionUtils.tryToInvokeMethod((Object)uiComponent, (Method)ReflectionUtils.tryToGetMethod(uiComponent.getClass(), (String)"isReadOnly")));
        boolean isDisabled = !Boolean.FALSE.equals(ReflectionUtils.tryToInvokeMethod((Object)uiComponent, (Method)ReflectionUtils.tryToGetMethod(uiComponent.getClass(), (String)"isDisabled")));
        return !isReadOnly && !isDisabled;
    }
}

