/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf2.impl.scope.conversation;

import java.io.IOException;
import javax.enterprise.inject.Alternative;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.WindowContextConfig;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.DefaultWindowHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.JsfUtils;

@Alternative
public class ServerSideWindowHandler
extends DefaultWindowHandler {
    private static final long serialVersionUID = 4040116087475343221L;
    private boolean useFallback;

    protected ServerSideWindowHandler() {
    }

    @Inject
    protected ServerSideWindowHandler(WindowContextConfig config) {
        super(config);
        this.useFallback = ClassUtils.tryToLoadClassForName((String)"org.apache.myfaces.context.FacesContextFactoryImpl") == null;
    }

    public void sendRedirect(ExternalContext externalContext, String url, boolean addRequestParameter) throws IOException {
        if (FacesContext.getCurrentInstance().getResponseComplete()) {
            return;
        }
        String windowId = this.getCurrentWindowId();
        if (this.useWindowAwareUrlEncoding || this.useFallback || FacesContext.getCurrentInstance().getPartialViewContext().isPartialRequest()) {
            super.sendRedirect(externalContext, url, addRequestParameter);
            return;
        }
        if (windowId != null) {
            externalContext.getRequestMap().put("windowId", windowId);
            externalContext.getFlash().keep("windowId");
        }
        url = addRequestParameter ? JsfUtils.addParameters(externalContext, url, true, true, true) : JsfUtils.addParameters(externalContext, url, false, true, true);
        externalContext.redirect(url);
    }

    public String restoreWindowId(ExternalContext externalContext) {
        if (this.useWindowAwareUrlEncoding || this.useFallback) {
            return super.restoreWindowId(externalContext);
        }
        return (String)externalContext.getFlash().remove((Object)"windowId");
    }
}

