/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.listener.phase;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.apache.myfaces.extensions.cdi.core.api.provider.BeanManagerProvider;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.WindowContextConfig;
import org.apache.myfaces.extensions.cdi.core.impl.util.ClassDeactivation;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.listener.request.BeforeAfterFacesRequestBroadcaster;
import org.apache.myfaces.extensions.cdi.jsf.impl.listener.startup.ApplicationStartupBroadcaster;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContextManager;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.LifecycleAwareWindowHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.WindowHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ConversationRequiredUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ConversationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CodiLifecycleWrapper
extends Lifecycle {
    private Lifecycle wrapped;
    private BeforeAfterFacesRequestBroadcaster beforeAfterFacesRequestBroadcaster;
    private volatile Boolean initialized;
    private volatile Boolean applicationInitialized;

    CodiLifecycleWrapper(Lifecycle wrapped, List<PhaseListener> phaseListeners) {
        this.wrapped = wrapped;
        for (PhaseListener phaseListener : phaseListeners) {
            this.wrapped.addPhaseListener(phaseListener);
        }
    }

    public void addPhaseListener(PhaseListener phaseListener) {
        this.wrapped.addPhaseListener(phaseListener);
    }

    public void execute(FacesContext facesContext) {
        this.broadcastApplicationStartupBroadcaster();
        this.broadcastBeforeFacesRequestEvent(facesContext);
        WindowHandler windowHandler = (WindowHandler)CodiUtils.getContextualReferenceByClass(WindowHandler.class, (Annotation[])new Annotation[0]);
        if (windowHandler instanceof LifecycleAwareWindowHandler) {
            ((LifecycleAwareWindowHandler)windowHandler).beforeLifecycleExecute(facesContext);
            if (facesContext.getResponseComplete()) {
                return;
            }
        }
        this.wrapped.execute(facesContext);
    }

    public PhaseListener[] getPhaseListeners() {
        return this.wrapped.getPhaseListeners();
    }

    public void removePhaseListener(PhaseListener phaseListener) {
        this.wrapped.removePhaseListener(phaseListener);
    }

    public void render(FacesContext facesContext) {
        ConversationRequiredUtils.ensureExistingConversation(facesContext);
        this.wrapped.render(facesContext);
        ConversationUtils.postRenderCleanup(facesContext);
    }

    private void broadcastApplicationStartupBroadcaster() {
        if (this.applicationInitialized == null) {
            this.initApplication();
        }
    }

    private synchronized void initApplication() {
        if (this.applicationInitialized == null) {
            this.applicationInitialized = true;
            ApplicationStartupBroadcaster applicationStartupBroadcaster = (ApplicationStartupBroadcaster)CodiUtils.getContextualReferenceByClass(ApplicationStartupBroadcaster.class, (Annotation[])new Annotation[0]);
            applicationStartupBroadcaster.broadcastStartupEvent();
        }
    }

    private void broadcastBeforeFacesRequestEvent(FacesContext facesContext) {
        this.lazyInit();
        if (this.beforeAfterFacesRequestBroadcaster != null) {
            BeanManagerProvider beanManagerProvider = BeanManagerProvider.getInstance();
            EditableWindowContextManager windowContextManager = (EditableWindowContextManager)beanManagerProvider.getContextualReference(EditableWindowContextManager.class, new Annotation[0]);
            WindowHandler windowHandler = (WindowHandler)beanManagerProvider.getContextualReference(WindowHandler.class, new Annotation[0]);
            WindowContextConfig windowContextConfig = (WindowContextConfig)beanManagerProvider.getContextualReference(WindowContextConfig.class, new Annotation[0]);
            ConversationUtils.tryToRestoreTheWindowIdEagerly(facesContext, windowContextManager, windowHandler, windowContextConfig);
            this.beforeAfterFacesRequestBroadcaster.broadcastBeforeFacesRequestEvent(facesContext);
        }
    }

    private void lazyInit() {
        if (this.initialized == null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.initialized == null) {
            if (ClassDeactivation.isClassActivated(BeforeAfterFacesRequestBroadcaster.class)) {
                this.beforeAfterFacesRequestBroadcaster = (BeforeAfterFacesRequestBroadcaster)CodiUtils.getContextualReferenceByClass(BeforeAfterFacesRequestBroadcaster.class, (Annotation[])new Annotation[0]);
            }
            this.initialized = true;
        }
    }
}

