/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.config.view;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Named;
import org.apache.myfaces.extensions.cdi.core.api.config.view.DefaultErrorView;
import org.apache.myfaces.extensions.cdi.core.api.config.view.ViewConfig;
import org.apache.myfaces.extensions.cdi.core.api.config.view.ViewMetaData;
import org.apache.myfaces.extensions.cdi.core.api.security.Secured;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.Page;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.ViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.DefaultViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.ExtractedInlineViewConfigDefinitionEntry;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.ExtractedViewConfigDefinitionEntry;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.ViewConfigCache;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.EditableViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.ViewConfigExtractor;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultViewConfigExtractor
implements ViewConfigExtractor {
    private static final long serialVersionUID = 5794817257216134993L;

    DefaultViewConfigExtractor() {
    }

    @Override
    public EditableViewConfigDescriptor extractViewConfig(Class<? extends ViewConfig> viewDefinitionClass) {
        ExtractedViewConfigDefinitionEntry viewConfigDescriptor = new ExtractedViewConfigDefinitionEntry(viewDefinitionClass);
        return this.extractViewConfigDescriptor(viewDefinitionClass, viewConfigDescriptor);
    }

    @Override
    public boolean isInlineViewConfig(Class<? extends ViewConfig> viewDefinitionClass) {
        return this.isResolvable(viewDefinitionClass, new ArrayList<Class<? extends Annotation>>());
    }

    @Override
    public EditableViewConfigDescriptor extractInlineViewConfig(Class<? extends ViewConfig> viewDefinitionClass) {
        String basePath;
        int endIndex;
        Class viewConfigRootMarker = ViewConfigCache.getInlineViewConfigRootMarker();
        if (viewConfigRootMarker == null) {
            throw ExceptionUtils.missingInlineViewConfigRootMarkerException(viewDefinitionClass);
        }
        int startIndex = viewConfigRootMarker.getPackage().getName().length() + 1;
        if (startIndex < (endIndex = viewDefinitionClass.getName().lastIndexOf("."))) {
            basePath = viewDefinitionClass.getName().substring(startIndex, endIndex);
            basePath = basePath.replace(".", "/");
        } else {
            basePath = null;
        }
        ExtractedInlineViewConfigDefinitionEntry viewConfigDescriptor = new ExtractedInlineViewConfigDefinitionEntry(viewDefinitionClass, basePath);
        return this.extractViewConfigDescriptor(viewDefinitionClass, viewConfigDescriptor);
    }

    private EditableViewConfigDescriptor extractViewConfigDescriptor(Class<? extends ViewConfig> viewDefinitionClass, ViewConfigDescriptor viewConfigDescriptor) {
        this.scanViewConfigClass(viewDefinitionClass, (ExtractedViewConfigDefinitionEntry)viewConfigDescriptor);
        Class<? extends ViewConfig> errorView = null;
        Page.ViewParameterMode viewParameterMode = Page.ViewParameterMode.DEFAULT;
        if (viewConfigDescriptor instanceof EditableViewConfigDescriptor) {
            errorView = ((EditableViewConfigDescriptor)viewConfigDescriptor).getErrorView();
            viewParameterMode = ((EditableViewConfigDescriptor)viewConfigDescriptor).getViewParameterMode();
        }
        return new DefaultViewConfigDescriptor(viewConfigDescriptor.getViewId(), viewDefinitionClass, viewConfigDescriptor.getNavigationMode(), viewParameterMode, viewConfigDescriptor.getAccessDecisionVoters(), errorView, viewConfigDescriptor.getMetaData());
    }

    private Collection<Annotation> extractViewMetaData(Class<?> targetClass, ExtractedViewConfigDefinitionEntry entry) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation annotation : targetClass.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(ViewMetaData.class)) continue;
            ViewMetaData metaData = annotation.annotationType().getAnnotation(ViewMetaData.class);
            if (entry.getFoundAndBlockedMetaDataTypes().contains(annotation.annotationType())) continue;
            result.add(annotation);
            if (!metaData.override()) continue;
            entry.blockMetaData(annotation.annotationType());
        }
        return result;
    }

    private void scanViewConfigClass(Class<?> viewDefinitionClass, ExtractedViewConfigDefinitionEntry scannedViewConfig) {
        String defaultExtension = "xhtml";
        String defaultPageName = "";
        String rootPath = "/";
        for (Class<?> currentClass = viewDefinitionClass; currentClass != null && !Object.class.getName().equals(currentClass.getName()); currentClass = currentClass.getSuperclass()) {
            if (currentClass.isAnnotationPresent(Secured.class)) {
                Secured securedAnnotation = currentClass.getAnnotation(Secured.class);
                scannedViewConfig.addAccessDecisionVoters(securedAnnotation.value());
                if (scannedViewConfig.getErrorView() == null && !DefaultErrorView.class.getName().equals(securedAnnotation.errorView().getName())) {
                    scannedViewConfig.setErrorView(securedAnnotation.errorView());
                }
            }
            scannedViewConfig.addMetaData(this.extractViewMetaData(currentClass, scannedViewConfig));
            if (currentClass.isAnnotationPresent(Page.class)) {
                Page pageAnnotation = currentClass.getAnnotation(Page.class);
                if (!pageAnnotation.extension().equals(defaultExtension)) {
                    scannedViewConfig.setExtension(pageAnnotation.extension());
                }
                if (!pageAnnotation.basePath().equals(rootPath)) {
                    String currentBasePath = pageAnnotation.basePath();
                    if (!".".equals(currentBasePath)) {
                        scannedViewConfig.setSimpleClassNameToPathMapping(currentClass.getSimpleName(), currentBasePath);
                    } else if (rootPath.equals(scannedViewConfig.getBasePath())) {
                        scannedViewConfig.setBasePath(currentBasePath);
                    }
                }
                if (!scannedViewConfig.isKnownNavigationMode() && !pageAnnotation.navigation().equals((Object)Page.NavigationMode.DEFAULT)) {
                    scannedViewConfig.setNavigationMode(pageAnnotation.navigation());
                }
                if (!scannedViewConfig.isKnownViewParameterMode() && !pageAnnotation.viewParams().equals((Object)Page.ViewParameterMode.DEFAULT)) {
                    scannedViewConfig.setViewParameterMode(pageAnnotation.viewParams());
                }
                if (!pageAnnotation.name().equals(defaultPageName)) {
                    scannedViewConfig.setPageName(pageAnnotation.name());
                }
            }
            for (Class<?> interfaceClass : currentClass.getInterfaces()) {
                this.scanViewConfigClass(interfaceClass, scannedViewConfig);
            }
        }
    }

    private boolean isResolvable(Class annotated, List<Class<? extends Annotation>> scannedAnnotations) {
        if (annotated.isAnnotation()) {
            scannedAnnotations.add(annotated);
        }
        for (Annotation annotation : annotated.getAnnotations()) {
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            if (scannedAnnotations.contains(annotationClass)) continue;
            if (Named.class.equals(annotationClass) || "javax.faces.bean.ManagedBean".equals(annotationClass.getName())) {
                return true;
            }
            if (!this.isResolvable(annotationClass, scannedAnnotations)) continue;
            return true;
        }
        return false;
    }
}

