/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.lifecycle.ClientWindow;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.application.viewstate.StateCache;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.renderkit.MyfacesResponseStateManager;
import org.apache.myfaces.spi.StateCacheProvider;
import org.apache.myfaces.spi.StateCacheProviderFactory;
import org.apache.myfaces.util.ViewNamespaceUtils;

public class HtmlResponseStateManager
extends MyfacesResponseStateManager {
    private static final Logger log = Logger.getLogger(HtmlResponseStateManager.class.getName());
    private static final String VIEW_STATE_COUNTER = "oam.partial.VIEW_STATE_COUNTER";
    private static final String CLIENT_WINDOW_COUNTER = "oam.partial.CLIENT_WINDOW_COUNTER";
    private static final String SESSION_TOKEN = "oam.rsm.SESSION_TOKEN";
    private StateCacheProvider stateCacheFactory;
    private MyfacesConfig myfacesConfig;

    public HtmlResponseStateManager() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.myfacesConfig = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext());
        this.stateCacheFactory = StateCacheProviderFactory.getStateCacheProviderFactory(facesContext.getExternalContext()).getStateCacheProvider(facesContext.getExternalContext());
    }

    public void writeState(FacesContext facesContext, Object state) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Object savedStateObject = null;
        if (!facesContext.getViewRoot().isTransient()) {
            savedStateObject = this.getStateCache(facesContext).encodeSerializedState(facesContext, state);
        }
        String viewNamespace = ViewNamespaceUtils.getViewNamespace(facesContext);
        this.writeViewStateField(facesContext, responseWriter, savedStateObject, viewNamespace);
        this.writeRenderKitIdField(facesContext, responseWriter);
        this.writeWindowIdField(facesContext, responseWriter, viewNamespace);
    }

    private void writeWindowIdField(FacesContext facesContext, ResponseWriter responseWriter, String viewNamespace) throws IOException {
        ClientWindow clientWindow = facesContext.getExternalContext().getClientWindow();
        if (clientWindow != null) {
            responseWriter.startElement("input", null);
            responseWriter.writeAttribute("type", (Object)"hidden", null);
            responseWriter.writeAttribute("id", (Object)HtmlResponseStateManager.generateUpdateClientWindowId(facesContext), null);
            responseWriter.writeAttribute("name", (Object)(viewNamespace + "jakarta.faces.ClientWindow"), null);
            responseWriter.writeAttribute("value", (Object)clientWindow.getId(), null);
            responseWriter.endElement("input");
        }
    }

    @Override
    public void saveState(FacesContext facesContext, Object state) {
        if (!facesContext.getViewRoot().isTransient()) {
            this.getStateCache(facesContext).saveSerializedView(facesContext, state);
        }
    }

    private void writeViewStateField(FacesContext facesContext, ResponseWriter responseWriter, Object savedState, String viewNamespace) throws IOException {
        String serializedState = this.getStateCache(facesContext).getStateTokenProcessor(facesContext).encode(facesContext, savedState);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Writing serialized ViewState string with hashCode: " + serializedState.hashCode());
        }
        responseWriter.startElement("input", null);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("name", (Object)(viewNamespace + "jakarta.faces.ViewState"), null);
        if (this.myfacesConfig.isRenderViewStateId()) {
            responseWriter.writeAttribute("id", (Object)HtmlResponseStateManager.generateUpdateViewStateId(facesContext), null);
        }
        responseWriter.writeAttribute("value", (Object)serializedState, null);
        if (this.myfacesConfig.isAutocompleteOffViewState()) {
            responseWriter.writeAttribute("autocomplete", (Object)"off", null);
        }
        responseWriter.endElement("input");
    }

    private void writeRenderKitIdField(FacesContext facesContext, ResponseWriter responseWriter) throws IOException {
        String defaultRenderKitId = facesContext.getApplication().getDefaultRenderKitId();
        if (defaultRenderKitId != null && !"HTML_BASIC".equals(defaultRenderKitId)) {
            responseWriter.startElement("input", null);
            responseWriter.writeAttribute("type", (Object)"hidden", null);
            responseWriter.writeAttribute("name", (Object)"jakarta.faces.RenderKitId", null);
            responseWriter.writeAttribute("value", (Object)defaultRenderKitId, null);
            responseWriter.endElement("input");
        }
    }

    public Object getState(FacesContext facesContext, String viewId) {
        Object savedState = this.getSavedState(facesContext);
        if (savedState == null) {
            return null;
        }
        return this.getStateCache(facesContext).restoreSerializedView(facesContext, viewId, savedState);
    }

    private Object getSavedState(FacesContext facesContext) {
        Object encodedState = facesContext.getExternalContext().getRequestParameterMap().get("jakarta.faces.ViewState");
        if (encodedState == null || ((String)encodedState).length() == 0) {
            return null;
        }
        Object savedStateObject = this.getStateCache(facesContext).getStateTokenProcessor(facesContext).decode(facesContext, (String)encodedState);
        return savedStateObject;
    }

    public boolean isPostback(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey("jakarta.faces.ViewState");
    }

    public String getViewState(FacesContext facesContext, Object baseState) {
        if (baseState == null) {
            return null;
        }
        if (facesContext.getViewRoot().isTransient()) {
            return null;
        }
        Object state = this.getStateCache(facesContext).saveSerializedView(facesContext, baseState);
        return this.getStateCache(facesContext).getStateTokenProcessor(facesContext).encode(facesContext, state);
    }

    public boolean isStateless(FacesContext context, String viewId) {
        if (context.isPostback()) {
            String encodedState = (String)context.getExternalContext().getRequestParameterMap().get("jakarta.faces.ViewState");
            if (encodedState == null || encodedState.length() == 0) {
                return false;
            }
            return this.getStateCache(context).getStateTokenProcessor(context).isStateless(context, encodedState);
        }
        throw new IllegalStateException("Cannot decide if the view is stateless or not, since the request is not postback (no preceding writeState(...)).");
    }

    public String getCryptographicallyStrongTokenFromSession(FacesContext context) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        String savedToken = (String)sessionMap.get(SESSION_TOKEN);
        if (savedToken == null) {
            savedToken = this.getStateCache(context).createCryptographicallyStrongTokenFromSession(context);
            sessionMap.put(SESSION_TOKEN, savedToken);
        }
        return savedToken;
    }

    @Override
    public boolean isWriteStateAfterRenderViewRequired(FacesContext facesContext) {
        return this.getStateCache(facesContext).isWriteStateAfterRenderViewRequired(facesContext);
    }

    protected StateCache getStateCache(FacesContext facesContext) {
        return this.stateCacheFactory.getStateCache(facesContext);
    }

    public static String generateUpdateClientWindowId(FacesContext facesContext) {
        char separator = facesContext.getNamingContainerSeparatorChar();
        Integer count = (Integer)facesContext.getAttributes().get(CLIENT_WINDOW_COUNTER);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        facesContext.getAttributes().put(CLIENT_WINDOW_COUNTER, count);
        String id = facesContext.getViewRoot().getContainerClientId(facesContext) + separator + "jakarta.faces.ClientWindow" + separator + count;
        return id;
    }

    public static String generateUpdateViewStateId(FacesContext facesContext) {
        char separator = facesContext.getNamingContainerSeparatorChar();
        Integer count = (Integer)facesContext.getAttributes().get(VIEW_STATE_COUNTER);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        facesContext.getAttributes().put(VIEW_STATE_COUNTER, count);
        String id = facesContext.getViewRoot().getContainerClientId(facesContext) + separator + "jakarta.faces.ViewState" + separator + count;
        return id;
    }
}

