/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.application;

import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.faces.application._NavigationUtils;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class NavigationCase {
    private String _condition;
    private String _fromAction;
    private String _fromOutcome;
    private String _fromViewId;
    private String _toViewId;
    private String _toFlowDocumentId;
    private boolean _includeViewParams;
    private boolean _redirect;
    private Map<String, List<String>> _parameters;
    private ValueExpression _conditionExpression;
    private ValueExpression _toViewIdExpression;

    public NavigationCase(String fromViewId, String fromAction, String fromOutcome, String condition, String toViewId, Map<String, List<String>> parameters, boolean redirect, boolean includeViewParams) {
        this._condition = condition;
        this._fromViewId = fromViewId;
        this._fromAction = fromAction;
        this._fromOutcome = fromOutcome;
        this._toViewId = toViewId;
        this._toFlowDocumentId = null;
        this._redirect = redirect;
        this._includeViewParams = includeViewParams;
        this._parameters = parameters;
    }

    public NavigationCase(String fromViewId, String fromAction, String fromOutcome, String condition, String toViewId, String toFlowDocumentId, Map<String, List<String>> parameters, boolean redirect, boolean includeViewParams) {
        this._condition = condition;
        this._fromViewId = fromViewId;
        this._fromAction = fromAction;
        this._fromOutcome = fromOutcome;
        this._toViewId = toViewId;
        this._toFlowDocumentId = toFlowDocumentId;
        this._redirect = redirect;
        this._includeViewParams = includeViewParams;
        this._parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NavigationCase) {
            NavigationCase c = (NavigationCase)o;
            return this.equals(this._fromViewId, c._fromViewId) && this.equals(this._fromAction, c._fromAction) && this.equals(this._fromOutcome, c._fromOutcome) && this.equals(this._condition, c._condition) && this.equals(this._toViewId, c._toViewId) && this._redirect == c._redirect && this._includeViewParams == c._includeViewParams;
        }
        return false;
    }

    public int hashCode() {
        return this.hash(this._fromViewId) << 4 ^ this.hash(this._fromAction) << 8 ^ this.hash(this._fromOutcome) << 12 ^ this.hash(this._condition) << 16 ^ this.hash(this._toViewId) << 20 ^ this.hash(this._redirect) << 24 ^ this.hash(this._includeViewParams);
    }

    public URL getActionURL(FacesContext context) throws MalformedURLException {
        ExternalContext externalContext = context.getExternalContext();
        return new URL(externalContext.getRequestScheme(), externalContext.getRequestServerName(), externalContext.getRequestServerPort(), context.getApplication().getViewHandler().getActionURL(context, this.getToViewId(context)));
    }

    public Boolean getCondition(FacesContext context) {
        if (this._condition == null) {
            return null;
        }
        ValueExpression expression = this._getConditionExpression(context);
        return Boolean.TRUE.equals(expression.getValue(context.getELContext()));
    }

    public String getFromAction() {
        return this._fromAction;
    }

    public String getFromOutcome() {
        return this._fromOutcome;
    }

    public String getFromViewId() {
        return this._fromViewId;
    }

    public URL getBookmarkableURL(FacesContext context) throws MalformedURLException {
        ExternalContext externalContext = context.getExternalContext();
        return new URL(externalContext.getRequestScheme(), externalContext.getRequestServerName(), externalContext.getRequestServerPort(), context.getApplication().getViewHandler().getBookmarkableURL(context, this.getToViewId(context), _NavigationUtils.getEvaluatedNavigationParameters(context, this.getParameters()), this.isIncludeViewParams()));
    }

    public URL getResourceURL(FacesContext context) throws MalformedURLException {
        ExternalContext externalContext = context.getExternalContext();
        return new URL(externalContext.getRequestScheme(), externalContext.getRequestServerName(), externalContext.getRequestServerPort(), context.getApplication().getViewHandler().getResourceURL(context, this.getToViewId(context)));
    }

    public URL getRedirectURL(FacesContext context) throws MalformedURLException {
        ExternalContext externalContext = context.getExternalContext();
        return new URL(externalContext.getRequestScheme(), externalContext.getRequestServerName(), externalContext.getRequestServerPort(), context.getApplication().getViewHandler().getRedirectURL(context, this.getToViewId(context), _NavigationUtils.getEvaluatedNavigationParameters(context, this.getParameters()), this.isIncludeViewParams()));
    }

    public Map<String, List<String>> getParameters() {
        return this._parameters;
    }

    public String getToViewId(FacesContext context) {
        if (this._toViewId == null) {
            return null;
        }
        ValueExpression expression = this._getToViewIdExpression(context);
        return expression.isLiteralText() ? expression.getExpressionString() : (String)expression.getValue(context.getELContext());
    }

    public boolean hasCondition() {
        return this._condition != null && this._condition.length() > 0;
    }

    public boolean isIncludeViewParams() {
        return this._includeViewParams;
    }

    public boolean isRedirect() {
        return this._redirect;
    }

    public String getToFlowDocumentId() {
        return this._toFlowDocumentId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("<navigation-case>\n");
        if (this._fromViewId != null) {
            builder.append("  ");
            builder.append("<from-view-id>");
            builder.append(this._fromViewId);
            builder.append("</from-view-id>\n");
        }
        if (this._fromAction != null) {
            builder.append("  ");
            builder.append("<from-action>");
            builder.append(this._fromAction);
            builder.append("</from-action>\n");
        }
        if (this._fromOutcome != null) {
            builder.append("  ");
            builder.append("<from-outcome>");
            builder.append(this._fromOutcome);
            builder.append("</from-outcome>\n");
        }
        if (this._condition != null) {
            builder.append("  ");
            builder.append("<if>");
            builder.append(this._condition);
            builder.append("</if>\n");
        }
        builder.append("  ");
        builder.append("<to-view-id>");
        builder.append(this._toViewId);
        builder.append("</to-view-id>\n");
        if (this._toFlowDocumentId != null) {
            builder.append("  ");
            builder.append("<to-flow-document-id>");
            builder.append(this._toFlowDocumentId);
            builder.append("</to-flow-document-id>\n");
        }
        if (this._redirect) {
            builder.append("  ");
            builder.append("<redirect include-view-params=\"");
            builder.append(this._includeViewParams);
            if (this._parameters != null && !this._parameters.isEmpty()) {
                builder.append("\">\n");
                for (Map.Entry<String, List<String>> entry : this._parameters.entrySet()) {
                    String name = entry.getKey();
                    for (String value : entry.getValue()) {
                        builder.append("    <view-param>\n");
                        builder.append("      <name>");
                        builder.append(name);
                        builder.append("</name>\n");
                        builder.append("      <value>");
                        builder.append(value);
                        builder.append("</value>\n");
                        builder.append("    </view-param>\n");
                    }
                }
                builder.append("  </redirect>\n");
            } else {
                builder.append("\"/>\n");
            }
        }
        builder.append("</navigation-case>");
        return builder.toString();
    }

    private ValueExpression _getConditionExpression(FacesContext context) {
        assert (this._condition != null);
        if (this._conditionExpression == null) {
            ExpressionFactory factory = context.getApplication().getExpressionFactory();
            this._conditionExpression = factory.createValueExpression(context.getELContext(), this._condition, Boolean.class);
        }
        return this._conditionExpression;
    }

    private ValueExpression _getToViewIdExpression(FacesContext context) {
        assert (this._toViewId != null);
        if (this._toViewIdExpression == null) {
            ExpressionFactory factory = context.getApplication().getExpressionFactory();
            this._toViewIdExpression = factory.createValueExpression(context.getELContext(), this._toViewId, String.class);
        }
        return this._toViewIdExpression;
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private int hash(Object o) {
        return o == null ? 0 : o.hashCode();
    }
}

