/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import jakarta.faces.FacesException;
import jakarta.faces.component.Doctype;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UIOutcomeTarget;
import jakarta.faces.component.UIOutput;
import jakarta.faces.component.UIParameter;
import jakarta.faces.component.UISelectBoolean;
import jakarta.faces.component.UISelectMany;
import jakarta.faces.component.UISelectOne;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.html.HtmlDataTable;
import jakarta.faces.component.html.HtmlMessages;
import jakarta.faces.component.html.HtmlPanelGrid;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.model.SelectItem;
import jakarta.faces.model.SelectItemGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.component.visit.MyFacesVisitHints;
import org.apache.myfaces.core.api.shared.AttributeUtils;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.core.api.shared.SharedRendererUtils;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HTMLEncoder;
import org.apache.myfaces.renderkit.html.util.HtmlJavaScriptUtils;
import org.apache.myfaces.renderkit.html.util.OutcomeTargetUtils;
import org.apache.myfaces.renderkit.html.util.SelectItemInfo;
import org.apache.myfaces.renderkit.html.util.SelectItemsUtils;

public final class HtmlRendererUtils {
    private static final Logger log = Logger.getLogger(HtmlRendererUtils.class.getName());
    private static final char TABULATOR = '\t';
    public static final String HIDDEN_COMMANDLINK_FIELD_NAME = "_idcl";
    public static final String CLEAR_HIDDEN_FIELD_FN_NAME = "clearFormHiddenParams";
    public static final String SUBMIT_FORM_FN_NAME_JSF2 = "myfaces.oam.submitForm";
    public static final String NON_SUBMITTED_VALUE_WARNING = "There should always be a submitted value for an input if it is rendered, its form is submitted, and it was not originally rendered disabled or read-only.  You cannot submit a form after disabling an input element via javascript.  Consider setting read-only to true instead or resetting the disabled value back to false prior to form submission.";

    private HtmlRendererUtils() {
    }

    public static void decodeUIInput(FacesContext facesContext, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map<String, String> paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = component.getClientId(facesContext);
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        if (paramMap.containsKey(clientId)) {
            ((EditableValueHolder)((Object)component)).setSubmittedValue(paramMap.get(clientId));
        } else {
            log.warning("There should always be a submitted value for an input if it is rendered, its form is submitted, and it was not originally rendered disabled or read-only.  You cannot submit a form after disabling an input element via javascript.  Consider setting read-only to true instead or resetting the disabled value back to false prior to form submission. Component : " + ComponentUtils.getPathToComponent(component));
        }
    }

    public static void decodeUISelectBoolean(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        Map<String, String> paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(facesContext))) {
            String reqValue = paramMap.get(clientId);
            if (reqValue.equalsIgnoreCase("on") || reqValue.equalsIgnoreCase("yes") || reqValue.equalsIgnoreCase("true")) {
                ((EditableValueHolder)((Object)component)).setSubmittedValue(Boolean.TRUE);
            } else {
                ((EditableValueHolder)((Object)component)).setSubmittedValue(Boolean.FALSE);
            }
        } else {
            ((EditableValueHolder)((Object)component)).setSubmittedValue(Boolean.FALSE);
        }
    }

    public static boolean isDisabledOrReadOnly(UIComponent component) {
        return HtmlRendererUtils.isDisabled(component) || HtmlRendererUtils.isReadOnly(component);
    }

    public static boolean isDisabled(UIComponent component) {
        return HtmlRendererUtils.isTrue(component.getAttributes().get("disabled"));
    }

    public static boolean isReadOnly(UIComponent component) {
        return HtmlRendererUtils.isTrue(component.getAttributes().get("readonly"));
    }

    private static boolean isTrue(Object obj) {
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        if (!(obj instanceof Boolean)) {
            return false;
        }
        return (Boolean)obj;
    }

    public static void decodeUISelectMany(FacesContext facesContext, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map<String, String[]> paramValuesMap = facesContext.getExternalContext().getRequestParameterValuesMap();
        String clientId = component.getClientId(facesContext);
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        if (paramValuesMap.containsKey(clientId)) {
            ArrayList<String> reqValues = new ArrayList<String>(Arrays.asList(paramValuesMap.get(clientId)));
            List<SelectItemInfo> selections = SelectItemsUtils.getSelectItemInfoList((UISelectMany)component, facesContext);
            for (SelectItemInfo itemInfo : selections) {
                String result;
                if (!itemInfo.getItem().isDisabled() || !reqValues.contains(result = SharedRendererUtils.getConvertedStringValue(facesContext, component, ((ValueHolder)((Object)component)).getConverter(), itemInfo.getItem().getValue()))) continue;
                reqValues.remove(result);
            }
            String[] submittedValue = reqValues.toArray(new String[reqValues.size()]);
            ((EditableValueHolder)((Object)component)).setSubmittedValue(submittedValue);
        } else {
            ((EditableValueHolder)((Object)component)).setSubmittedValue(new String[0]);
        }
    }

    public static void decodeUISelectOne(FacesContext facesContext, UIComponent component) {
        String group;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        Map<String, String> paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (component instanceof UISelectOne && (group = ((UISelectOne)component).getGroup()) != null && !group.isEmpty()) {
            String submittedValueNamespace;
            String submittedValue;
            UIForm form = ComponentUtils.findClosest(UIForm.class, component);
            String fullGroupId = form.getClientId(facesContext) + facesContext.getNamingContainerSeparatorChar() + group;
            if (paramMap.containsKey(fullGroupId) && (submittedValue = paramMap.get(fullGroupId)).startsWith(submittedValueNamespace = component.getClientId(facesContext) + facesContext.getNamingContainerSeparatorChar())) {
                submittedValue = submittedValue.substring(submittedValueNamespace.length());
                SelectOneGroupSetSubmittedValueCallback callback = new SelectOneGroupSetSubmittedValueCallback(group, submittedValue, component.getClientId(facesContext), component.getValueExpression("value") != null);
                form.visitTree(VisitContext.createVisitContext(facesContext, null, MyFacesVisitHints.SET_SKIP_UNRENDERED), callback);
            }
            return;
        }
        String clientId = component.getClientId(facesContext);
        if (paramMap.containsKey(clientId)) {
            String submittedValue = paramMap.get(clientId);
            List<SelectItemInfo> selections = SelectItemsUtils.getSelectItemInfoList((UISelectOne)component, facesContext);
            for (SelectItemInfo itemInfo : selections) {
                if (!itemInfo.getItem().isDisabled()) continue;
                Object selectItemValue = itemInfo.getItem().getValue();
                String convertedValue = SharedRendererUtils.getConvertedStringValue(facesContext, component, ((ValueHolder)((Object)component)).getConverter(), selectItemValue);
                if (!convertedValue.equals(selectItemValue)) continue;
                submittedValue = "";
            }
            ((EditableValueHolder)((Object)component)).setSubmittedValue(submittedValue);
        } else {
            ((EditableValueHolder)((Object)component)).setSubmittedValue("");
        }
    }

    public static void renderListbox(FacesContext facesContext, UISelectOne selectOne, boolean disabled, int size, Converter converter) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, selectOne, disabled, size, false, converter);
    }

    public static void renderListbox(FacesContext facesContext, UISelectMany selectMany, boolean disabled, int size, Converter converter) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, selectMany, disabled, size, true, converter);
    }

    public static void renderMenu(FacesContext facesContext, UISelectOne selectOne, boolean disabled, Converter converter) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, selectOne, disabled, 1, false, converter);
    }

    public static void renderMenu(FacesContext facesContext, UISelectMany selectMany, boolean disabled, Converter converter) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, selectMany, disabled, 1, true, converter);
    }

    private static void internalRenderSelect(FacesContext facesContext, UIComponent uiComponent, boolean disabled, int size, boolean selectMany, Converter converter) throws IOException {
        List<SelectItem> selectItemList;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("select", uiComponent);
        if (uiComponent instanceof ClientBehaviorHolder && !((ClientBehaviorHolder)((Object)uiComponent)).getClientBehaviors().isEmpty()) {
            writer.writeAttribute("id", uiComponent.getClientId(facesContext), null);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        }
        writer.writeAttribute("name", uiComponent.getClientId(facesContext), null);
        if (selectMany) {
            writer.writeAttribute("multiple", "multiple", null);
            selectItemList = RendererUtils.getSelectItemList((UISelectMany)uiComponent, facesContext);
        } else {
            selectItemList = RendererUtils.getSelectItemList((UISelectOne)uiComponent, facesContext);
        }
        if (size == Integer.MIN_VALUE) {
            writer.writeAttribute("size", Integer.toString(selectItemList.size()), null);
        } else {
            writer.writeAttribute("size", Integer.toString(size), null);
        }
        if (uiComponent instanceof ClientBehaviorHolder) {
            Map<String, List<ClientBehavior>> behaviors = ((ClientBehaviorHolder)((Object)uiComponent)).getClientBehaviors();
            HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        }
        if (disabled) {
            writer.writeAttribute("disabled", "disabled", null);
        }
        if (HtmlRendererUtils.isReadOnly(uiComponent)) {
            writer.writeAttribute("readonly", "readonly", null);
        }
        Set lookupSet = HtmlRendererUtils.getSubmittedOrSelectedValuesAsSet(selectMany, uiComponent, facesContext, converter);
        HtmlRendererUtils.renderSelectOptions(facesContext, uiComponent, converter, lookupSet, selectItemList);
        writer.writeText("", null);
        writer.endElement("select");
    }

    public static Set getSubmittedOrSelectedValuesAsSet(boolean selectMany, UIComponent uiComponent, FacesContext facesContext, Converter converter) {
        Set<String> lookupSet;
        if (selectMany) {
            UISelectMany uiSelectMany = (UISelectMany)uiComponent;
            lookupSet = RendererUtils.getSubmittedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
            if (lookupSet == null) {
                lookupSet = RendererUtils.getSelectedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
            }
        } else {
            UISelectOne uiSelectOne = (UISelectOne)uiComponent;
            Object lookup = uiSelectOne.getSubmittedValue();
            if (lookup == null) {
                lookup = uiSelectOne.getValue();
                String lookupString = SharedRendererUtils.getConvertedStringValue(facesContext, uiComponent, converter, lookup);
                lookupSet = Collections.singleton(lookupString);
            } else {
                lookupSet = "".equals(lookup) ? Collections.EMPTY_SET : Collections.singleton(lookup);
            }
        }
        return lookupSet;
    }

    public static Converter findUISelectManyConverterFailsafe(FacesContext facesContext, UIComponent uiComponent) {
        return HtmlRendererUtils.findUISelectManyConverterFailsafe(facesContext, uiComponent, false);
    }

    public static Converter findUISelectManyConverterFailsafe(FacesContext facesContext, UIComponent uiComponent, boolean considerValueType) {
        Converter converter;
        try {
            converter = RendererUtils.findUISelectManyConverter(facesContext, (UISelectMany)uiComponent, considerValueType);
        }
        catch (FacesException e) {
            log.log(Level.SEVERE, "Error finding Converter for component with id " + uiComponent.getClientId(facesContext), e);
            converter = null;
        }
        return converter;
    }

    public static Converter findUIOutputConverterFailSafe(FacesContext facesContext, UIComponent uiComponent) {
        Converter converter;
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, (UIOutput)uiComponent);
        }
        catch (FacesException e) {
            log.log(Level.SEVERE, "Error finding Converter for component with id " + uiComponent.getClientId(facesContext) + " " + ComponentUtils.getPathToComponent(uiComponent), e);
            converter = null;
        }
        return converter;
    }

    public static void renderSelectOptions(FacesContext context, UIComponent component, Converter converter, Set lookupSet, List selectItemList) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean hideNoSelectionOption = HtmlRendererUtils.isHideNoSelectionOption(component);
        boolean componentDisabled = HtmlRendererUtils.isTrue(component.getAttributes().get("disabled"));
        for (int i = 0; i < selectItemList.size(); ++i) {
            boolean escape;
            boolean disabled;
            SelectItem selectItem = (SelectItem)selectItemList.get(i);
            if (selectItem instanceof SelectItemGroup) {
                writer.startElement("optgroup", null);
                writer.writeAttribute("label", selectItem.getLabel(), null);
                SelectItem[] selectItems = ((SelectItemGroup)selectItem).getSelectItems();
                HtmlRendererUtils.renderSelectOptions(context, component, converter, lookupSet, Arrays.asList(selectItems));
                writer.endElement("optgroup");
                continue;
            }
            String itemStrValue = SharedRendererUtils.getConvertedStringValue(context, component, converter, selectItem);
            boolean selected = lookupSet.contains(itemStrValue);
            if (hideNoSelectionOption && selectItem.isNoSelectionOption() && !lookupSet.isEmpty() && (lookupSet.size() != 1 || !lookupSet.contains("")) && !selected) continue;
            writer.write(9);
            writer.startElement("option", null);
            if (itemStrValue != null) {
                writer.writeAttribute("value", itemStrValue, null);
            } else {
                writer.writeAttribute("value", "", null);
            }
            if (selected) {
                writer.writeAttribute("selected", "selected", null);
            }
            if (disabled = selectItem.isDisabled()) {
                writer.writeAttribute("disabled", "disabled", null);
            }
            String labelClass = null;
            labelClass = componentDisabled || disabled ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
            if (labelClass != null) {
                writer.writeAttribute("class", labelClass, "labelClass");
            }
            if ((escape = AttributeUtils.getBooleanAttribute(component, "escape", false)) || selectItem.isEscape()) {
                writer.writeText(selectItem.getLabel(), null);
            } else {
                writer.write(selectItem.getLabel());
            }
            writer.endElement("option");
        }
    }

    public static boolean renderHTMLAttribute(ResponseWriter writer, String componentProperty, String attrName, Object value) throws IOException {
        if (attrName.equals("onchange") && value != null && value.toString().length() == 0) {
            return false;
        }
        if (!RendererUtils.isDefaultAttributeValue(value)) {
            String htmlAttrName = attrName.equals("styleClass") ? "class" : attrName;
            writer.writeAttribute(htmlAttrName, value, componentProperty);
            return true;
        }
        return false;
    }

    public static boolean renderHTMLAttribute(ResponseWriter writer, UIComponent component, String componentProperty, String htmlAttrName) throws IOException {
        Object value = component.getAttributes().get(componentProperty);
        return HtmlRendererUtils.renderHTMLAttribute(writer, componentProperty, htmlAttrName, value);
    }

    public static boolean renderHTMLAttributes(ResponseWriter writer, UIComponent component, String[] attributes) throws IOException {
        boolean somethingDone = false;
        for (String attrName : attributes) {
            if (!HtmlRendererUtils.renderHTMLAttribute(writer, component, attrName, attrName)) continue;
            somethingDone = true;
        }
        return somethingDone;
    }

    public static boolean renderHTMLAttributeWithOptionalStartElement(ResponseWriter writer, UIComponent component, String elementName, String attrName, Object value, boolean startElementWritten) throws IOException {
        if (!RendererUtils.isDefaultAttributeValue(value)) {
            if (!startElementWritten) {
                writer.startElement(elementName, component);
                startElementWritten = true;
            }
            HtmlRendererUtils.renderHTMLAttribute(writer, attrName, attrName, value);
        }
        return startElementWritten;
    }

    public static boolean renderHTMLAttributesWithOptionalStartElement(ResponseWriter writer, UIComponent component, String elementName, String[] attributes) throws IOException {
        boolean startElementWritten = false;
        for (String attrName : attributes) {
            Object value = component.getAttributes().get(attrName);
            if (RendererUtils.isDefaultAttributeValue(value)) continue;
            if (!startElementWritten) {
                writer.startElement(elementName, component);
                startElementWritten = true;
            }
            HtmlRendererUtils.renderHTMLAttribute(writer, attrName, attrName, value);
        }
        return startElementWritten;
    }

    public static boolean renderOptionalEndElement(ResponseWriter writer, UIComponent component, String elementName, String[] attributes) throws IOException {
        boolean endElementNeeded = false;
        for (String attrName : attributes) {
            Object value = component.getAttributes().get(attrName);
            if (RendererUtils.isDefaultAttributeValue(value)) continue;
            endElementNeeded = true;
            break;
        }
        if (endElementNeeded) {
            writer.endElement(elementName);
            return true;
        }
        return false;
    }

    public static void writeId(ResponseWriter writer, UIComponent component, FacesContext facesContext) throws IOException {
        writer.writeAttribute("id", component.getClientId(facesContext), null);
    }

    public static void writeIdIfNecessary(ResponseWriter writer, UIComponent component, FacesContext facesContext) throws IOException {
        String id = component.getId();
        if (id != null && !id.startsWith("j_id")) {
            writer.writeAttribute("id", component.getClientId(facesContext), null);
        }
    }

    public static void writeIdAndNameIfNecessary(ResponseWriter writer, UIComponent component, FacesContext facesContext) throws IOException {
        if (component.getId() != null && !component.getId().startsWith("j_id")) {
            String clientId = component.getClientId(facesContext);
            writer.writeAttribute("id", clientId, null);
            writer.writeAttribute("name", clientId, null);
        }
    }

    public static final boolean renderHTMLStringPreserveEmptyAttribute(ResponseWriter writer, UIComponent component, String componentProperty, String htmlAttrName) throws IOException {
        String value = (String)component.getAttributes().get(componentProperty);
        if (value != null) {
            writer.writeAttribute(htmlAttrName, value, componentProperty);
            return true;
        }
        return false;
    }

    public static boolean renderHTMLStringPreserveEmptyAttribute(ResponseWriter writer, String componentProperty, String htmlAttrName, String value) throws IOException {
        if (value != null) {
            writer.writeAttribute(htmlAttrName, value, componentProperty);
            return true;
        }
        return false;
    }

    public static boolean renderHTMLStringAttribute(ResponseWriter writer, UIComponent component, String componentProperty, String htmlAttrName) throws IOException {
        String value = (String)component.getAttributes().get(componentProperty);
        if (value != null && !value.isEmpty()) {
            writer.writeAttribute(htmlAttrName, value, componentProperty);
            return true;
        }
        return false;
    }

    public static boolean renderHTMLStringAttribute(ResponseWriter writer, String componentProperty, String htmlAttrName, String value) throws IOException {
        if (value != null && !value.isEmpty()) {
            writer.writeAttribute(htmlAttrName, value, componentProperty);
            return true;
        }
        return false;
    }

    public static boolean renderHTMLStringNoStyleAttributes(ResponseWriter writer, UIComponent component, String[] attributes) throws IOException {
        boolean somethingDone = false;
        for (String attrName : attributes) {
            if (!HtmlRendererUtils.renderHTMLStringAttribute(writer, component, attrName, attrName)) continue;
            somethingDone = true;
        }
        return somethingDone;
    }

    public static void writeIdAndName(ResponseWriter writer, UIComponent component, FacesContext facesContext) throws IOException {
        String clientId = component.getClientId(facesContext);
        writer.writeAttribute("id", clientId, null);
        writer.writeAttribute("name", clientId, null);
    }

    public static void renderDisplayValueOnlyForSelects(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        HtmlRendererUtils.renderDisplayValueOnlyForSelects(facesContext, uiComponent, false);
    }

    public static void renderDisplayValueOnlyForSelects(FacesContext facesContext, UIComponent uiComponent, boolean considerValueType) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        List<SelectItem> selectItemList = null;
        Converter converter = null;
        boolean isSelectOne = false;
        if (uiComponent instanceof UISelectBoolean) {
            converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, uiComponent);
            writer.startElement("span", uiComponent);
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            writer.writeText(SharedRendererUtils.getConvertedStringValue(facesContext, uiComponent, converter, ((UISelectBoolean)uiComponent).getValue()), "value");
            writer.endElement("span");
        } else {
            if (uiComponent instanceof UISelectMany) {
                isSelectOne = false;
                selectItemList = RendererUtils.getSelectItemList((UISelectMany)uiComponent, facesContext);
                converter = HtmlRendererUtils.findUISelectManyConverterFailsafe(facesContext, uiComponent, considerValueType);
            } else if (uiComponent instanceof UISelectOne) {
                isSelectOne = true;
                selectItemList = RendererUtils.getSelectItemList((UISelectOne)uiComponent, facesContext);
                converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, uiComponent);
            }
            writer.startElement(isSelectOne ? "span" : "ul", uiComponent);
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            Set lookupSet = HtmlRendererUtils.getSubmittedOrSelectedValuesAsSet(uiComponent instanceof UISelectMany, uiComponent, facesContext, converter);
            HtmlRendererUtils.renderSelectOptionsAsText(facesContext, uiComponent, converter, lookupSet, selectItemList, isSelectOne);
            writer.writeText("", null);
            writer.endElement(isSelectOne ? "span" : "ul");
        }
    }

    private static void renderSelectOptionsAsText(FacesContext context, UIComponent component, Converter converter, Set lookupSet, List selectItemList, boolean isSelectOne) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (int i = 0; i < selectItemList.size(); ++i) {
            SelectItem selectItem = (SelectItem)selectItemList.get(i);
            if (selectItem instanceof SelectItemGroup) {
                SelectItem[] selectItems = ((SelectItemGroup)selectItem).getSelectItems();
                HtmlRendererUtils.renderSelectOptionsAsText(context, component, converter, lookupSet, Arrays.asList(selectItems), isSelectOne);
                continue;
            }
            String itemStrValue = SharedRendererUtils.getConvertedStringValue(context, component, converter, selectItem);
            if (!lookupSet.contains(itemStrValue)) continue;
            if (!isSelectOne) {
                writer.startElement("li", null);
            }
            writer.writeText(selectItem.getLabel(), null);
            if (!isSelectOne) {
                writer.endElement("li");
            }
            if (!isSelectOne) continue;
            return;
        }
    }

    public static void renderTableCaption(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        String captionStyle;
        String captionClass;
        UIComponent captionFacet = component.getFacet("caption");
        if (captionFacet == null) {
            return;
        }
        if (component instanceof HtmlPanelGrid) {
            HtmlPanelGrid panelGrid = (HtmlPanelGrid)component;
            captionClass = panelGrid.getCaptionClass();
            captionStyle = panelGrid.getCaptionStyle();
        } else if (component instanceof HtmlDataTable) {
            HtmlDataTable dataTable = (HtmlDataTable)component;
            captionClass = dataTable.getCaptionClass();
            captionStyle = dataTable.getCaptionStyle();
        } else {
            captionClass = (String)component.getAttributes().get("captionClass");
            captionStyle = (String)component.getAttributes().get("captionStyle");
        }
        writer.startElement("caption", null);
        if (captionClass != null) {
            writer.writeAttribute("class", captionClass, null);
        }
        if (captionStyle != null) {
            writer.writeAttribute("style", captionStyle, null);
        }
        captionFacet.encodeAll(context);
        writer.endElement("caption");
    }

    public static void renderDisplayValueOnly(FacesContext facesContext, UIInput input) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("span", input);
        HtmlRendererUtils.writeIdIfNecessary(writer, input, facesContext);
        String strValue = RendererUtils.getStringValue(facesContext, input);
        writer.write(HTMLEncoder.encode(facesContext, strValue, true, true));
        writer.endElement("span");
    }

    public static void appendClearHiddenCommandFormParamsFunctionCall(StringBuilder buf, String formName) {
        HtmlJavaScriptUtils.appendClearHiddenCommandFormParamsFunctionCall(buf, formName);
    }

    public static void renderFormSubmitScript(FacesContext facesContext) throws IOException {
        HtmlJavaScriptUtils.renderFormSubmitScript(facesContext);
    }

    public static void renderHiddenCommandFormParams(ResponseWriter writer, Set dummyFormParams) throws IOException {
        for (Object name : dummyFormParams) {
            HtmlRendererUtils.renderHiddenInputField(writer, name, null);
        }
    }

    public static void renderHiddenInputField(ResponseWriter writer, Object name, Object value) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", null);
        writer.writeAttribute("name", name, null);
        if (value != null) {
            writer.writeAttribute("value", value, null);
        }
        writer.endElement("input");
    }

    public static void renderLabel(ResponseWriter writer, UIComponent component, String forClientId, SelectItem item, boolean disabled) throws IOException {
        writer.startElement("label", null);
        writer.writeAttribute("for", forClientId, null);
        String labelClass = null;
        labelClass = disabled ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
        if (labelClass != null) {
            writer.writeAttribute("class", labelClass, "labelClass");
        }
        if (item.getLabel() != null && item.getLabel().length() > 0) {
            writer.write(" ");
            if (item.isEscape()) {
                writer.writeText(item.getLabel(), null);
            } else {
                writer.write(item.getLabel());
            }
        }
        writer.endElement("label");
    }

    public static void renderLabel(ResponseWriter writer, UIComponent component, String forClientId, SelectItem item, boolean disabled, boolean selected) throws IOException {
        writer.startElement("label", null);
        writer.writeAttribute("for", forClientId, null);
        Object labelClass = null;
        labelClass = disabled ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
        String labelSelectedClass = null;
        labelSelectedClass = selected ? (String)component.getAttributes().get("selectedClass") : (String)component.getAttributes().get("unselectedClass");
        if (labelSelectedClass != null) {
            labelClass = labelClass == null ? labelSelectedClass : (String)labelClass + " " + labelSelectedClass;
        }
        if (labelClass != null) {
            writer.writeAttribute("class", labelClass, "labelClass");
        }
        if (item.getLabel() != null && item.getLabel().length() > 0) {
            writer.write("&#160;");
            if (item.isEscape()) {
                writer.writeText(item.getLabel(), null);
            } else {
                writer.write(item.getLabel());
            }
        }
        writer.endElement("label");
    }

    public static String getHiddenCommandLinkFieldName(UIComponent form, FacesContext facesContext) {
        return form.getClientId(facesContext) + ":_idcl";
    }

    public static boolean isPartialOrBehaviorSubmit(FacesContext facesContext, String clientId) {
        Map<String, String> params = facesContext.getExternalContext().getRequestParameterMap();
        String sourceId = params.get("jakarta.faces.source");
        if (sourceId == null || !sourceId.equals(clientId)) {
            return false;
        }
        boolean partialOrBehaviorSubmit = false;
        String behaviorEvent = params.get("jakarta.faces.behavior.event");
        if (behaviorEvent != null && (partialOrBehaviorSubmit = "action".equals(behaviorEvent))) {
            return partialOrBehaviorSubmit;
        }
        String partialEvent = params.get("jakarta.faces.partial.event");
        if (partialEvent != null) {
            partialOrBehaviorSubmit = "click".equals(partialEvent);
        }
        return partialOrBehaviorSubmit;
    }

    public static String getOutcomeTargetHref(FacesContext facesContext, UIOutcomeTarget component) throws IOException {
        return OutcomeTargetUtils.getOutcomeTargetHref(facesContext, component);
    }

    public static Map<String, String> mapAttachedParamsToStringValues(FacesContext facesContext, UIComponent uiComponent) {
        Map<String, String> retVal = null;
        if (uiComponent.getChildCount() > 0) {
            List<UIParameter> validParams = HtmlRendererUtils.getValidUIParameterChildren(facesContext, uiComponent.getChildren(), true, true);
            int size = validParams.size();
            for (int i = 0; i < size; ++i) {
                UIParameter param = validParams.get(i);
                String name = param.getName();
                Object value = param.getValue();
                if (retVal == null) {
                    retVal = new HashMap<String, String>(3);
                }
                if (value instanceof String) {
                    retVal.put(name, (String)value);
                    continue;
                }
                retVal.put(name, value.toString());
            }
        }
        if (retVal == null) {
            retVal = Collections.emptyMap();
        }
        return retVal;
    }

    public static List<UIParameter> getValidUIParameterChildren(FacesContext facesContext, List<UIComponent> children, boolean skipNullValue, boolean skipUnrendered) {
        return HtmlRendererUtils.getValidUIParameterChildren(facesContext, children, skipNullValue, skipUnrendered, true);
    }

    public static List<UIParameter> getValidUIParameterChildren(FacesContext facesContext, List<UIComponent> children, boolean skipNullValue, boolean skipUnrendered, boolean skipNullName) {
        return OutcomeTargetUtils.getValidUIParameterChildren(facesContext, children, skipNullValue, skipUnrendered, skipNullName);
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String eventName, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, eventName, clientBehaviors, componentProperty);
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String sourceId, String eventName, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, sourceId, eventName, clientBehaviors, componentProperty);
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String eventName, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName) throws IOException {
        return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, eventName, null, clientBehaviors, htmlAttrName, (String)component.getAttributes().get(componentProperty));
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String sourceId, String eventName, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName) throws IOException {
        return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, sourceId, eventName, null, clientBehaviors, htmlAttrName, (String)component.getAttributes().get(componentProperty));
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue) throws IOException {
        return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, null, eventName, eventParameters, clientBehaviors, htmlAttrName, attributeValue);
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String sourceId, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue) throws IOException {
        List<ClientBehavior> cbl;
        List<ClientBehavior> list = cbl = clientBehaviors != null ? clientBehaviors.get(eventName) : null;
        if (cbl == null || cbl.isEmpty()) {
            return HtmlRendererUtils.renderHTMLAttribute(writer, componentProperty, htmlAttrName, (Object)attributeValue);
        }
        if (cbl.size() > 1 || cbl.size() == 1 && attributeValue != null) {
            return HtmlRendererUtils.renderHTMLAttribute(writer, componentProperty, htmlAttrName, (Object)ClientBehaviorRendererUtils.buildBehaviorChain(facesContext, component, sourceId, eventName, eventParameters, clientBehaviors, attributeValue, ""));
        }
        return HtmlRendererUtils.renderHTMLAttribute(writer, componentProperty, htmlAttrName, (Object)cbl.get(0).getScript(ClientBehaviorContext.createClientBehaviorContext(facesContext, component, eventName, sourceId, eventParameters)));
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue, String serverSideScript) throws IOException {
        return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, null, eventName, eventParameters, clientBehaviors, htmlAttrName, attributeValue, serverSideScript);
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String sourceId, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue, String serverSideScript) throws IOException {
        List<ClientBehavior> cbl = clientBehaviors != null ? clientBehaviors.get(eventName) : null;
        if ((cbl != null ? cbl.size() : 0) + (attributeValue != null ? 1 : 0) + (serverSideScript != null ? 1 : 0) <= 1) {
            if (cbl == null || cbl.isEmpty()) {
                if (attributeValue != null) {
                    return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, attributeValue);
                }
                return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, serverSideScript);
            }
            return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, cbl.get(0).getScript(ClientBehaviorContext.createClientBehaviorContext(facesContext, component, eventName, sourceId, eventParameters)));
        }
        return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, ClientBehaviorRendererUtils.buildBehaviorChain(facesContext, component, sourceId, eventName, eventParameters, clientBehaviors, attributeValue, serverSideScript));
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, String eventName2, Collection<ClientBehaviorContext.Parameter> eventParameters2, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue, String serverSideScript) throws IOException {
        return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, null, eventName, eventParameters, eventName2, eventParameters2, clientBehaviors, htmlAttrName, attributeValue, serverSideScript);
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String sourceId, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, String eventName2, Collection<ClientBehaviorContext.Parameter> eventParameters2, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue, String serverSideScript) throws IOException {
        List<ClientBehavior> cb2;
        List<ClientBehavior> cb1 = clientBehaviors != null ? clientBehaviors.get(eventName) : null;
        if ((cb1 != null ? cb1.size() : 0) + ((cb2 = clientBehaviors != null ? clientBehaviors.get(eventName2) : null) != null ? cb2.size() : 0) + (attributeValue != null ? 1 : 0) <= 1) {
            if (attributeValue != null) {
                return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, attributeValue);
            }
            if (serverSideScript != null) {
                return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, serverSideScript);
            }
            if ((cb1 != null ? cb1.size() : 0) > 0) {
                return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, cb1.get(0).getScript(ClientBehaviorContext.createClientBehaviorContext(facesContext, component, eventName, sourceId, eventParameters)));
            }
            return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, cb2.get(0).getScript(ClientBehaviorContext.createClientBehaviorContext(facesContext, component, eventName2, sourceId, eventParameters2)));
        }
        return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, ClientBehaviorRendererUtils.buildBehaviorChain(facesContext, component, sourceId, eventName, eventParameters, eventName2, eventParameters2, clientBehaviors, attributeValue, serverSideScript));
    }

    public static void renderBehaviorizedEventHandlers(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, null, clientBehaviors);
    }

    public static void renderBehaviorizedEventHandlers(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, String sourceId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onclick", uiComponent, sourceId, "click", clientBehaviors, "onclick");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "ondblclick", uiComponent, sourceId, "dblclick", clientBehaviors, "ondblclick");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousedown", uiComponent, sourceId, "mousedown", clientBehaviors, "onmousedown");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseup", uiComponent, sourceId, "mouseup", clientBehaviors, "onmouseup");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseover", uiComponent, sourceId, "mouseover", clientBehaviors, "onmouseover");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousemove", uiComponent, sourceId, "mousemove", clientBehaviors, "onmousemove");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseout", uiComponent, sourceId, "mouseout", clientBehaviors, "onmouseout");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeypress", uiComponent, sourceId, "keypress", clientBehaviors, "onkeypress");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeydown", uiComponent, sourceId, "keydown", clientBehaviors, "onkeydown");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeyup", uiComponent, sourceId, "keyup", clientBehaviors, "onkeyup");
    }

    public static void renderBehaviorizedEventHandlersWithoutOnclick(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "ondblclick", uiComponent, "dblclick", clientBehaviors, "ondblclick");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousedown", uiComponent, "mousedown", clientBehaviors, "onmousedown");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseup", uiComponent, "mouseup", clientBehaviors, "onmouseup");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseover", uiComponent, "mouseover", clientBehaviors, "onmouseover");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousemove", uiComponent, "mousemove", clientBehaviors, "onmousemove");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseout", uiComponent, "mouseout", clientBehaviors, "onmouseout");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeypress", uiComponent, "keypress", clientBehaviors, "onkeypress");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeydown", uiComponent, "keydown", clientBehaviors, "onkeydown");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeyup", uiComponent, "keyup", clientBehaviors, "onkeyup");
    }

    public static void renderBehaviorizedEventHandlersWithoutOnmouseoverAndOnmouseout(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onclick", uiComponent, "click", clientBehaviors, "onclick");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "ondblclick", uiComponent, "dblclick", clientBehaviors, "ondblclick");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousedown", uiComponent, "mousedown", clientBehaviors, "onmousedown");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseup", uiComponent, "mouseup", clientBehaviors, "onmouseup");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmousemove", uiComponent, "mousemove", clientBehaviors, "onmousemove");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeypress", uiComponent, "keypress", clientBehaviors, "onkeypress");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeydown", uiComponent, "keydown", clientBehaviors, "onkeydown");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onkeyup", uiComponent, "keyup", clientBehaviors, "onkeyup");
    }

    public static void renderBehaviorizedFieldEventHandlers(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onfocus", uiComponent, "focus", clientBehaviors, "onfocus");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, "blur", clientBehaviors, "onblur");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, "change", clientBehaviors, "onchange");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onselect", uiComponent, "select", clientBehaviors, "onselect");
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnfocus(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, "blur", clientBehaviors, "onblur");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, "change", clientBehaviors, "onchange");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onselect", uiComponent, "select", clientBehaviors, "onselect");
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnchange(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onfocus", uiComponent, "focus", clientBehaviors, "onfocus");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, "blur", clientBehaviors, "onblur");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onselect", uiComponent, "select", clientBehaviors, "onselect");
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnchange(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, String sourceId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onfocus", uiComponent, sourceId, "focus", clientBehaviors, "onfocus");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, sourceId, "blur", clientBehaviors, "onblur");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onselect", uiComponent, sourceId, "select", clientBehaviors, "onselect");
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onfocus", uiComponent, "focus", clientBehaviors, "onfocus");
        HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, "blur", clientBehaviors, "onblur");
    }

    public static boolean renderBehaviorizedOnchangeEventHandler(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        boolean hasChange = ClientBehaviorRendererUtils.hasClientBehavior("change", clientBehaviors);
        boolean hasValueChange = ClientBehaviorRendererUtils.hasClientBehavior("valueChange", clientBehaviors);
        if (hasChange && hasValueChange) {
            String chain = ClientBehaviorRendererUtils.buildBehaviorChain(facesContext, uiComponent, "change", null, "valueChange", null, clientBehaviors, (String)uiComponent.getAttributes().get("onchange"), null);
            return HtmlRendererUtils.renderHTMLStringAttribute(writer, "onchange", "onchange", chain);
        }
        if (hasChange) {
            return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, "change", clientBehaviors, "onchange");
        }
        if (hasValueChange) {
            return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, "valueChange", clientBehaviors, "onchange");
        }
        return HtmlRendererUtils.renderHTMLStringAttribute(writer, uiComponent, "onchange", "onchange");
    }

    public static boolean renderBehaviorizedOnchangeEventHandler(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, String sourceId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        boolean hasChange = ClientBehaviorRendererUtils.hasClientBehavior("change", clientBehaviors);
        boolean hasValueChange = ClientBehaviorRendererUtils.hasClientBehavior("valueChange", clientBehaviors);
        if (hasChange && hasValueChange) {
            String chain = ClientBehaviorRendererUtils.buildBehaviorChain(facesContext, uiComponent, sourceId, "change", null, "valueChange", null, clientBehaviors, (String)uiComponent.getAttributes().get("onchange"), null);
            return HtmlRendererUtils.renderHTMLStringAttribute(writer, "onchange", "onchange", chain);
        }
        if (hasChange) {
            return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, sourceId, "change", clientBehaviors, "onchange");
        }
        if (hasValueChange) {
            return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, sourceId, "valueChange", clientBehaviors, "onchange");
        }
        return HtmlRendererUtils.renderHTMLStringAttribute(writer, uiComponent, "onchange", "onchange");
    }

    public static boolean isHideNoSelectionOption(UIComponent component) {
        Object hideNoSelectionOptionAttr = component.getAttributes().get("hideNoSelectionOption");
        return hideNoSelectionOptionAttr instanceof String && "true".equalsIgnoreCase((String)hideNoSelectionOptionAttr) || hideNoSelectionOptionAttr instanceof Boolean && (Boolean)hideNoSelectionOptionAttr != false;
    }

    public static void renderUnhandledFacesMessages(FacesContext facesContext) throws IOException {
        HtmlMessages messages = (HtmlMessages)facesContext.getApplication().createComponent("jakarta.faces.HtmlMessages");
        messages.setId("jakarta_faces_developmentstage_messages");
        messages.setTitle("Project Stage[Development]: Unhandled Messages");
        messages.setStyle("color:orange");
        messages.setRedisplay(false);
        messages.encodeAll(facesContext);
    }

    public static boolean isOutputHtml5Doctype(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot == null) {
            return false;
        }
        Doctype doctype = viewRoot.getDoctype();
        if (doctype == null) {
            return false;
        }
        return "html".equalsIgnoreCase(doctype.getRootElement()) && doctype.getPublic() == null && doctype.getSystem() == null;
    }

    public static void renderScriptType(FacesContext context, ResponseWriter writer) throws IOException {
        if (!HtmlRendererUtils.isOutputHtml5Doctype(context)) {
            writer.writeAttribute("type", "text/javascript", null);
        }
    }

    private static class SelectOneGroupSetSubmittedValueCallback
    implements VisitCallback {
        private String group;
        private String submittedValue;
        private String submittedClientId;
        private boolean sourceComponentHasValueVE;
        private boolean submittedValueSet;

        public SelectOneGroupSetSubmittedValueCallback(String group, String submittedValue, String submittedClientId, boolean sourceComponentHasValueVE) {
            this.group = group;
            this.submittedValue = submittedValue;
            this.submittedClientId = submittedClientId;
            this.sourceComponentHasValueVE = sourceComponentHasValueVE;
            this.submittedValueSet = false;
        }

        @Override
        public VisitResult visit(VisitContext context, UIComponent target) {
            UISelectOne targetSelectOneRadio;
            String targetGroup;
            if (target instanceof UISelectOne && this.group.equals(targetGroup = (targetSelectOneRadio = (UISelectOne)target).getGroup())) {
                if (this.sourceComponentHasValueVE) {
                    if (this.submittedClientId.equals(targetSelectOneRadio.getClientId(context.getFacesContext()))) {
                        targetSelectOneRadio.setSubmittedValue(this.submittedValue);
                    } else {
                        targetSelectOneRadio.resetValue();
                    }
                } else if (!this.submittedValueSet) {
                    if (targetSelectOneRadio.getValueExpression("value") != null) {
                        targetSelectOneRadio.setSubmittedValue(this.submittedValue);
                        this.submittedValueSet = true;
                    } else {
                        targetSelectOneRadio.resetValue();
                    }
                } else {
                    targetSelectOneRadio.resetValue();
                }
                return VisitResult.REJECT;
            }
            return VisitResult.ACCEPT;
        }
    }
}

