/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.util;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.view.ViewScoped;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;

public class CDIUtils {
    public static BeanManager getBeanManager(ExternalContext externalContext) {
        return (BeanManager)externalContext.getApplicationMap().get("oam.cdi.BEAN_MANAGER_INSTANCE");
    }

    public static <T> T lookup(BeanManager bm, Class<T> clazz) {
        Set beans = bm.getBeans(clazz, new Annotation[0]);
        return CDIUtils.resolveInstance(bm, beans, clazz);
    }

    public static Object lookup(BeanManager bm, String name) {
        Set beans = bm.getBeans(name);
        return CDIUtils.resolveInstance(bm, beans, Object.class);
    }

    private static <T> T resolveInstance(BeanManager bm, Set<Bean<?>> beans, Type type) {
        Bean bean = bm.resolve(beans);
        CreationalContext cc = bm.createCreationalContext((Contextual)bean);
        Object dao = bm.getReference(bean, type, cc);
        return (T)dao;
    }

    public static <T> Bean<T> resolve(BeanManager beanManager, Class<T> beanClass, Annotation ... qualifiers) {
        Set beans = beanManager.getBeans(beanClass, qualifiers);
        for (Bean bean : beans) {
            if (bean.getBeanClass() != beanClass) continue;
            return beanManager.resolve(Collections.singleton(bean));
        }
        return beanManager.resolve(beans);
    }

    public static <T> Bean<T> resolve(BeanManager beanManager, Type type, Annotation ... qualifiers) {
        Set beans = beanManager.getBeans(type, qualifiers);
        return beanManager.resolve(beans);
    }

    public static <T> T getInstance(BeanManager beanManager, Class<T> beanClass, boolean create, Annotation ... qualifiers) {
        try {
            Bean<T> bean = CDIUtils.resolve(beanManager, beanClass, qualifiers);
            return bean != null ? (T)CDIUtils.getInstance(beanManager, bean, create) : null;
        }
        catch (ContextNotActiveException e) {
            return null;
        }
    }

    public static <T> T getInstance(BeanManager beanManager, Type type, boolean create, Annotation ... qualifiers) {
        try {
            Bean<T> bean = CDIUtils.resolve(beanManager, type, qualifiers);
            return bean != null ? (T)CDIUtils.getInstance(beanManager, bean, create) : null;
        }
        catch (ContextNotActiveException e) {
            return null;
        }
    }

    public static <T> T getInstance(BeanManager beanManager, Bean<T> bean, boolean create) {
        Context context = beanManager.getContext(bean.getScope());
        if (create) {
            return (T)context.get(bean, beanManager.createCreationalContext(bean));
        }
        return (T)context.get(bean);
    }

    public static boolean isSessionScopeActive(BeanManager beanManager) {
        try {
            Context ctx = beanManager.getContext(SessionScoped.class);
            return ctx != null;
        }
        catch (ContextNotActiveException contextNotActiveException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isViewScopeActive(BeanManager beanManager) {
        try {
            Context ctx = beanManager.getContext(ViewScoped.class);
            return ctx != null;
        }
        catch (ContextNotActiveException contextNotActiveException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

