/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf;

import jakarta.faces.component.UIComponent;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRule;
import jakarta.faces.view.facelets.Metadata;
import jakarta.faces.view.facelets.MetadataTarget;
import jakarta.faces.view.facelets.TagAttribute;
import org.apache.myfaces.view.facelets.PassthroughRule;

final class PassthroughRuleImpl
extends MetaRule
implements PassthroughRule {
    public static final PassthroughRuleImpl INSTANCE = new PassthroughRuleImpl();

    @Override
    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (meta.isTargetInstanceOf(UIComponent.class)) {
            if (!attribute.isLiteral()) {
                Class<Object> type = meta.getPropertyType(name);
                if (type == null) {
                    type = Object.class;
                }
                if ("class".equalsIgnoreCase(name)) {
                    type = Object.class;
                }
                return new ValueExpressionMetadata(name, type, attribute);
            }
            return new LiteralAttributeMetadata(name, attribute.getValue());
        }
        return null;
    }

    static final class ValueExpressionMetadata
    extends Metadata {
        private final String _name;
        private final TagAttribute _attr;
        private final Class<?> _type;

        public ValueExpressionMetadata(String name, Class<?> type, TagAttribute attr) {
            this._name = name;
            this._attr = attr;
            this._type = type;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).getPassThroughAttributes().put(this._name, this._attr.getValueExpression(ctx, this._type));
        }
    }

    static final class LiteralAttributeMetadata
    extends Metadata {
        private final String _name;
        private final String _value;

        public LiteralAttributeMetadata(String name, String value) {
            this._name = name;
            this._value = value;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).getPassThroughAttributes().put(this._name, this._value);
        }
    }
}

