/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.faces.FacesException;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component._ClassUtils;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.EvaluationException;
import jakarta.faces.el.MethodBinding;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.FacesEvent;

abstract class _MethodBindingToListener
implements StateHolder {
    protected MethodBinding methodBinding;

    public _MethodBindingToListener() {
    }

    public _MethodBindingToListener(MethodBinding methodBinding) {
        if (methodBinding == null) {
            throw new NullPointerException("methodBinding can not be null");
        }
        if (!(methodBinding instanceof StateHolder)) {
            throw new IllegalArgumentException("methodBinding must implement the StateHolder interface");
        }
        this.methodBinding = methodBinding;
    }

    private FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected void invokeMethodBinding(FacesEvent event) throws AbortProcessingException {
        try {
            this.methodBinding.invoke(this.getFacesContext(), new Object[]{event});
        }
        catch (EvaluationException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof AbortProcessingException) {
                throw (AbortProcessingException)cause;
            }
            throw e;
        }
    }

    public MethodBinding getMethodBinding() {
        return this.methodBinding;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] stateArray = (Object[])state;
        try {
            this.methodBinding = (MethodBinding)_ClassUtils.getContextClassLoader().loadClass((String)stateArray[0]).newInstance();
        }
        catch (Exception e) {
            throw new FacesException(e);
        }
        ((StateHolder)((Object)this.methodBinding)).restoreState(context, stateArray[1]);
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] stateArray = new Object[]{this.methodBinding.getClass().getName(), ((StateHolder)((Object)this.methodBinding)).saveState(context)};
        return stateArray;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        ((StateHolder)((Object)this.methodBinding)).setTransient(newTransientValue);
    }

    @Override
    public boolean isTransient() {
        return ((StateHolder)((Object)this.methodBinding)).isTransient();
    }
}

