/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.el.MethodInfo;
import jakarta.el.PropertyNotFoundException;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component._ClassUtils;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.EvaluationException;
import jakarta.faces.el.MethodBinding;
import jakarta.faces.el.MethodNotFoundException;

class _MethodBindingToMethodExpression
extends MethodExpression
implements StateHolder {
    private static final Class<?>[] EXPECTED_TYPES = new Class[]{MethodBinding.class, StateHolder.class};
    private MethodBinding methodBinding;
    private boolean _transientFlag;
    private transient MethodInfo methodInfo;

    protected _MethodBindingToMethodExpression() {
    }

    public _MethodBindingToMethodExpression(MethodBinding methodBinding) {
        this.checkNullArgument(methodBinding, "methodBinding");
        this.methodBinding = methodBinding;
    }

    public MethodBinding getMethodBinding() {
        return this.methodBinding;
    }

    void setMethodBinding(MethodBinding methodBinding) {
        this.methodBinding = methodBinding;
    }

    public MethodInfo getMethodInfo(ELContext context) throws PropertyNotFoundException, jakarta.el.MethodNotFoundException, ELException {
        FacesContext facesContext;
        this.checkNullArgument(context, "elcontext");
        this.checkNullState(this.methodBinding, "methodBinding");
        if (this.methodInfo == null && (facesContext = (FacesContext)context.getContext(FacesContext.class)) != null) {
            this.methodInfo = this.invoke(new Invoker<MethodInfo>(){

                @Override
                public MethodInfo invoke() {
                    return new MethodInfo(null, _MethodBindingToMethodExpression.this.methodBinding.getType(facesContext), null);
                }
            });
        }
        return this.methodInfo;
    }

    public Object invoke(ELContext context, final Object[] params) throws PropertyNotFoundException, jakarta.el.MethodNotFoundException, ELException {
        this.checkNullArgument(context, "elcontext");
        this.checkNullState(this.methodBinding, "methodBinding");
        final FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        if (facesContext != null) {
            return this.invoke(new Invoker<Object>(){

                @Override
                public Object invoke() {
                    return _MethodBindingToMethodExpression.this.methodBinding.invoke(facesContext, params);
                }
            });
        }
        return null;
    }

    public boolean isLiteralText() {
        if (this.methodBinding == null) {
            throw new IllegalStateException("methodBinding is null");
        }
        String expr = this.methodBinding.getExpressionString();
        return !expr.startsWith("#{") || !expr.endsWith("}");
    }

    public String getExpressionString() {
        return this.methodBinding.getExpressionString();
    }

    @Override
    public Object saveState(FacesContext context) {
        if (!this.isTransient()) {
            if (this.methodBinding instanceof StateHolder) {
                Object[] state = new Object[]{this.methodBinding.getClass().getName(), ((StateHolder)((Object)this.methodBinding)).saveState(context)};
                return state;
            }
            return this.methodBinding;
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state instanceof MethodBinding) {
            this.methodBinding = (MethodBinding)state;
            this.methodInfo = null;
        } else if (state != null) {
            Object[] values = (Object[])state;
            this.methodBinding = (MethodBinding)_ClassUtils.newInstance(values[0].toString(), EXPECTED_TYPES);
            ((StateHolder)((Object)this.methodBinding)).restoreState(context, values[1]);
            this.methodInfo = null;
        }
    }

    @Override
    public void setTransient(boolean transientFlag) {
        this._transientFlag = transientFlag;
    }

    @Override
    public boolean isTransient() {
        return this._transientFlag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.methodBinding == null ? 0 : this.methodBinding.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        _MethodBindingToMethodExpression other = (_MethodBindingToMethodExpression)obj;
        return !(this.methodBinding == null ? other.methodBinding != null : !this.methodBinding.equals(other.methodBinding));
    }

    private void checkNullState(Object notNullInstance, String instanceName) {
        if (notNullInstance == null) {
            throw new IllegalStateException(instanceName + " is null");
        }
    }

    private void checkNullArgument(Object notNullInstance, String instanceName) {
        if (notNullInstance == null) {
            throw new IllegalArgumentException(instanceName + " is null");
        }
    }

    private <T> T invoke(Invoker<T> invoker) {
        try {
            return invoker.invoke();
        }
        catch (MethodNotFoundException e) {
            throw new jakarta.el.MethodNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (EvaluationException e) {
            throw new ELException(e.getMessage(), (Throwable)e);
        }
    }

    private static interface Invoker<T> {
        public T invoke();
    }
}

