/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.html.HtmlCommandScript;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.component.search.SearchExpressionHandler;
import javax.faces.context.FacesContext;
import org.apache.myfaces.component.search.MyFacesSearchExpressionHints;
import org.apache.myfaces.util.lang.StringUtils;

public class AjaxScriptBuilder {
    public static void build(FacesContext context, StringBuilder sb, UIComponent component, String sourceId, String eventName, String execute, String render, Boolean resetValues, String onerror, String onevent, List<UIParameter> uiParams) {
        AjaxScriptBuilder.build(context, sb, component, sourceId, eventName, execute, render, null, Boolean.TRUE.equals(resetValues) ? Boolean.TRUE.toString() : null, onerror, onevent, null, uiParams);
    }

    public static void build(FacesContext context, StringBuilder sb, UIComponent component, String sourceId, String eventName, Collection<String> executeList, Collection<String> renderList, String delay, boolean resetValues, String onerror, String onevent, Collection<ClientBehaviorContext.Parameter> params) {
        String execute = null;
        if (executeList != null && !executeList.isEmpty()) {
            execute = String.join((CharSequence)" ", executeList);
        }
        String render = null;
        if (renderList != null && !renderList.isEmpty()) {
            render = String.join((CharSequence)" ", renderList);
        }
        AjaxScriptBuilder.build(context, sb, component, sourceId, eventName, execute, render, delay, resetValues ? Boolean.TRUE.toString() : null, onerror, onevent, params, null);
    }

    public static void build(FacesContext context, StringBuilder sb, UIComponent component, String sourceId, String eventName, String execute, String render, String delay, String resetValues, String onerror, String onevent, Collection<ClientBehaviorContext.Parameter> params, List<UIParameter> uiParams) {
        HtmlCommandScript commandScript = component instanceof HtmlCommandScript ? (HtmlCommandScript)component : null;
        sb.append("myfaces.ab(");
        if (sourceId == null) {
            sb.append("this");
        } else {
            sb.append('\'');
            sb.append(sourceId);
            sb.append('\'');
            if (!sourceId.trim().equals(component.getClientId(context))) {
                UIComponent ref = component.getParent() == null ? component : component.getParent();
                UIComponent instance = null;
                try {
                    instance = ref.findComponent(sourceId);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (instance == null && execute == null) {
                    execute = component.getClientId(context);
                }
            }
        }
        sb.append(',');
        sb.append(commandScript == null ? "event" : "null");
        sb.append(",'");
        sb.append(eventName);
        sb.append("',");
        SearchExpressionHandler seHandler = null;
        SearchExpressionContext seContext = null;
        if (StringUtils.isNotBlank(execute) || StringUtils.isNotBlank(render)) {
            seHandler = context.getApplication().getSearchExpressionHandler();
            seContext = SearchExpressionContext.createSearchExpressionContext((FacesContext)context, (UIComponent)component, MyFacesSearchExpressionHints.SET_RESOLVE_CLIENT_SIDE_RESOLVE_SINGLE_COMPONENT, null);
        }
        AjaxScriptBuilder.appendIds(sb, execute, seHandler, seContext);
        sb.append(',');
        AjaxScriptBuilder.appendIds(sb, render, seHandler, seContext);
        if (onevent != null || onerror != null || delay != null || resetValues != null || params != null && !params.isEmpty() || uiParams != null && !uiParams.isEmpty()) {
            sb.append(",{");
            if (onevent != null) {
                AjaxScriptBuilder.appendProperty(sb, "onevent", onevent, false);
            }
            if (onerror != null) {
                AjaxScriptBuilder.appendProperty(sb, "onerror", onerror, false);
            }
            if (delay != null) {
                AjaxScriptBuilder.appendProperty(sb, "delay", delay, true);
            }
            if (resetValues != null) {
                AjaxScriptBuilder.appendProperty(sb, "resetValues", resetValues, false);
            }
            if (params != null && !params.isEmpty() || uiParams != null && !uiParams.isEmpty()) {
                if (params != null && !params.isEmpty()) {
                    if (params instanceof RandomAccess) {
                        List list = (List)params;
                        int size = list.size();
                        for (int i = 0; i < size; ++i) {
                            ClientBehaviorContext.Parameter param = (ClientBehaviorContext.Parameter)list.get(i);
                            AjaxScriptBuilder.appendProperty(sb, param.getName(), param.getValue(), true);
                        }
                    } else {
                        for (ClientBehaviorContext.Parameter param : params) {
                            AjaxScriptBuilder.appendProperty(sb, param.getName(), param.getValue(), true);
                        }
                    }
                }
                if (uiParams != null && uiParams.size() > 0) {
                    int size = uiParams.size();
                    for (int i = 0; i < size; ++i) {
                        UIParameter param = uiParams.get(i);
                        AjaxScriptBuilder.appendProperty(sb, param.getName(), param.getValue(), true);
                    }
                }
            }
            sb.append('}');
        }
        sb.append(')');
    }

    private static void appendIds(StringBuilder sb, String expressions, SearchExpressionHandler handler, SearchExpressionContext searchExpressionContext) {
        List clientIds;
        sb.append('\'');
        if (StringUtils.isNotBlank(expressions) && (clientIds = handler.resolveClientIds(searchExpressionContext, expressions)) != null && !clientIds.isEmpty()) {
            for (int i = 0; i < clientIds.size(); ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append((String)clientIds.get(i));
            }
        }
        sb.append('\'');
    }

    public static void appendProperty(StringBuilder builder, String name, Object value, boolean quoteValue) {
        if (StringUtils.isBlank(name)) {
            throw new IllegalArgumentException();
        }
        char lastChar = builder.charAt(builder.length() - 1);
        if (lastChar != ',' && lastChar != '{') {
            builder.append(',');
        }
        builder.append('\'');
        builder.append(name);
        builder.append('\'');
        builder.append(':');
        if (value == null) {
            builder.append("''");
        } else if (quoteValue) {
            builder.append('\'');
            builder.append(value.toString());
            builder.append('\'');
        } else {
            builder.append(value.toString());
        }
    }
}

