/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.math.BigDecimal;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert._MessageUtils;

public class BigDecimalConverter
implements Converter {
    public static final String CONVERTER_ID = "javax.faces.BigDecimal";
    public static final String STRING_ID = "javax.faces.converter.STRING";
    public static final String DECIMAL_ID = "javax.faces.converter.BigDecimalConverter.DECIMAL";

    @Override
    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value != null && (value = value.trim()).length() > 0) {
            try {
                return new BigDecimal(value.trim());
            }
            catch (NumberFormatException e) {
                throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, DECIMAL_ID, new Object[]{value, new BigDecimal(4815.16).toString(), _MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return ((BigDecimal)value).toString();
        }
        catch (Exception e) {
            throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, STRING_ID, new Object[]{value, _MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
        }
    }
}

