/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -1517198431551012882L;
    private static final String SUBMITTED_VALUE_FIELD = "submittedValue";
    private static final String LOCAL_VALUE_FIELD = "localValue";
    private static final String VALUE_FIELD = "value";
    private boolean _afterPhase = false;
    private PhaseId _currentPhase;
    private DebugVisitCallback _visitCallback = new DebugVisitCallback();

    public static Map<String, List<Object[]>> getDebugInfoMap(String clientId) {
        Map<String, Object> requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
        HashMap debugInfo = (HashMap)requestMap.get("org.apache.myfaces.debug.DEBUG_INFO" + clientId);
        if (debugInfo == null) {
            debugInfo = new HashMap();
            requestMap.put("org.apache.myfaces.debug.DEBUG_INFO" + clientId, debugInfo);
        }
        return debugInfo;
    }

    public static List<Object[]> getFieldDebugInfos(String field, String clientId) {
        Map<String, List<Object[]>> debugInfo = DebugPhaseListener.getDebugInfoMap(clientId);
        List<Object[]> fieldDebugInfo = debugInfo.get(field);
        if (fieldDebugInfo == null) {
            fieldDebugInfo = new ArrayList<Object[]>();
            debugInfo.put(field, fieldDebugInfo);
        }
        return fieldDebugInfo;
    }

    public static void createFieldDebugInfo(FacesContext facesContext, String field, Object oldValue, Object newValue, String clientId) {
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        if (oldValue != null && oldValue.getClass().isArray()) {
            oldValue = Arrays.deepToString((Object[])oldValue);
        }
        if (newValue != null && newValue.getClass().isArray()) {
            newValue = Arrays.deepToString((Object[])newValue);
        }
        Object[] debugInfo = new Object[]{facesContext.getCurrentPhaseId(), oldValue, newValue, null};
        DebugPhaseListener.getFieldDebugInfos(field, clientId).add(debugInfo);
    }

    @Override
    public void afterPhase(PhaseEvent event) {
        this._doTreeVisit(event, true);
    }

    @Override
    public void beforePhase(PhaseEvent event) {
        this._doTreeVisit(event, false);
    }

    @Override
    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    private void _doTreeVisit(PhaseEvent event, boolean afterPhase) {
        this._afterPhase = afterPhase;
        this._currentPhase = event.getPhaseId();
        UIViewRoot viewroot = event.getFacesContext().getViewRoot();
        if (viewroot != null) {
            viewroot.visitTree(VisitContext.createVisitContext(event.getFacesContext(), null, EnumSet.of(VisitHint.SKIP_UNRENDERED)), this._visitCallback);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DebugVisitCallback
    implements VisitCallback {
        private DebugVisitCallback() {
        }

        @Override
        public VisitResult visit(VisitContext context, UIComponent target) {
            if (target instanceof EditableValueHolder) {
                EditableValueHolder evh = (EditableValueHolder)((Object)target);
                String clientId = target.getClientId(context.getFacesContext());
                Map<String, Object> requestMap = context.getFacesContext().getExternalContext().getRequestMap();
                if (DebugPhaseListener.this._afterPhase) {
                    this._createFieldDebugInfosIfNecessary(DebugPhaseListener.SUBMITTED_VALUE_FIELD, clientId, evh.getSubmittedValue(), requestMap, context.getFacesContext());
                    Object localValue = evh.getLocalValue();
                    this._createFieldDebugInfosIfNecessary(DebugPhaseListener.LOCAL_VALUE_FIELD, clientId, localValue, requestMap, context.getFacesContext());
                    Object value = this._getRealValue(evh, target, localValue, context.getFacesContext().getELContext());
                    this._createFieldDebugInfosIfNecessary(DebugPhaseListener.VALUE_FIELD, clientId, value, requestMap, context.getFacesContext());
                } else {
                    requestMap.put("org.apache.myfaces.debug.DEBUG_INFO" + clientId + DebugPhaseListener.SUBMITTED_VALUE_FIELD, evh.getSubmittedValue());
                    Object localValue = evh.getLocalValue();
                    requestMap.put("org.apache.myfaces.debug.DEBUG_INFO" + clientId + DebugPhaseListener.LOCAL_VALUE_FIELD, localValue);
                    Object value = this._getRealValue(evh, target, localValue, context.getFacesContext().getELContext());
                    requestMap.put("org.apache.myfaces.debug.DEBUG_INFO" + clientId + DebugPhaseListener.VALUE_FIELD, value);
                }
            }
            return VisitResult.ACCEPT;
        }

        private void _createFieldDebugInfosIfNecessary(String field, String clientId, Object newValue, Map<String, Object> requestMap, FacesContext facesContext) {
            List<Object[]> fieldDebugInfos = DebugPhaseListener.getFieldDebugInfos(field, clientId);
            boolean found = false;
            int size = fieldDebugInfos.size();
            for (int i = 0; i < size; ++i) {
                Object[] debugInfo = fieldDebugInfos.get(i);
                if (!debugInfo[0].equals(DebugPhaseListener.this._currentPhase)) continue;
                found = true;
                break;
            }
            if (!found) {
                Object oldValue = requestMap.remove("org.apache.myfaces.debug.DEBUG_INFO" + clientId + field);
                DebugPhaseListener.createFieldDebugInfo(facesContext, field, oldValue, newValue, clientId);
            }
        }

        private Object _getRealValue(EditableValueHolder evh, UIComponent target, Object localValue, ELContext elCtx) {
            ValueExpression valueExpression;
            Object value = evh.getValue();
            if (localValue != null && localValue.equals(value) && (valueExpression = target.getValueExpression(DebugPhaseListener.VALUE_FIELD)) != null) {
                value = valueExpression.getValue(elCtx);
            }
            return value;
        }
    }
}

