/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryIndexReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiSegmentReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.SegmentTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosReader;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorsReader;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BitVector;

class SegmentReader
extends DirectoryIndexReader {
    private String segment;
    private SegmentInfo si;
    private int readBufferSize;
    FieldInfos fieldInfos;
    private FieldsReader fieldsReader;
    TermInfosReader tis;
    TermVectorsReader termVectorsReaderOrig = null;
    ThreadLocal termVectorsLocal = new ThreadLocal();
    BitVector deletedDocs = null;
    private boolean deletedDocsDirty = false;
    private boolean normsDirty = false;
    private boolean undeleteAll = false;
    private boolean rollbackDeletedDocsDirty = false;
    private boolean rollbackNormsDirty = false;
    private boolean rollbackUndeleteAll = false;
    IndexInput freqStream;
    IndexInput proxStream;
    private IndexInput singleNormStream;
    CompoundFileReader cfsReader = null;
    CompoundFileReader storeCFSReader = null;
    private SegmentReader referencedSegmentReader = null;
    Map norms = new HashMap();
    private static Class IMPL;
    private byte[] ones;

    SegmentReader() {
    }

    protected synchronized void incRef() {
        super.incRef();
        Iterator it = this.norms.values().iterator();
        while (it.hasNext()) {
            Norm norm = (Norm)it.next();
            norm.incRef();
        }
    }

    private synchronized void incRefReaderNotNorms() {
        super.incRef();
    }

    protected synchronized void decRef() throws IOException {
        super.decRef();
        Iterator it = this.norms.values().iterator();
        while (it.hasNext()) {
            Norm norm = (Norm)it.next();
            norm.decRef();
        }
    }

    private synchronized void decRefReaderNotNorms() throws IOException {
        super.decRef();
    }

    public static SegmentReader get(SegmentInfo si) throws CorruptIndexException, IOException {
        return SegmentReader.get(si.dir, si, null, false, false, 1024, true);
    }

    static SegmentReader get(SegmentInfo si, boolean doOpenStores) throws CorruptIndexException, IOException {
        return SegmentReader.get(si.dir, si, null, false, false, 1024, doOpenStores);
    }

    public static SegmentReader get(SegmentInfo si, int readBufferSize) throws CorruptIndexException, IOException {
        return SegmentReader.get(si.dir, si, null, false, false, readBufferSize, true);
    }

    static SegmentReader get(SegmentInfo si, int readBufferSize, boolean doOpenStores) throws CorruptIndexException, IOException {
        return SegmentReader.get(si.dir, si, null, false, false, readBufferSize, doOpenStores);
    }

    public static SegmentReader get(SegmentInfos sis, SegmentInfo si, boolean closeDir) throws CorruptIndexException, IOException {
        return SegmentReader.get(si.dir, si, sis, closeDir, true, 1024, true);
    }

    public static SegmentReader get(Directory dir, SegmentInfo si, SegmentInfos sis, boolean closeDir, boolean ownDir, int readBufferSize) throws CorruptIndexException, IOException {
        return SegmentReader.get(dir, si, sis, closeDir, ownDir, readBufferSize, true);
    }

    public static SegmentReader get(Directory dir, SegmentInfo si, SegmentInfos sis, boolean closeDir, boolean ownDir, int readBufferSize, boolean doOpenStores) throws CorruptIndexException, IOException {
        SegmentReader instance;
        try {
            instance = (SegmentReader)IMPL.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot load SegmentReader class: " + e, e);
        }
        instance.init(dir, sis, closeDir);
        instance.initialize(si, readBufferSize, doOpenStores);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(SegmentInfo si, int readBufferSize, boolean doOpenStores) throws CorruptIndexException, IOException {
        this.segment = si.name;
        this.si = si;
        this.readBufferSize = readBufferSize;
        boolean success = false;
        try {
            Directory storeDir;
            Directory cfsDir = this.directory();
            if (si.getUseCompoundFile()) {
                this.cfsReader = new CompoundFileReader(this.directory(), this.segment + "." + "cfs", readBufferSize);
                cfsDir = this.cfsReader;
            }
            if (doOpenStores) {
                if (si.getDocStoreOffset() != -1) {
                    if (si.getDocStoreIsCompoundFile()) {
                        this.storeCFSReader = new CompoundFileReader(this.directory(), si.getDocStoreSegment() + "." + "cfx", readBufferSize);
                        storeDir = this.storeCFSReader;
                    } else {
                        storeDir = this.directory();
                    }
                } else {
                    storeDir = cfsDir;
                }
            } else {
                storeDir = null;
            }
            this.fieldInfos = new FieldInfos(cfsDir, this.segment + ".fnm");
            String fieldsSegment = si.getDocStoreOffset() != -1 ? si.getDocStoreSegment() : this.segment;
            if (doOpenStores) {
                this.fieldsReader = new FieldsReader(storeDir, fieldsSegment, this.fieldInfos, readBufferSize, si.getDocStoreOffset(), si.docCount);
                if (si.getDocStoreOffset() == -1 && this.fieldsReader.size() != si.docCount) {
                    throw new CorruptIndexException("doc counts differ for segment " + si.name + ": fieldsReader shows " + this.fieldsReader.size() + " but segmentInfo shows " + si.docCount);
                }
            }
            this.tis = new TermInfosReader(cfsDir, this.segment, this.fieldInfos, readBufferSize);
            this.loadDeletedDocs();
            this.freqStream = cfsDir.openInput(this.segment + ".frq", readBufferSize);
            this.proxStream = cfsDir.openInput(this.segment + ".prx", readBufferSize);
            this.openNorms(cfsDir, readBufferSize);
            if (doOpenStores && this.fieldInfos.hasVectors()) {
                String vectorsSegment = si.getDocStoreOffset() != -1 ? si.getDocStoreSegment() : this.segment;
                this.termVectorsReaderOrig = new TermVectorsReader(storeDir, vectorsSegment, this.fieldInfos, readBufferSize, si.getDocStoreOffset(), si.docCount);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    private void loadDeletedDocs() throws IOException {
        if (SegmentReader.hasDeletions(this.si)) {
            this.deletedDocs = new BitVector(this.directory(), this.si.getDelFileName());
            if (this.deletedDocs.count() > this.maxDoc()) {
                throw new CorruptIndexException("number of deletes (" + this.deletedDocs.count() + ") exceeds max doc (" + this.maxDoc() + ") for segment " + this.si.name);
            }
        }
    }

    protected synchronized DirectoryIndexReader doReopen(SegmentInfos infos) throws CorruptIndexException, IOException {
        SegmentReader newReader;
        if (infos.size() == 1) {
            SegmentInfo si = infos.info(0);
            newReader = this.segment.equals(si.name) && si.getUseCompoundFile() == this.si.getUseCompoundFile() ? this.reopenSegment(si) : SegmentReader.get(infos, infos.info(0), false);
        } else {
            return new MultiSegmentReader(this.directory, infos, this.closeDirectory, new SegmentReader[]{this}, null, null);
        }
        return newReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized SegmentReader reopenSegment(SegmentInfo si) throws CorruptIndexException, IOException {
        boolean deletionsUpToDate = this.si.hasDeletions() == si.hasDeletions() && (!si.hasDeletions() || this.si.getDelFileName().equals(si.getDelFileName()));
        boolean normsUpToDate = true;
        boolean[] fieldNormsChanged = new boolean[this.fieldInfos.size()];
        if (normsUpToDate) {
            for (int i = 0; i < this.fieldInfos.size(); ++i) {
                if (this.si.getNormFileName(i).equals(si.getNormFileName(i))) continue;
                normsUpToDate = false;
                fieldNormsChanged[i] = true;
            }
        }
        if (normsUpToDate && deletionsUpToDate) {
            return this;
        }
        SegmentReader clone = new SegmentReader();
        boolean success = false;
        try {
            Norm norm;
            int i;
            String fieldsSegment;
            clone.directory = this.directory;
            clone.si = si;
            clone.segment = this.segment;
            clone.readBufferSize = this.readBufferSize;
            clone.cfsReader = this.cfsReader;
            clone.storeCFSReader = this.storeCFSReader;
            clone.fieldInfos = this.fieldInfos;
            clone.tis = this.tis;
            clone.freqStream = this.freqStream;
            clone.proxStream = this.proxStream;
            clone.termVectorsReaderOrig = this.termVectorsReaderOrig;
            Directory storeDir = this.directory();
            if (si.getDocStoreOffset() != -1) {
                fieldsSegment = si.getDocStoreSegment();
                if (this.storeCFSReader != null) {
                    storeDir = this.storeCFSReader;
                }
            } else {
                fieldsSegment = this.segment;
                if (this.cfsReader != null) {
                    storeDir = this.cfsReader;
                }
            }
            if (this.fieldsReader != null) {
                clone.fieldsReader = new FieldsReader(storeDir, fieldsSegment, this.fieldInfos, this.readBufferSize, si.getDocStoreOffset(), si.docCount);
            }
            if (!deletionsUpToDate) {
                clone.deletedDocs = null;
                clone.loadDeletedDocs();
            } else {
                clone.deletedDocs = this.deletedDocs;
            }
            clone.norms = new HashMap();
            if (!normsUpToDate) {
                for (i = 0; i < fieldNormsChanged.length; ++i) {
                    if (fieldNormsChanged[i]) continue;
                    String curField = this.fieldInfos.fieldInfo((int)i).name;
                    norm = (Norm)this.norms.get(curField);
                    norm.incRef();
                    clone.norms.put(curField, norm);
                }
                clone.openNorms(si.getUseCompoundFile() ? this.cfsReader : this.directory(), this.readBufferSize);
            } else {
                Iterator it = this.norms.keySet().iterator();
                while (it.hasNext()) {
                    String field = (String)it.next();
                    norm = (Norm)this.norms.get(field);
                    norm.incRef();
                    clone.norms.put(field, norm);
                }
            }
            if (clone.singleNormStream == null) {
                for (i = 0; i < this.fieldInfos.size(); ++i) {
                    FieldInfo fi = this.fieldInfos.fieldInfo(i);
                    if (!fi.isIndexed || fi.omitNorms) continue;
                    Directory d = si.getUseCompoundFile() ? this.cfsReader : this.directory();
                    String fileName = si.getNormFileName(fi.number);
                    if (si.hasSeparateNorms(fi.number) || !fileName.endsWith(".nrm")) continue;
                    clone.singleNormStream = d.openInput(fileName, this.readBufferSize);
                    break;
                }
            }
            success = true;
        }
        finally {
            if (this.referencedSegmentReader != null) {
                clone.referencedSegmentReader = this.referencedSegmentReader;
                this.referencedSegmentReader.incRefReaderNotNorms();
            } else {
                clone.referencedSegmentReader = this;
                this.incRefReaderNotNorms();
            }
            if (!success) {
                clone.decRef();
            }
        }
        return clone;
    }

    protected void commitChanges() throws IOException {
        if (this.deletedDocsDirty) {
            this.si.advanceDelGen();
            this.deletedDocs.write(this.directory(), this.si.getDelFileName());
        }
        if (this.undeleteAll && this.si.hasDeletions()) {
            this.si.clearDelGen();
        }
        if (this.normsDirty) {
            this.si.setNumFields(this.fieldInfos.size());
            Iterator it = this.norms.values().iterator();
            while (it.hasNext()) {
                Norm norm = (Norm)it.next();
                if (!norm.dirty) continue;
                norm.reWrite(this.si);
            }
        }
        this.deletedDocsDirty = false;
        this.normsDirty = false;
        this.undeleteAll = false;
    }

    FieldsReader getFieldsReader() {
        return this.fieldsReader;
    }

    protected void doClose() throws IOException {
        boolean hasReferencedReader;
        boolean bl = hasReferencedReader = this.referencedSegmentReader != null;
        if (hasReferencedReader) {
            this.referencedSegmentReader.decRefReaderNotNorms();
            this.referencedSegmentReader = null;
        }
        this.deletedDocs = null;
        if (this.singleNormStream != null) {
            this.singleNormStream.close();
            this.singleNormStream = null;
        }
        if (this.fieldsReader != null) {
            this.fieldsReader.close();
        }
        if (!hasReferencedReader) {
            if (this.tis != null) {
                this.tis.close();
            }
            if (this.freqStream != null) {
                this.freqStream.close();
            }
            if (this.proxStream != null) {
                this.proxStream.close();
            }
            if (this.termVectorsReaderOrig != null) {
                this.termVectorsReaderOrig.close();
            }
            if (this.cfsReader != null) {
                this.cfsReader.close();
            }
            if (this.storeCFSReader != null) {
                this.storeCFSReader.close();
            }
            super.doClose();
        }
    }

    static boolean hasDeletions(SegmentInfo si) throws IOException {
        return si.hasDeletions();
    }

    public boolean hasDeletions() {
        return this.deletedDocs != null;
    }

    static boolean usesCompoundFile(SegmentInfo si) throws IOException {
        return si.getUseCompoundFile();
    }

    static boolean hasSeparateNorms(SegmentInfo si) throws IOException {
        return si.hasSeparateNorms();
    }

    protected void doDelete(int docNum) {
        if (this.deletedDocs == null) {
            this.deletedDocs = new BitVector(this.maxDoc());
        }
        this.deletedDocsDirty = true;
        this.undeleteAll = false;
        this.deletedDocs.set(docNum);
    }

    protected void doUndeleteAll() {
        this.deletedDocs = null;
        this.deletedDocsDirty = false;
        this.undeleteAll = true;
    }

    Vector files() throws IOException {
        return new Vector(this.si.files());
    }

    public TermEnum terms() {
        this.ensureOpen();
        return this.tis.terms();
    }

    public TermEnum terms(Term t) throws IOException {
        this.ensureOpen();
        return this.tis.terms(t);
    }

    FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    public synchronized Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (this.isDeleted(n)) {
            throw new IllegalArgumentException("attempt to access a deleted document");
        }
        return this.fieldsReader.doc(n, fieldSelector);
    }

    public synchronized boolean isDeleted(int n) {
        return this.deletedDocs != null && this.deletedDocs.get(n);
    }

    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new SegmentTermDocs(this);
    }

    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new SegmentTermPositions(this);
    }

    public int docFreq(Term t) throws IOException {
        this.ensureOpen();
        TermInfo ti = this.tis.get(t);
        if (ti != null) {
            return ti.docFreq;
        }
        return 0;
    }

    public int numDocs() {
        int n = this.maxDoc();
        if (this.deletedDocs != null) {
            n -= this.deletedDocs.count();
        }
        return n;
    }

    public int maxDoc() {
        return this.si.docCount;
    }

    public void setTermInfosIndexDivisor(int indexDivisor) throws IllegalStateException {
        this.tis.setIndexDivisor(indexDivisor);
    }

    public int getTermInfosIndexDivisor() {
        return this.tis.getIndexDivisor();
    }

    public Collection getFieldNames(IndexReader.FieldOption fieldOption) {
        this.ensureOpen();
        HashSet<String> fieldSet = new HashSet<String>();
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (fieldOption == IndexReader.FieldOption.ALL) {
                fieldSet.add(fi.name);
                continue;
            }
            if (!fi.isIndexed && fieldOption == IndexReader.FieldOption.UNINDEXED) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storePayloads && fieldOption == IndexReader.FieldOption.STORES_PAYLOADS) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && fieldOption == IndexReader.FieldOption.INDEXED) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && !fi.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_NO_TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storeTermVector && !fi.storePositionWithTermVector && !fi.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && fi.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_WITH_TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storePositionWithTermVector && !fi.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_POSITION) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storeOffsetWithTermVector && !fi.storePositionWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_OFFSET) {
                fieldSet.add(fi.name);
                continue;
            }
            if (!fi.storeOffsetWithTermVector || !fi.storePositionWithTermVector || fieldOption != IndexReader.FieldOption.TERMVECTOR_WITH_POSITION_OFFSET) continue;
            fieldSet.add(fi.name);
        }
        return fieldSet;
    }

    public synchronized boolean hasNorms(String field) {
        this.ensureOpen();
        return this.norms.containsKey(field);
    }

    static byte[] createFakeNorms(int size) {
        byte[] ones = new byte[size];
        Arrays.fill(ones, DefaultSimilarity.encodeNorm(1.0f));
        return ones;
    }

    private byte[] fakeNorms() {
        if (this.ones == null) {
            this.ones = SegmentReader.createFakeNorms(this.maxDoc());
        }
        return this.ones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized byte[] getNorms(String field) throws IOException {
        Norm norm = (Norm)this.norms.get(field);
        if (norm == null) {
            return null;
        }
        Norm norm2 = norm;
        synchronized (norm2) {
            if (norm.bytes == null) {
                byte[] bytes = new byte[this.maxDoc()];
                this.norms(field, bytes, 0);
                Norm.access$202(norm, bytes);
                norm.close();
            }
            return norm.bytes;
        }
    }

    public synchronized byte[] norms(String field) throws IOException {
        this.ensureOpen();
        byte[] bytes = this.getNorms(field);
        if (bytes == null) {
            bytes = this.fakeNorms();
        }
        return bytes;
    }

    protected void doSetNorm(int doc, String field, byte value) throws IOException {
        Norm norm = (Norm)this.norms.get(field);
        if (norm == null) {
            return;
        }
        norm.dirty = true;
        this.normsDirty = true;
        this.norms((String)field)[doc] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void norms(String field, byte[] bytes, int offset) throws IOException {
        this.ensureOpen();
        Norm norm = (Norm)this.norms.get(field);
        if (norm == null) {
            System.arraycopy(this.fakeNorms(), 0, bytes, offset, this.maxDoc());
            return;
        }
        Norm norm2 = norm;
        synchronized (norm2) {
            if (norm.bytes != null) {
                System.arraycopy(norm.bytes, 0, bytes, offset, this.maxDoc());
                return;
            }
            IndexInput normStream = norm.useSingleNormStream ? this.singleNormStream : norm.in;
            normStream.seek(norm.normSeek);
            normStream.readBytes(bytes, offset, this.maxDoc());
        }
    }

    private void openNorms(Directory cfsDir, int readBufferSize) throws IOException {
        long nextNormSeek = SegmentMerger.NORMS_HEADER.length;
        int maxDoc = this.maxDoc();
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            long normSeek;
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (this.norms.containsKey(fi.name) || !fi.isIndexed || fi.omitNorms) continue;
            Directory d = this.directory();
            String fileName = this.si.getNormFileName(fi.number);
            if (!this.si.hasSeparateNorms(fi.number)) {
                d = cfsDir;
            }
            boolean singleNormFile = fileName.endsWith(".nrm");
            IndexInput normInput = null;
            if (singleNormFile) {
                normSeek = nextNormSeek;
                if (this.singleNormStream == null) {
                    this.singleNormStream = d.openInput(fileName, readBufferSize);
                }
                normInput = this.singleNormStream;
            } else {
                normSeek = 0L;
                normInput = d.openInput(fileName);
            }
            this.norms.put(fi.name, new Norm(normInput, singleNormFile, fi.number, normSeek));
            nextNormSeek += (long)maxDoc;
        }
    }

    boolean normsClosed() {
        if (this.singleNormStream != null) {
            return false;
        }
        Iterator it = this.norms.values().iterator();
        while (it.hasNext()) {
            Norm norm = (Norm)it.next();
            if (norm.refCount <= 0) continue;
            return false;
        }
        return true;
    }

    boolean normsClosed(String field) {
        Norm norm = (Norm)this.norms.get(field);
        return norm.refCount == 0;
    }

    private TermVectorsReader getTermVectorsReader() {
        TermVectorsReader tvReader = (TermVectorsReader)this.termVectorsLocal.get();
        if (tvReader == null) {
            tvReader = (TermVectorsReader)this.termVectorsReaderOrig.clone();
            this.termVectorsLocal.set(tvReader);
        }
        return tvReader;
    }

    public TermFreqVector getTermFreqVector(int docNumber, String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.fieldInfos.fieldInfo(field);
        if (fi == null || !fi.storeTermVector || this.termVectorsReaderOrig == null) {
            return null;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        return termVectorsReader.get(docNumber, field);
    }

    public void getTermFreqVector(int docNumber, String field, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.fieldInfos.fieldInfo(field);
        if (fi == null || !fi.storeTermVector || this.termVectorsReaderOrig == null) {
            return;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return;
        }
        termVectorsReader.get(docNumber, field, mapper);
    }

    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        if (this.termVectorsReaderOrig == null) {
            return;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return;
        }
        termVectorsReader.get(docNumber, mapper);
    }

    public TermFreqVector[] getTermFreqVectors(int docNumber) throws IOException {
        this.ensureOpen();
        if (this.termVectorsReaderOrig == null) {
            return null;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        return termVectorsReader.get(docNumber);
    }

    FieldInfos fieldInfos() {
        return this.fieldInfos;
    }

    String getSegmentName() {
        return this.segment;
    }

    SegmentInfo getSegmentInfo() {
        return this.si;
    }

    void setSegmentInfo(SegmentInfo info) {
        this.si = info;
    }

    void startCommit() {
        super.startCommit();
        this.rollbackDeletedDocsDirty = this.deletedDocsDirty;
        this.rollbackNormsDirty = this.normsDirty;
        this.rollbackUndeleteAll = this.undeleteAll;
        Iterator it = this.norms.values().iterator();
        while (it.hasNext()) {
            Norm norm = (Norm)it.next();
            norm.rollbackDirty = norm.dirty;
        }
    }

    void rollbackCommit() {
        super.rollbackCommit();
        this.deletedDocsDirty = this.rollbackDeletedDocsDirty;
        this.normsDirty = this.rollbackNormsDirty;
        this.undeleteAll = this.rollbackUndeleteAll;
        Iterator it = this.norms.values().iterator();
        while (it.hasNext()) {
            Norm norm = (Norm)it.next();
            norm.dirty = norm.rollbackDirty;
        }
    }

    static {
        try {
            String name = System.getProperty("org.apache.lucene.SegmentReader.class", SegmentReader.class.getName());
            IMPL = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot load SegmentReader class: " + e, e);
        }
        catch (SecurityException se) {
            try {
                IMPL = Class.forName(SegmentReader.class.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("cannot load default SegmentReader class: " + e, e);
            }
        }
    }

    private class Norm {
        volatile int refCount = 1;
        boolean useSingleNormStream;
        private IndexInput in;
        private byte[] bytes;
        private boolean dirty;
        private int number;
        private long normSeek;
        private boolean rollbackDirty;
        static final /* synthetic */ boolean $assertionsDisabled;

        public synchronized void incRef() {
            if (!$assertionsDisabled && this.refCount <= 0) {
                throw new AssertionError();
            }
            ++this.refCount;
        }

        public synchronized void decRef() throws IOException {
            if (!$assertionsDisabled && this.refCount <= 0) {
                throw new AssertionError();
            }
            if (this.refCount == 1) {
                this.close();
            }
            --this.refCount;
        }

        public Norm(IndexInput in, boolean useSingleNormStream, int number, long normSeek) {
            this.in = in;
            this.number = number;
            this.normSeek = normSeek;
            this.useSingleNormStream = useSingleNormStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reWrite(SegmentInfo si) throws IOException {
            si.advanceNormGen(this.number);
            IndexOutput out = SegmentReader.this.directory().createOutput(si.getNormFileName(this.number));
            try {
                out.writeBytes(this.bytes, SegmentReader.this.maxDoc());
            }
            finally {
                out.close();
            }
            this.dirty = false;
        }

        private synchronized void close() throws IOException {
            if (this.in != null && !this.useSingleNormStream) {
                this.in.close();
            }
            this.in = null;
        }

        static /* synthetic */ byte[] access$202(Norm x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$SegmentReader == null ? (class$org$apache$lucene$index$SegmentReader = SegmentReader.class$("org.apache.lucene.index.SegmentReader")) : class$org$apache$lucene$index$SegmentReader).desiredAssertionStatus();
        }
    }
}

