/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.stanza.dataforms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLFragment;
import org.apache.vysper.xml.fragment.XMLText;
import org.apache.vysper.xmpp.stanza.dataforms.DataForm;
import org.apache.vysper.xmpp.stanza.dataforms.Field;
import org.apache.vysper.xmpp.stanza.dataforms.Option;

public class DataFormEncoder {
    public XMLElement getXML(DataForm dataForm) {
        ArrayList<XMLElement> childElements = new ArrayList<XMLElement>();
        Iterator<String> instructionIterator = dataForm.getInstructionIterator();
        while (instructionIterator.hasNext()) {
            String instruction = instructionIterator.next();
            if (instruction == null) continue;
            childElements.add(this.createTextOnlyElement("jabber:x:data", "instructions", instruction));
        }
        if (dataForm.getTitle() != null) {
            childElements.add(this.createTextOnlyElement("jabber:x:data", "title", dataForm.getTitle()));
        }
        if (dataForm.getType() == DataForm.Type.form) {
            ArrayList<XMLElement> reportedFields = new ArrayList<XMLElement>();
            Iterator<Field> reportedIterator = dataForm.getReportedIterator();
            while (reportedIterator.hasNext()) {
                Field field = reportedIterator.next();
                reportedFields.add(this.encodeField(field));
            }
            XMLElement reportedElement = new XMLElement("jabber:x:data", "reported", null, null, reportedFields);
            childElements.add(reportedElement);
            Iterator<List<Field>> itemIterator = dataForm.getItemIterator();
            while (itemIterator.hasNext()) {
                ArrayList<XMLElement> itemFields = new ArrayList<XMLElement>();
                List<Field> itemField = itemIterator.next();
                for (Field field : itemField) {
                    itemFields.add(this.encodeField(field));
                }
                XMLElement itemElement = new XMLElement("jabber:x:data", "item", null, null, itemFields);
                childElements.add(itemElement);
            }
        }
        if (dataForm.getType() != DataForm.Type.cancel) {
            Iterator<Field> fieldIterator = dataForm.getFieldIterator();
            while (fieldIterator.hasNext()) {
                Field field = fieldIterator.next();
                childElements.add(this.encodeField(field));
            }
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("type", dataForm.getType().value()));
        return new XMLElement("jabber:x:data", "x", null, attributes, childElements);
    }

    protected XMLElement encodeField(Field field) {
        ArrayList<XMLElement> fieldElements = new ArrayList<XMLElement>();
        ArrayList<Attribute> fieldAttributes = new ArrayList<Attribute>();
        if (field.getVar() != null) {
            fieldAttributes.add(new Attribute("var", field.getVar()));
        }
        if (field.getLabel() != null) {
            fieldAttributes.add(new Attribute("label", field.getLabel()));
        }
        if (field.getType() != null) {
            fieldAttributes.add(new Attribute("type", field.getType().value()));
        }
        if (field.getDesc() != null) {
            ArrayList<XMLText> descFragment = new ArrayList<XMLText>();
            descFragment.add(new XMLText(field.getDesc()));
            fieldElements.add(new XMLElement("jabber:x:data", "desc", null, null, descFragment));
        }
        if (field.isRequired()) {
            fieldElements.add(this.createEmptyElement("jabber:x:data", "required"));
        }
        Iterator<String> valueIterator = field.getValueIterator();
        while (valueIterator.hasNext()) {
            String value = valueIterator.next();
            XMLElement valueElement = this.createTextOnlyElement("jabber:x:data", "value", value);
            fieldElements.add(valueElement);
        }
        Iterator<Option> optionIterator = field.getOptions();
        while (optionIterator.hasNext()) {
            XMLFragment[] xMLFragmentArray;
            Attribute[] attributeArray;
            Option option = optionIterator.next();
            if (option.getLabel() == null) {
                attributeArray = null;
            } else {
                Attribute[] attributeArray2 = new Attribute[1];
                attributeArray = attributeArray2;
                attributeArray2[0] = new Attribute("label", option.getLabel());
            }
            Attribute[] attributes = attributeArray;
            if (option.getValue() == null) {
                xMLFragmentArray = null;
            } else {
                XMLFragment[] xMLFragmentArray2 = new XMLFragment[1];
                xMLFragmentArray = xMLFragmentArray2;
                xMLFragmentArray2[0] = new XMLText(option.getValue());
            }
            XMLFragment[] elements = xMLFragmentArray;
            XMLElement optionElement = new XMLElement("jabber:x:data", "option", null, attributes, elements);
            fieldElements.add(optionElement);
        }
        return new XMLElement("jabber:x:data", "field", null, fieldAttributes, fieldElements);
    }

    protected XMLElement createEmptyElement(String namespaceURI, String elementName) {
        return new XMLElement(namespaceURI, elementName, null, (Attribute[])null, (XMLFragment[])null);
    }

    protected XMLElement createTextOnlyElement(String namespaceURI, String elementName, String text) {
        return new XMLElement(namespaceURI, elementName, null, null, new XMLFragment[]{new XMLText(text)});
    }
}

