/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.mina.codec;

import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.writer.DenseStanzaLogRenderer;

public class StanzaWriteInfo {
    private Stanza stanza = null;
    private boolean writeProlog = true;
    private boolean writeOpeningElement = true;
    private boolean writeContent = true;
    private boolean writeClosingElement = true;

    public StanzaWriteInfo(Stanza stanza) {
        this.stanza = stanza;
    }

    public StanzaWriteInfo(Stanza stanza, boolean isStreamOpening) {
        this.stanza = stanza;
        this.writeProlog = isStreamOpening;
        this.writeClosingElement = !isStreamOpening;
    }

    public Stanza getStanza() {
        return this.stanza;
    }

    public boolean isWriteProlog() {
        return this.writeProlog;
    }

    public boolean isWriteOpeningElement() {
        return this.writeOpeningElement;
    }

    public boolean isWriteContent() {
        return this.writeContent;
    }

    public boolean isWriteClosingElement() {
        return this.writeClosingElement;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ prolog=").append(this.writeProlog);
        stringBuilder.append(", open=").append(this.writeOpeningElement);
        stringBuilder.append(", close=").append(this.writeClosingElement);
        stringBuilder.append(", content=").append(this.writeContent);
        stringBuilder.append(", stanza=[").append(DenseStanzaLogRenderer.render(this.stanza));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

