/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;

class TableScanResultSet
extends NoPutResultSetImpl
implements CursorResultSet,
Cloneable {
    protected ScanController scanController;
    protected boolean scanControllerOpened;
    protected boolean isKeyed;
    protected boolean firstScan = true;
    protected ExecIndexRow startPosition;
    protected ExecIndexRow stopPosition;
    protected ExecRow candidate;
    protected long conglomId;
    protected DynamicCompiledOpenConglomInfo dcoci;
    protected StaticCompiledOpenConglomInfo scoci;
    protected GeneratedMethod resultRowAllocator;
    protected GeneratedMethod startKeyGetter;
    protected int startSearchOperator;
    protected GeneratedMethod stopKeyGetter;
    protected int stopSearchOperator;
    public Qualifier[][] qualifiers;
    public String tableName;
    public String userSuppliedOptimizerOverrides;
    public String indexName;
    protected boolean runTimeStatisticsOn;
    protected FormatableBitSet accessedCols;
    protected int[] indexCols;
    public int rowsPerRead;
    public boolean forUpdate;
    private boolean sameStartStopPosition;
    private boolean nextDone;
    private RowLocation rlTemplate;
    public int isolationLevel;
    public int lockMode;
    private Properties scanProperties;
    public String startPositionString;
    public String stopPositionString;
    public boolean isConstraint;
    public boolean coarserLock;
    public boolean oneRowScan;
    protected long rowsThisScan;
    private long estimatedRowCount;
    protected Hashtable past2FutureTbl;
    protected TemporaryRowHolder futureForUpdateRows;
    protected TemporaryRowHolderResultSet futureRowResultSet;
    protected boolean skipFutureRowHolder;
    protected boolean sourceDrained;
    protected boolean currentRowPrescanned;
    protected boolean compareToLastKey;
    protected ExecRow lastCursorKey;
    private ExecRow sparseRow;
    private FormatableBitSet sparseRowMap;
    private boolean qualify;
    private boolean currentRowIsValid;
    private boolean scanRepositioned;

    TableScanResultSet(long l, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, Activation activation, GeneratedMethod generatedMethod, int n, GeneratedMethod generatedMethod2, int n2, GeneratedMethod generatedMethod3, int n3, boolean bl, Qualifier[][] qualifierArray, String string, String string2, String string3, boolean bl2, boolean bl3, int n4, int n5, int n6, boolean bl4, int n7, int n8, boolean bl5, double d, double d2) throws StandardException {
        super(activation, n, d, d2);
        this.conglomId = l;
        this.scoci = staticCompiledOpenConglomInfo;
        this.resultRowAllocator = generatedMethod;
        this.startKeyGetter = generatedMethod2;
        this.startSearchOperator = n2;
        this.stopKeyGetter = generatedMethod3;
        this.stopSearchOperator = n3;
        this.sameStartStopPosition = bl;
        this.qualifiers = qualifierArray;
        this.tableName = string;
        this.userSuppliedOptimizerOverrides = string2;
        this.indexName = string3;
        this.isConstraint = bl2;
        this.forUpdate = bl3;
        this.rowsPerRead = n8;
        this.oneRowScan = bl5;
        this.accessedCols = null;
        if (n4 != -1) {
            this.accessedCols = (FormatableBitSet)activation.getPreparedStatement().getSavedObject(n4);
        }
        if (n5 != -1) {
            this.indexCols = (int[])activation.getPreparedStatement().getSavedObject(n5);
        }
        if (this.indexCols != null) {
            activation.setForUpdateIndexScan(this);
        }
        this.lockMode = n6;
        if (n7 == 0) {
            n7 = this.lcc.getCurrentIsolationLevel();
        }
        if (n7 == 4) {
            this.isolationLevel = 5;
        } else {
            if (!bl4) {
                this.lockMode = 6;
            }
            if (n7 == 2) {
                this.isolationLevel = !bl3 && this.canGetInstantaneousLocks() ? 3 : 2;
            } else if (n7 == 1) {
                this.isolationLevel = 1;
            } else if (n7 == 3) {
                this.isolationLevel = 4;
            }
        }
        this.runTimeStatisticsOn = activation != null && activation.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.candidate = (ExecRow)generatedMethod.invoke(activation);
        this.constructorTime += this.getElapsedMillis(this.beginTime);
        this.qualify = true;
        this.currentRowIsValid = false;
        this.scanRepositioned = false;
    }

    public void openCore() throws StandardException {
        TransactionController transactionController = this.activation.getTransactionController();
        if (this.dcoci == null) {
            this.dcoci = transactionController.getDynamicCompiledConglomInfo(this.conglomId);
        }
        if (this.startKeyGetter != null) {
            this.startPosition = (ExecIndexRow)this.startKeyGetter.invoke(this.activation);
            if (this.sameStartStopPosition) {
                this.stopPosition = this.startPosition;
            }
        }
        if (this.stopKeyGetter != null) {
            this.stopPosition = (ExecIndexRow)this.stopKeyGetter.invoke(this.activation);
        }
        if (this.firstScan) {
            this.openScanController(transactionController);
            this.isKeyed = this.scanController.isKeyed();
        }
        if (this.skipScan(this.startPosition, this.stopPosition)) {
            this.scanControllerOpened = false;
        } else if (!this.firstScan) {
            this.openScanController(transactionController);
        }
        if (this.forUpdate && this.isKeyed) {
            this.activation.setIndexScanController(this.scanController);
            this.activation.setIndexConglomerateNumber(this.conglomId);
        }
        this.firstScan = false;
        this.isOpen = true;
        ++this.numOpens;
        this.nextDone = false;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    protected void openScanController(TransactionController transactionController) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray;
        DataValueDescriptor[] dataValueDescriptorArray2 = this.startPosition == null ? null : this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray3 = dataValueDescriptorArray = this.stopPosition == null ? null : this.stopPosition.getRowArray();
        if (this.qualifiers != null) {
            this.clearOrderableCache(this.qualifiers);
        }
        if (transactionController == null) {
            transactionController = this.activation.getTransactionController();
        }
        int n = 0;
        if (this.forUpdate) {
            n = 4;
            if (this.activation.isCursorActivation()) {
                n |= 0x1000;
            }
        }
        this.scanController = transactionController.openCompiledScan(this.activation.getResultSetHoldability(), n, this.lockMode, this.isolationLevel, this.accessedCols, dataValueDescriptorArray2, this.startSearchOperator, this.qualifiers, dataValueDescriptorArray, this.stopSearchOperator, this.scoci, this.dcoci);
        this.scanControllerOpened = true;
        this.rowsThisScan = 0L;
        this.estimatedRowCount = this.scanController.getEstimatedRowCount();
        this.activation.informOfRowCount(this, this.scanController.getEstimatedRowCount());
    }

    private void reopenScanController() throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray;
        DataValueDescriptor[] dataValueDescriptorArray2 = this.startPosition == null ? null : this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray3 = dataValueDescriptorArray = this.stopPosition == null ? null : this.stopPosition.getRowArray();
        if (this.qualifiers != null) {
            this.clearOrderableCache(this.qualifiers);
        }
        this.scanController.reopenScan(dataValueDescriptorArray2, this.startSearchOperator, this.qualifiers, dataValueDescriptorArray, this.stopSearchOperator);
        this.scanControllerOpened = true;
        this.rowsThisScan = 0L;
    }

    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.startKeyGetter != null) {
            this.startPosition = (ExecIndexRow)this.startKeyGetter.invoke(this.activation);
            if (this.sameStartStopPosition) {
                this.stopPosition = this.startPosition;
            }
        }
        if (this.stopKeyGetter != null) {
            this.stopPosition = (ExecIndexRow)this.stopKeyGetter.invoke(this.activation);
        }
        if (this.skipScan(this.startPosition, this.stopPosition)) {
            this.scanControllerOpened = false;
        } else if (this.scanController == null) {
            this.openScanController(null);
        } else {
            this.reopenScanController();
        }
        ++this.numOpens;
        this.nextDone = false;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private void getSparseRowAndMap() throws StandardException {
        int n;
        int n2;
        int n3 = 1;
        for (n2 = 0; n2 < this.indexCols.length; ++n2) {
            int n4 = n = this.indexCols[n2] > 0 ? this.indexCols[n2] : -this.indexCols[n2];
            if (n <= n3) continue;
            n3 = n;
        }
        this.sparseRow = new ValueRow(n3);
        this.sparseRowMap = new FormatableBitSet(n3);
        for (n2 = 0; n2 < this.indexCols.length; ++n2) {
            if (!this.accessedCols.get(n2)) continue;
            n = this.indexCols[n2] > 0 ? this.indexCols[n2] : -this.indexCols[n2];
            this.sparseRow.setColumn(n, this.candidate.getColumn(n2 + 1));
            this.sparseRowMap.set(n - 1);
        }
    }

    public ExecRow getNextRowCore() throws StandardException {
        RowLocation rowLocation;
        this.checkCancellationFlag();
        if (this.currentRow == null || this.scanRepositioned) {
            this.currentRow = this.getCompactRow(this.candidate, this.accessedCols, null, this.isKeyed);
        }
        this.beginTime = this.getCurrentTimeMillis();
        ExecRow execRow = null;
        if (this.futureForUpdateRows != null) {
            this.currentRowPrescanned = false;
            if (!this.skipFutureRowHolder) {
                ExecRow execRow2;
                if (this.futureRowResultSet == null) {
                    this.futureRowResultSet = (TemporaryRowHolderResultSet)this.futureForUpdateRows.getResultSet();
                    this.futureRowResultSet.openCore();
                }
                if ((execRow2 = this.futureRowResultSet.getNextRowCore()) != null) {
                    this.futureRowResultSet.deleteCurrentRow();
                    rowLocation = (RowLocation)execRow2.getColumn(1);
                    ConglomerateController conglomerateController = this.activation.getHeapConglomerateController();
                    if (this.sparseRow == null) {
                        this.getSparseRowAndMap();
                    }
                    conglomerateController.fetch(rowLocation, this.sparseRow.getRowArray(), this.sparseRowMap);
                    RowLocation rowLocation2 = (RowLocation)rowLocation.getClone();
                    this.currentRow.setColumn(this.currentRow.nColumns(), rowLocation2);
                    this.candidate.setColumn(this.candidate.nColumns(), rowLocation2);
                    execRow = this.currentRow;
                    this.currentRowPrescanned = true;
                } else if (this.sourceDrained) {
                    this.currentRowPrescanned = true;
                    this.currentRow = null;
                }
                if (this.currentRowPrescanned) {
                    this.setCurrentRow(execRow);
                    this.nextTime += this.getElapsedMillis(this.beginTime);
                    return execRow;
                }
            }
        }
        if (this.isOpen && !this.nextDone) {
            this.nextDone = this.oneRowScan;
            if (this.scanControllerOpened) {
                boolean bl;
                while (bl = this.scanController.fetchNext(this.candidate.getRowArray())) {
                    ++this.rowsSeen;
                    ++this.rowsThisScan;
                    if (!this.sameStartStopPosition && this.skipRow(this.candidate)) {
                        ++this.rowsFiltered;
                        continue;
                    }
                    if (this.past2FutureTbl != null && this.past2FutureTbl.get(rowLocation = (RowLocation)this.currentRow.getColumn(this.currentRow.nColumns())) != null) {
                        this.past2FutureTbl.remove(rowLocation);
                        continue;
                    }
                    execRow = this.currentRow;
                    break;
                }
                if (!bl) {
                    this.setRowCountIfPossible(this.rowsThisScan);
                    this.currentRow = null;
                }
            }
        }
        this.setCurrentRow(execRow);
        this.currentRowIsValid = true;
        this.scanRepositioned = false;
        this.qualify = true;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            ConglomerateController conglomerateController;
            this.clearCurrentRow();
            if (this.scanController != null) {
                if (this.runTimeStatisticsOn) {
                    this.scanProperties = this.getScanProperties();
                    this.startPositionString = this.printStartPosition();
                    this.stopPositionString = this.printStopPosition();
                }
                this.scanController.close();
                this.scanController = null;
                this.activation.clearIndexScanInfo();
            }
            this.scanControllerOpened = false;
            this.startPosition = null;
            this.stopPosition = null;
            super.close();
            if (this.indexCols != null && (conglomerateController = this.activation.getHeapConglomerateController()) != null) {
                conglomerateController.close();
                this.activation.clearHeapConglomerateController();
            }
            if (this.futureRowResultSet != null) {
                this.futureRowResultSet.close();
            }
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l;
        }
        return l;
    }

    public RowLocation getRowLocation() throws StandardException {
        RowLocation rowLocation;
        if (!this.isOpen) {
            return null;
        }
        if (!this.scanControllerOpened) {
            return null;
        }
        if (this.isKeyed) {
            rowLocation = (RowLocation)this.currentRow.getColumn(this.currentRow.nColumns());
        } else if (this.currentRowIsValid) {
            if (this.rlTemplate == null) {
                this.rlTemplate = this.scanController.newRowLocationTemplate();
            }
            rowLocation = this.rlTemplate;
            try {
                this.scanController.fetchLocation(rowLocation);
            }
            catch (StandardException standardException) {
                if (standardException.getMessageId().equals("XSCH7.S")) {
                    throw StandardException.newException("24000");
                }
                throw standardException;
            }
        } else {
            rowLocation = null;
        }
        return rowLocation;
    }

    public ExecRow getCurrentRow() throws StandardException {
        ExecRow execRow;
        block7: {
            execRow = null;
            if (this.currentRowPrescanned) {
                return this.currentRow;
            }
            try {
                if (this.currentRow == null || !this.currentRowIsValid || !this.scanControllerOpened || this.qualify && this.scanController.isCurrentPositionDeleted() || this.qualify && !this.scanController.doesCurrentPositionQualify()) {
                    return null;
                }
            }
            catch (StandardException standardException) {
                if (!standardException.getMessageId().equals("XSAM5.S")) break block7;
                StandardException standardException2 = StandardException.newException("24000");
                throw standardException2;
            }
        }
        execRow = (ExecRow)this.resultRowAllocator.invoke(this.activation);
        this.currentRow = this.getCompactRow(execRow, this.accessedCols, null, this.isKeyed);
        try {
            this.scanController.fetchWithoutQualify(execRow.getRowArray());
        }
        catch (StandardException standardException) {
            if (standardException.getMessageId().equals("XSAM6.S")) {
                return null;
            }
            throw standardException;
        }
        this.setCurrentRow(execRow);
        return this.currentRow;
    }

    public void positionScanAtRowLocation(RowLocation rowLocation) throws StandardException {
        if (!this.isKeyed) {
            this.currentRowIsValid = this.scanController.positionAtRowLocation(rowLocation);
        }
        this.qualify = false;
        this.scanRepositioned = true;
    }

    public String printStartPosition() {
        return this.printPosition(this.startSearchOperator, this.startKeyGetter, this.startPosition);
    }

    public String printStopPosition() {
        if (this.sameStartStopPosition) {
            return this.printPosition(this.stopSearchOperator, this.startKeyGetter, this.startPosition);
        }
        return this.printPosition(this.stopSearchOperator, this.stopKeyGetter, this.stopPosition);
    }

    private String printPosition(int n, GeneratedMethod generatedMethod, ExecIndexRow execIndexRow) {
        String string = "";
        String string2 = "";
        if (generatedMethod == null) {
            return "\t" + MessageService.getTextMessage("42Z37.U") + "\n";
        }
        if (execIndexRow == null) {
            try {
                execIndexRow = (ExecIndexRow)generatedMethod.invoke(this.activation);
            }
            catch (StandardException standardException) {
                if (standardException.getSQLState() == "38000") {
                    return "\t" + MessageService.getTextMessage("42Z38.U");
                }
                return "\t" + MessageService.getTextMessage("42Z39.U", standardException.toString());
            }
        }
        if (execIndexRow == null) {
            return "\t" + MessageService.getTextMessage("42Z37.U") + "\n";
        }
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = ">=";
                break;
            }
            case -1: {
                string3 = ">";
                break;
            }
            default: {
                string3 = "unknown value (" + n + ")";
            }
        }
        string2 = string2 + "\t" + MessageService.getTextMessage("42Z40.U", string3, String.valueOf(execIndexRow.nColumns())) + "\n";
        string2 = string2 + "\t" + MessageService.getTextMessage("42Z41.U") + "\n";
        for (int i = 0; i < execIndexRow.nColumns(); ++i) {
            if (!execIndexRow.areNullsOrdered(i)) continue;
            string2 = string2 + i + " ";
        }
        return string2 + "\n";
    }

    public Properties getScanProperties() {
        if (this.scanProperties == null) {
            this.scanProperties = new Properties();
        }
        try {
            if (this.scanController != null) {
                this.scanController.getScanInfo().getAllScanInfo(this.scanProperties);
                this.coarserLock = this.scanController.isTableLocked() && this.lockMode == 6;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return this.scanProperties;
    }

    public int getScanIsolationLevel() {
        return this.isolationLevel;
    }

    public boolean requiresRelocking() {
        return this.isolationLevel == 3;
    }

    protected final void setRowCountIfPossible(long l) throws StandardException {
        if (!(this.scanController.isKeyed() || this.qualifiers != null && this.qualifiers.length != 0 || this.forUpdate)) {
            long l2 = l - this.estimatedRowCount;
            long l3 = this.estimatedRowCount / 10L;
            if (l2 < 0L) {
                l2 = -l2;
            }
            if (l2 > l3) {
                this.scanController.setEstimatedRowCount(l);
            }
        }
    }

    protected boolean canGetInstantaneousLocks() {
        return false;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }
}

