/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xml.decoder;

import org.apache.vysper.xml.decoder.XMLElementBuilderFactory;
import org.apache.vysper.xml.fragment.AbstractXMLElementBuilder;
import org.apache.vysper.xml.fragment.Renderer;
import org.apache.vysper.xml.fragment.XMLElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMPPContentHandler
implements ContentHandler {
    private Logger log = LoggerFactory.getLogger(XMPPContentHandler.class);
    private XMLElementBuilderFactory builderFactory = new XMLElementBuilderFactory();
    private AbstractXMLElementBuilder builder;
    private int depth = 0;
    private StanzaListener listener;

    public StanzaListener getListener() {
        return this.listener;
    }

    public void setListener(StanzaListener listener) {
        this.listener = listener;
    }

    public XMPPContentHandler() {
    }

    public XMPPContentHandler(XMLElementBuilderFactory builderFactory) {
        this.builderFactory = builderFactory;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.builder != null) {
            this.builder.addText(new String(ch));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.depth;
        if (this.depth == 1) {
            this.emitStanza();
        } else if (this.depth != 0) {
            this.builder.endInnerElement();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ++this.depth;
        if (this.builder == null) {
            this.builder = this.builderFactory.createBuilder(localName, uri, this.extractPrefix(qName), null, null);
        } else {
            this.builder.startInnerElement(localName, uri);
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            this.builder.addAttribute(atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
        }
        if (this.depth == 1) {
            this.emitStanza();
        }
    }

    private void emitStanza() {
        Object element = this.builder.build();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Decoder writing stanza: {}", (Object)new Renderer((XMLElement)element).getComplete());
        }
        if (this.listener != null) {
            this.listener.stanza((XMLElement)element);
        }
        this.builder = null;
    }

    private String extractPrefix(String qname) {
        int index = qname.indexOf(58);
        if (index > -1) {
            return qname.substring(0, index);
        }
        return "";
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.depth = 0;
        this.builder = null;
    }

    public static interface StanzaListener {
        public void stanza(XMLElement var1);
    }
}

