/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.poi.hssf.model.Sheet;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.usermodel.HSSFCell;

public class HSSFRow
implements Comparable {
    public static final int INITIAL_CAPACITY = 5;
    private int rowNum;
    private HSSFCell[] cells = new HSSFCell[5];
    private RowRecord row;
    private Workbook book;
    private Sheet sheet;

    protected HSSFRow() {
    }

    protected HSSFRow(Workbook book, Sheet sheet, int rowNum) {
        this.rowNum = rowNum;
        this.book = book;
        this.sheet = sheet;
        this.row = new RowRecord();
        this.row.setOptionFlags((short)256);
        this.row.setHeight((short)255);
        this.row.setLastCol((short)-1);
        this.row.setFirstCol((short)-1);
        this.setRowNum(rowNum);
    }

    protected HSSFRow(Workbook book, Sheet sheet, RowRecord record) {
        this.book = book;
        this.sheet = sheet;
        this.row = record;
        this.setRowNum(record.getRowNumber());
    }

    public HSSFCell createCell(short column) {
        return this.createCell(column, 3);
    }

    public HSSFCell createCell(short column, int type) {
        HSSFCell cell = new HSSFCell(this.book, this.sheet, this.getRowNum(), column, type);
        this.addCell(cell);
        this.sheet.addValueRecord(this.getRowNum(), cell.getCellValueRecord());
        return cell;
    }

    public void removeCell(HSSFCell cell) {
        this.removeCell(cell, true);
    }

    private void removeCell(HSSFCell cell, boolean alsoRemoveRecords) {
        if (alsoRemoveRecords) {
            CellValueRecordInterface cval = cell.getCellValueRecord();
            this.sheet.removeValueRecord(this.getRowNum(), cval);
        }
        short column = cell.getCellNum();
        if (cell != null && column < this.cells.length) {
            this.cells[column] = null;
        }
        if (cell.getCellNum() == this.row.getLastCol()) {
            this.row.setLastCol(this.findLastCell(this.row.getLastCol()));
        }
        if (cell.getCellNum() == this.row.getFirstCol()) {
            this.row.setFirstCol(this.findFirstCell(this.row.getFirstCol()));
        }
    }

    protected HSSFCell createCellFromRecord(CellValueRecordInterface cell) {
        HSSFCell hcell = new HSSFCell(this.book, this.sheet, this.getRowNum(), cell);
        this.addCell(hcell);
        return hcell;
    }

    public void setRowNum(int rowNum) {
        if (rowNum < 0 || rowNum > 65535) {
            throw new IndexOutOfBoundsException("Row number must be between 0 and 65535, was <" + rowNum + ">");
        }
        this.rowNum = rowNum;
        if (this.row != null) {
            this.row.setRowNumber(rowNum);
        }
    }

    public int getRowNum() {
        return this.rowNum;
    }

    protected int getOutlineLevel() {
        return this.row.getOutlineLevel();
    }

    public void moveCell(HSSFCell cell, short newColumn) {
        if (this.cells.length > newColumn && this.cells[newColumn] != null) {
            throw new IllegalArgumentException("Asked to move cell to column " + newColumn + " but there's already a cell there");
        }
        if (!this.cells[cell.getCellNum()].equals(cell)) {
            throw new IllegalArgumentException("Asked to move a cell, but it didn't belong to our row");
        }
        this.removeCell(cell, false);
        cell.updateCellNum(newColumn);
        this.addCell(cell);
    }

    private void addCell(HSSFCell cell) {
        short column = cell.getCellNum();
        if (this.row.getFirstCol() == -1) {
            this.row.setFirstCol(column);
        }
        if (this.row.getLastCol() == -1) {
            this.row.setLastCol(column);
        }
        if (column >= this.cells.length) {
            HSSFCell[] oldCells = this.cells;
            int newSize = oldCells.length * 2;
            if (newSize < column + 1) {
                newSize = column + 1;
            }
            this.cells = new HSSFCell[newSize];
            System.arraycopy(oldCells, 0, this.cells, 0, oldCells.length);
        }
        this.cells[column] = cell;
        if (column < this.row.getFirstCol()) {
            this.row.setFirstCol(column);
        }
        if (column > this.row.getLastCol()) {
            this.row.setLastCol(column);
        }
    }

    public HSSFCell getCell(short cellnum) {
        if (cellnum < 0 || cellnum >= this.cells.length) {
            return null;
        }
        return this.cells[cellnum];
    }

    public short getFirstCellNum() {
        if (this.getPhysicalNumberOfCells() == 0) {
            return -1;
        }
        return this.row.getFirstCol();
    }

    public short getLastCellNum() {
        if (this.getPhysicalNumberOfCells() == 0) {
            return -1;
        }
        return this.row.getLastCol();
    }

    public int getPhysicalNumberOfCells() {
        int count = 0;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            ++count;
        }
        return count;
    }

    public void setHeight(short height) {
        this.row.setBadFontHeight(true);
        this.row.setHeight(height);
    }

    public void setZeroHeight(boolean zHeight) {
        this.row.setZeroHeight(zHeight);
    }

    public boolean getZeroHeight() {
        return this.row.getZeroHeight();
    }

    public void setHeightInPoints(float height) {
        this.row.setBadFontHeight(true);
        this.row.setHeight((short)(height * 20.0f));
    }

    public short getHeight() {
        return this.row.getHeight();
    }

    public float getHeightInPoints() {
        return this.row.getHeight() / 20;
    }

    protected RowRecord getRowRecord() {
        return this.row;
    }

    private short findLastCell(short lastcell) {
        short cellnum;
        HSSFCell r = this.getCell(cellnum);
        for (cellnum = (short)(lastcell - 1); r == null && cellnum >= 0; cellnum = (short)(cellnum - 1)) {
            r = this.getCell(cellnum);
        }
        return cellnum;
    }

    private short findFirstCell(short firstcell) {
        short cellnum;
        HSSFCell r = this.getCell(cellnum);
        for (cellnum = (short)(firstcell + 1); r == null && cellnum <= this.getLastCellNum(); cellnum = (short)(cellnum + 1)) {
            r = this.getCell(cellnum);
        }
        if (cellnum > this.getLastCellNum()) {
            return -1;
        }
        return cellnum;
    }

    public Iterator cellIterator() {
        return new CellIterator();
    }

    public int compareTo(Object obj) {
        HSSFRow loc = (HSSFRow)obj;
        if (this.getRowNum() == loc.getRowNum()) {
            return 0;
        }
        if (this.getRowNum() < loc.getRowNum()) {
            return -1;
        }
        if (this.getRowNum() > loc.getRowNum()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HSSFRow)) {
            return false;
        }
        HSSFRow loc = (HSSFRow)obj;
        return this.getRowNum() == loc.getRowNum();
    }

    private class CellIterator
    implements Iterator {
        int thisId = -1;
        int nextId = -1;

        public CellIterator() {
            this.findNext();
        }

        public boolean hasNext() {
            return this.nextId < HSSFRow.this.cells.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            HSSFCell cell = HSSFRow.this.cells[this.nextId];
            this.thisId = this.nextId;
            this.findNext();
            return cell;
        }

        public void remove() {
            if (this.thisId == -1) {
                throw new IllegalStateException("remove() called before next()");
            }
            ((HSSFRow)HSSFRow.this).cells[this.thisId] = null;
        }

        private void findNext() {
            int i;
            for (i = this.nextId + 1; i < HSSFRow.this.cells.length && HSSFRow.this.cells[i] == null; ++i) {
            }
            this.nextId = i;
        }
    }
}

