/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Arrays;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.EmptyRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TTL;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.Type;
import org.xbill.DNS.UNKRecord;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.utils.base16;

public abstract class Record
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 2694906050116005466L;
    protected Name name;
    protected int type;
    protected int dclass;
    protected long ttl;
    private static final DecimalFormat byteFormat = new DecimalFormat();

    protected Record() {
    }

    Record(Name name, int type, int dclass, long ttl) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        Type.check(type);
        DClass.check(dclass);
        TTL.check(ttl);
        this.name = name;
        this.type = type;
        this.dclass = dclass;
        this.ttl = ttl;
    }

    abstract Record getObject();

    private static final Record getEmptyRecord(Name name, int type, int dclass, long ttl, boolean hasData) {
        Record proto;
        Record rec = hasData ? ((proto = Type.getProto(type)) != null ? proto.getObject() : new UNKRecord()) : new EmptyRecord();
        rec.name = name;
        rec.type = type;
        rec.dclass = dclass;
        rec.ttl = ttl;
        return rec;
    }

    abstract void rrFromWire(DNSInput var1) throws IOException;

    private static Record newRecord(Name name, int type, int dclass, long ttl, int length, DNSInput in) throws IOException {
        Record rec = Record.getEmptyRecord(name, type, dclass, ttl, in != null);
        if (in != null) {
            if (in.remaining() < length) {
                throw new WireParseException("truncated record");
            }
            in.setActive(length);
            rec.rrFromWire(in);
            if (in.remaining() > 0) {
                throw new WireParseException("invalid record length");
            }
            in.clearActive();
        }
        return rec;
    }

    public static Record newRecord(Name name, int type, int dclass, long ttl, int length, byte[] data) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        Type.check(type);
        DClass.check(dclass);
        TTL.check(ttl);
        DNSInput in = data != null ? new DNSInput(data) : null;
        try {
            return Record.newRecord(name, type, dclass, ttl, length, in);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Record newRecord(Name name, int type, int dclass, long ttl, byte[] data) {
        return Record.newRecord(name, type, dclass, ttl, data.length, data);
    }

    public static Record newRecord(Name name, int type, int dclass, long ttl) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        Type.check(type);
        DClass.check(dclass);
        TTL.check(ttl);
        return Record.getEmptyRecord(name, type, dclass, ttl, false);
    }

    public static Record newRecord(Name name, int type, int dclass) {
        return Record.newRecord(name, type, dclass, 0L);
    }

    static Record fromWire(DNSInput in, int section, boolean isUpdate) throws IOException {
        Name name = new Name(in);
        int type = in.readU16();
        int dclass = in.readU16();
        if (section == 0) {
            return Record.newRecord(name, type, dclass);
        }
        long ttl = in.readU32();
        int length = in.readU16();
        if (length == 0 && isUpdate) {
            return Record.newRecord(name, type, dclass, ttl);
        }
        Record rec = Record.newRecord(name, type, dclass, ttl, length, in);
        return rec;
    }

    static Record fromWire(DNSInput in, int section) throws IOException {
        return Record.fromWire(in, section, false);
    }

    public static Record fromWire(byte[] b, int section) throws IOException {
        return Record.fromWire(new DNSInput(b), section, false);
    }

    void toWire(DNSOutput out, int section, Compression c) {
        this.name.toWire(out, c);
        out.writeU16(this.type);
        out.writeU16(this.dclass);
        if (section == 0) {
            return;
        }
        out.writeU32(this.ttl);
        int lengthPosition = out.current();
        out.writeU16(0);
        this.rrToWire(out, c, false);
        int rrlength = out.current() - lengthPosition - 2;
        out.save();
        out.jump(lengthPosition);
        out.writeU16(rrlength);
        out.restore();
    }

    public byte[] toWire(int section) {
        DNSOutput out = new DNSOutput();
        this.toWire(out, section, null);
        return out.toByteArray();
    }

    private void toWireCanonical(DNSOutput out, boolean noTTL) {
        this.name.toWireCanonical(out);
        out.writeU16(this.type);
        out.writeU16(this.dclass);
        if (noTTL) {
            out.writeU32(0L);
        } else {
            out.writeU32(this.ttl);
        }
        int lengthPosition = out.current();
        out.writeU16(0);
        this.rrToWire(out, null, true);
        int rrlength = out.current() - lengthPosition - 2;
        out.save();
        out.jump(lengthPosition);
        out.writeU16(rrlength);
        out.restore();
    }

    private byte[] toWireCanonical(boolean noTTL) {
        DNSOutput out = new DNSOutput();
        this.toWireCanonical(out, noTTL);
        return out.toByteArray();
    }

    public byte[] toWireCanonical() {
        return this.toWireCanonical(false);
    }

    public byte[] rdataToWireCanonical() {
        DNSOutput out = new DNSOutput();
        this.rrToWire(out, null, true);
        return out.toByteArray();
    }

    abstract String rrToString();

    public String rdataToString() {
        return this.rrToString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        if (sb.length() < 8) {
            sb.append("\t");
        }
        if (sb.length() < 16) {
            sb.append("\t");
        }
        sb.append("\t");
        if (Options.check("BINDTTL")) {
            sb.append(TTL.format(this.ttl));
        } else {
            sb.append(this.ttl);
        }
        sb.append("\t");
        if (this.dclass != 1 || !Options.check("noPrintIN")) {
            sb.append(DClass.string(this.dclass));
            sb.append("\t");
        }
        sb.append(Type.string(this.type));
        String rdata = this.rrToString();
        if (!rdata.equals("")) {
            sb.append("\t");
            sb.append(rdata);
        }
        return sb.toString();
    }

    abstract void rdataFromString(Tokenizer var1, Name var2) throws IOException;

    protected static byte[] byteArrayFromString(String s) throws TextParseException {
        byte[] array = s.getBytes();
        boolean escaped = false;
        boolean hasEscapes = false;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != 92) continue;
            hasEscapes = true;
            break;
        }
        if (!hasEscapes) {
            if (array.length > 255) {
                throw new TextParseException("text string too long");
            }
            return array;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int digits = 0;
        int intval = 0;
        for (int i = 0; i < array.length; ++i) {
            byte b = array[i];
            if (escaped) {
                if (b >= 48 && b <= 57 && digits < 3) {
                    ++digits;
                    intval *= 10;
                    if ((intval += b - 48) > 255) {
                        throw new TextParseException("bad escape");
                    }
                    if (digits < 3) continue;
                    b = (byte)intval;
                } else if (digits > 0 && digits < 3) {
                    throw new TextParseException("bad escape");
                }
                os.write(b);
                escaped = false;
                continue;
            }
            if (array[i] == 92) {
                escaped = true;
                digits = 0;
                intval = 0;
                continue;
            }
            os.write(array[i]);
        }
        if (digits > 0 && digits < 3) {
            throw new TextParseException("bad escape");
        }
        array = os.toByteArray();
        if (array.length > 255) {
            throw new TextParseException("text string too long");
        }
        return os.toByteArray();
    }

    protected static String byteArrayToString(byte[] array, boolean quote) {
        StringBuffer sb = new StringBuffer();
        if (quote) {
            sb.append('\"');
        }
        for (int i = 0; i < array.length; ++i) {
            int b = array[i] & 0xFF;
            if (b < 32 || b >= 127) {
                sb.append('\\');
                sb.append(byteFormat.format(b));
                continue;
            }
            if (b == 34 || b == 92) {
                sb.append('\\');
                sb.append((char)b);
                continue;
            }
            sb.append((char)b);
        }
        if (quote) {
            sb.append('\"');
        }
        return sb.toString();
    }

    protected static String unknownToString(byte[] data) {
        StringBuffer sb = new StringBuffer();
        sb.append("\\# ");
        sb.append(data.length);
        sb.append(" ");
        sb.append(base16.toString(data));
        return sb.toString();
    }

    public static Record fromString(Name name, int type, int dclass, long ttl, Tokenizer st, Name origin) throws IOException {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        Type.check(type);
        DClass.check(dclass);
        TTL.check(ttl);
        Tokenizer.Token t = st.get();
        if (t.type == 3 && t.value.equals("\\#")) {
            int length = st.getUInt16();
            byte[] data = st.getHex();
            if (data == null) {
                data = new byte[]{};
            }
            if (length != data.length) {
                throw st.exception("invalid unknown RR encoding: length mismatch");
            }
            DNSInput in = new DNSInput(data);
            return Record.newRecord(name, type, dclass, ttl, length, in);
        }
        st.unget();
        Record rec = Record.getEmptyRecord(name, type, dclass, ttl, true);
        rec.rdataFromString(st, origin);
        t = st.get();
        if (t.type != 1 && t.type != 0) {
            throw st.exception("unexpected tokens at end of record");
        }
        return rec;
    }

    public static Record fromString(Name name, int type, int dclass, long ttl, String s, Name origin) throws IOException {
        return Record.fromString(name, type, dclass, ttl, new Tokenizer(s), origin);
    }

    public Name getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getRRsetType() {
        if (this.type == 46) {
            RRSIGRecord sig = (RRSIGRecord)this;
            return sig.getTypeCovered();
        }
        return this.type;
    }

    public int getDClass() {
        return this.dclass;
    }

    public long getTTL() {
        return this.ttl;
    }

    abstract void rrToWire(DNSOutput var1, Compression var2, boolean var3);

    public boolean sameRRset(Record rec) {
        return this.getRRsetType() == rec.getRRsetType() && this.dclass == rec.dclass && this.name.equals(rec.name);
    }

    public boolean equals(Object arg) {
        if (arg == null || !(arg instanceof Record)) {
            return false;
        }
        Record r = (Record)arg;
        if (this.type != r.type || this.dclass != r.dclass || !this.name.equals(r.name)) {
            return false;
        }
        byte[] array1 = this.rdataToWireCanonical();
        byte[] array2 = r.rdataToWireCanonical();
        return Arrays.equals(array1, array2);
    }

    public int hashCode() {
        byte[] array = this.toWireCanonical(true);
        int code = 0;
        for (int i = 0; i < array.length; ++i) {
            code += (code << 3) + (array[i] & 0xFF);
        }
        return code;
    }

    Record cloneRecord() {
        try {
            return (Record)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public Record withName(Name name) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        Record rec = this.cloneRecord();
        rec.name = name;
        return rec;
    }

    Record withDClass(int dclass, long ttl) {
        Record rec = this.cloneRecord();
        rec.dclass = dclass;
        rec.ttl = ttl;
        return rec;
    }

    void setTTL(long ttl) {
        this.ttl = ttl;
    }

    public int compareTo(Object o) {
        Record arg = (Record)o;
        if (this == arg) {
            return 0;
        }
        int n = this.name.compareTo(arg.name);
        if (n != 0) {
            return n;
        }
        n = this.dclass - arg.dclass;
        if (n != 0) {
            return n;
        }
        n = this.type - arg.type;
        if (n != 0) {
            return n;
        }
        byte[] rdata1 = this.rdataToWireCanonical();
        byte[] rdata2 = arg.rdataToWireCanonical();
        for (int i = 0; i < rdata1.length && i < rdata2.length; ++i) {
            n = (rdata1[i] & 0xFF) - (rdata2[i] & 0xFF);
            if (n == 0) continue;
            return n;
        }
        return rdata1.length - rdata2.length;
    }

    public Name getAdditionalName() {
        return null;
    }

    static int checkU8(String field, int val) {
        if (val < 0 || val > 255) {
            throw new IllegalArgumentException("\"" + field + "\" " + val + " must be an unsigned 8 " + "bit value");
        }
        return val;
    }

    static int checkU16(String field, int val) {
        if (val < 0 || val > 65535) {
            throw new IllegalArgumentException("\"" + field + "\" " + val + " must be an unsigned 16 " + "bit value");
        }
        return val;
    }

    static long checkU32(String field, long val) {
        if (val < 0L || val > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("\"" + field + "\" " + val + " must be an unsigned 32 " + "bit value");
        }
        return val;
    }

    static Name checkName(String field, Name name) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        return name;
    }

    static {
        byteFormat.setMinimumIntegerDigits(3);
    }
}

