/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate.regions;

import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.StripedReadWriteLockSync;
import net.sf.ehcache.hibernate.regions.EhcacheDataRegion;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.TransactionalDataRegion;
import org.hibernate.cfg.Settings;

public class EhcacheTransactionalDataRegion
extends EhcacheDataRegion
implements TransactionalDataRegion {
    private static final int LOCAL_LOCK_PROVIDER_CONCURRENCY = 128;
    protected final Settings settings;
    protected final CacheDataDescription metadata;
    private final CacheLockProvider lockProvider;

    EhcacheTransactionalDataRegion(Ehcache cache, Settings settings, CacheDataDescription metadata, Properties properties) {
        super(cache, properties);
        this.settings = settings;
        this.metadata = metadata;
        Object context = cache.getInternalContext();
        this.lockProvider = context instanceof CacheLockProvider ? (CacheLockProvider)context : new StripedReadWriteLockSync(128);
    }

    public boolean isTransactionAware() {
        return false;
    }

    public CacheDataDescription getCacheDataDescription() {
        return this.metadata;
    }

    public final Object get(Object key) {
        try {
            Element element = this.cache.get(key);
            if (element == null) {
                return null;
            }
            return element.getObjectValue();
        }
        catch (CacheException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }

    public final void put(Object key, Object value) throws org.hibernate.cache.CacheException {
        try {
            Element element = new Element(key, value);
            this.cache.put(element);
        }
        catch (IllegalArgumentException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
        catch (CacheException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }

    public final void remove(Object key) throws org.hibernate.cache.CacheException {
        try {
            this.cache.remove(key);
        }
        catch (ClassCastException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }

    public final void clear() throws org.hibernate.cache.CacheException {
        try {
            this.cache.removeAll();
        }
        catch (IllegalStateException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
        catch (CacheException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }

    public final void writeLock(Object key) {
        this.lockProvider.getSyncForKey(key).lock(LockType.WRITE);
    }

    public final void writeUnlock(Object key) {
        this.lockProvider.getSyncForKey(key).unlock(LockType.WRITE);
    }

    public final void readLock(Object key) {
        this.lockProvider.getSyncForKey(key).lock(LockType.WRITE);
    }

    public final void readUnlock(Object key) {
        this.lockProvider.getSyncForKey(key).unlock(LockType.WRITE);
    }

    public final boolean locksAreIndependentOfCache() {
        return this.lockProvider instanceof StripedReadWriteLockSync;
    }
}

