/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface DispatcherMeta {
    default public boolean isHidden() {
        return false;
    }

    public String name();

    public String displayName();

    public Collection<Field> fields();

    public static final class Field {
        private final String key;
        private final boolean optional;
        private final String defaultValue;
        private final String description;
        private final List<Field> options;

        private Field(String key, boolean optional, String defaultValue, String description, List<Field> options) {
            this.key = Objects.requireNonNull(key);
            this.optional = optional;
            this.defaultValue = defaultValue;
            this.description = Objects.requireNonNull(description);
            this.options = options;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public Optional<String> getDefaultValue() {
            return Optional.ofNullable(this.defaultValue);
        }

        public String getDescription() {
            return this.description;
        }

        public Optional<List<Field>> getOptions() {
            return Optional.ofNullable(this.options);
        }

        public static Builder builder(String key) {
            return new Builder(key);
        }

        public static final class Builder {
            private final String key;
            private boolean optional;
            private String defaultValue;
            private String description;
            private List<Field> options;

            private Builder(String key) {
                this.key = Objects.requireNonNull(key);
            }

            public Builder optional(boolean optional) {
                this.optional = optional;
                return this;
            }

            public Builder defaultValue(String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public Builder description(String description) {
                this.description = Objects.requireNonNull(description);
                return this;
            }

            public Builder options(List<Field> options) {
                this.options = Objects.requireNonNull(options);
                return this;
            }

            public Field build() {
                return new Field(this.key, this.optional, this.defaultValue, this.description, this.options);
            }
        }
    }
}

