/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnenc;

import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.mvnenc.EncryptOptions;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.cling.invoker.LookupContext;
import org.apache.maven.cling.invoker.LookupInvoker;
import org.apache.maven.cling.invoker.mvnenc.EncryptContext;
import org.apache.maven.cling.invoker.mvnenc.Goal;
import org.apache.maven.cling.utils.CLIReportingUtils;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Colors;

public class EncryptInvoker
extends LookupInvoker<EncryptContext> {
    public static final int OK = 0;
    public static final int ERROR = 1;
    public static final int BAD_OPERATION = 2;
    public static final int CANCELED = 3;

    public EncryptInvoker(Lookup protoLookup) {
        this(protoLookup, null);
    }

    public EncryptInvoker(Lookup protoLookup, @Nullable Consumer<LookupContext> contextConsumer) {
        super(protoLookup, contextConsumer);
    }

    @Override
    protected EncryptContext createContext(InvokerRequest invokerRequest) {
        return new EncryptContext(invokerRequest);
    }

    @Override
    protected void lookup(EncryptContext context) throws Exception {
        if (context.goals == null) {
            super.lookup(context);
            context.goals = context.lookup.lookupMap(Goal.class);
        }
    }

    @Override
    protected int execute(EncryptContext context) throws Exception {
        try {
            context.header = new ArrayList<AttributedString>();
            context.style = new AttributedStyle();
            context.addInHeader(context.style.italic().bold().foreground(Colors.rgbColor((String)"green").intValue()), "Maven Encryption " + CLIReportingUtils.showVersionMinimal());
            context.addInHeader("Tool for secure password management on workstations.");
            context.addInHeader("This tool is part of Apache Maven 4 distribution.");
            context.addInHeader("");
            context.terminal.handle(Terminal.Signal.INT, signal -> Thread.currentThread().interrupt());
            context.reader = LineReaderBuilder.builder().terminal(context.terminal).build();
            EncryptOptions options = (EncryptOptions)context.invokerRequest.options();
            if (options.goals().isEmpty() || ((List)options.goals().get()).size() != 1) {
                return this.badGoalsErrorMessage("No goal or multiple goals specified, specify only one goal.", context);
            }
            String goalName = (String)((List)options.goals().get()).get(0);
            Goal goal = context.goals.get(goalName);
            if (goal == null) {
                return this.badGoalsErrorMessage("Unknown goal: " + goalName, context);
            }
            return goal.execute(context);
        }
        catch (InterruptedIOException | InterruptedException | UserInterruptException e) {
            context.logger.error("Goal canceled by user.");
            return 3;
        }
        catch (Exception e) {
            if (context.invokerRequest.options().showErrors().orElse(false).booleanValue()) {
                context.logger.error(e.getMessage(), (Throwable)e);
            } else {
                context.logger.error(e.getMessage());
            }
            return 1;
        }
    }

    protected int badGoalsErrorMessage(String message, EncryptContext context) {
        context.logger.error(message);
        context.logger.error("Supported goals are: " + String.join((CharSequence)", ", context.goals.keySet()));
        context.logger.error("Use -h to display help.");
        return 2;
    }
}

