/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.util.Locale;

public enum Os {
    LINUX(true),
    MAC(true),
    WINDOWS(false){
        private boolean cygwin;
        {
            String pwd = System.getenv("PWD");
            this.cygwin = pwd != null && pwd.startsWith("/");
        }

        @Override
        public boolean isCygwin() {
            return this.cygwin;
        }
    }
    ,
    UNKNOWN(false){

        @Override
        public boolean isUnixLike() {
            throw new UnsupportedOperationException("Cannot tell isUnixLike() for an " + UNKNOWN.name() + " OS");
        }
    };

    private static final Os CURRENT;
    private final boolean unixLike;

    public static Os current() {
        return CURRENT;
    }

    private Os(boolean unixLike) {
        this.unixLike = unixLike;
    }

    public boolean isUnixLike() {
        return this.unixLike;
    }

    public boolean isCygwin() {
        return false;
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        CURRENT = osName.startsWith("osx") || osName.startsWith("mac os x") ? MAC : (osName.contains("win") ? WINDOWS : (osName.contains("linux") ? LINUX : UNKNOWN));
    }
}

