/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model.rootlocator;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.services.model.RootDetector;

@Named
public class PomXmlRootDetector
implements RootDetector {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isRootDirectory(Path dir) {
        Path pom = dir.resolve("pom.xml");
        try (InputStream is = Files.newInputStream(pom, new OpenOption[0]);){
            XMLStreamReader parser = XMLInputFactory.newFactory().createXMLStreamReader(is);
            if (parser.nextTag() != 1) return false;
            if (!parser.getLocalName().equals("project")) return false;
            int i = 0;
            while (i < parser.getAttributeCount()) {
                if ("root".equals(parser.getAttributeLocalName(i))) {
                    boolean bl = Boolean.parseBoolean(parser.getAttributeValue(i));
                    return bl;
                }
                ++i;
            }
            return false;
        }
        catch (IOException | XMLStreamException exception) {
            // empty catch block
        }
        return false;
    }
}

