/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.DependencyResolverResult;
import org.apache.maven.api.services.ProjectBuilderException;
import org.apache.maven.api.services.ProjectBuilderRequest;
import org.apache.maven.api.services.ProjectBuilderResult;
import org.apache.maven.api.services.Request;
import org.apache.maven.api.services.Source;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.impl.DefaultDependencyResolverResult;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.impl.MappedCollection;
import org.apache.maven.impl.RequestTraceHelper;
import org.apache.maven.internal.impl.InternalMavenSession;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;

@Named
@Singleton
public class DefaultProjectBuilder
implements org.apache.maven.api.services.ProjectBuilder {
    private final ProjectBuilder builder;

    @Inject
    public DefaultProjectBuilder(ProjectBuilder builder) {
        this.builder = builder;
    }

    @Nonnull
    public ProjectBuilderResult build(ProjectBuilderRequest request) throws ProjectBuilderException, IllegalArgumentException {
        InternalSession session = InternalSession.from((Session)((Session)request.getSession()));
        return (ProjectBuilderResult)session.request((Request)request, this::doBuild);
    }

    protected ProjectBuilderResult doBuild(final ProjectBuilderRequest request) throws ProjectBuilderException, IllegalArgumentException {
        final InternalMavenSession session = InternalMavenSession.from((Session)request.getSession());
        RequestTraceHelper.ResolverTrace trace = RequestTraceHelper.enter((Session)((Session)request.getSession()), (Object)request);
        try {
            ProjectBuildingResult res;
            List<ArtifactRepository> repositories = session.toArtifactRepositories(request.getRepositories() != null ? request.getRepositories() : session.getRemoteRepositories());
            ProjectBuildingRequest req = new DefaultProjectBuildingRequest().setRepositorySession(session.getSession()).setRemoteRepositories(repositories).setPluginArtifactRepositories(repositories).setProcessPlugins(request.isProcessPlugins());
            if (request.getPath().isPresent()) {
                Path path = (Path)request.getPath().get();
                res = this.builder.build(path.toFile(), req);
            } else if (request.getSource().isPresent()) {
                Source source = (Source)request.getSource().get();
                SourceWrapper modelSource = new SourceWrapper(source);
                res = this.builder.build((ModelSource)modelSource, req);
            } else {
                throw new IllegalArgumentException("Invalid request");
            }
            ProjectBuilderResult projectBuilderResult = new ProjectBuilderResult(){

                public ProjectBuilderRequest getRequest() {
                    return request;
                }

                @Nonnull
                public String getProjectId() {
                    return res.getProjectId();
                }

                @Nonnull
                public Optional<Path> getPomFile() {
                    return Optional.ofNullable(res.getPomFile()).map(File::toPath);
                }

                @Nonnull
                public Optional<Project> getProject() {
                    return Optional.ofNullable(session.getProject(res.getProject()));
                }

                @Nonnull
                public Collection<BuilderProblem> getProblems() {
                    return new MappedCollection(res.getProblems(), this::toProblem);
                }

                private BuilderProblem toProblem(final ModelProblem problem) {
                    return new BuilderProblem(){

                        public String getSource() {
                            return problem.getSource();
                        }

                        public int getLineNumber() {
                            return problem.getLineNumber();
                        }

                        public int getColumnNumber() {
                            return problem.getColumnNumber();
                        }

                        public String getLocation() {
                            StringBuilder buffer = new StringBuilder(256);
                            if (!this.getSource().isEmpty()) {
                                buffer.append(this.getSource());
                            }
                            if (this.getLineNumber() > 0) {
                                if (!buffer.isEmpty()) {
                                    buffer.append(", ");
                                }
                                buffer.append("line ").append(this.getLineNumber());
                            }
                            if (this.getColumnNumber() > 0) {
                                if (!buffer.isEmpty()) {
                                    buffer.append(", ");
                                }
                                buffer.append("column ").append(this.getColumnNumber());
                            }
                            return buffer.toString();
                        }

                        public Exception getException() {
                            return problem.getException();
                        }

                        public String getMessage() {
                            return problem.getMessage();
                        }

                        public BuilderProblem.Severity getSeverity() {
                            return BuilderProblem.Severity.valueOf((String)problem.getSeverity().name());
                        }
                    };
                }

                @Nonnull
                public Optional<DependencyResolverResult> getDependencyResolverResult() {
                    return Optional.ofNullable(res.getDependencyResolutionResult()).map(r -> new DefaultDependencyResolverResult(null, r.getCollectionErrors(), session.getNode(r.getDependencyGraph()), 0));
                }
            };
            return projectBuilderResult;
        }
        catch (ProjectBuildingException e) {
            throw new ProjectBuilderException("Unable to build project", (Exception)e);
        }
        finally {
            RequestTraceHelper.exit((RequestTraceHelper.ResolverTrace)trace);
        }
    }

    private static class SourceWrapper
    implements ModelSource2 {
        private final Source source;

        SourceWrapper(Source source) {
            this.source = source;
        }

        public InputStream getInputStream() throws IOException {
            return this.source.openStream();
        }

        public String getLocation() {
            return this.source.getLocation();
        }

        public ModelSource2 getRelatedSource(String relPath) {
            Source rel = this.source.resolve(relPath);
            return rel != null ? new SourceWrapper(rel) : null;
        }

        public URI getLocationURI() {
            Path path = this.source.getPath();
            return path != null ? path.toUri() : URI.create(this.source.getLocation());
        }
    }
}

