/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher.internal.sources;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.components.secdispatcher.MasterSource;
import org.codehaus.plexus.components.secdispatcher.MasterSourceMeta;
import org.codehaus.plexus.components.secdispatcher.PinEntry;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.SecDispatcherException;
import org.codehaus.plexus.components.secdispatcher.internal.sources.PrefixMasterSourceSupport;

@Singleton
@Named(value="pinentry-prompt")
public class PinEntryMasterSource
extends PrefixMasterSourceSupport
implements MasterSource,
MasterSourceMeta {
    public static final String NAME = "pinentry-prompt";

    public PinEntryMasterSource() {
        super("pinentry-prompt:");
    }

    @Override
    public String description() {
        return "Secure PinEntry prompt (pinentry path should be edited)";
    }

    @Override
    public Optional<String> configTemplate() {
        return Optional.of("pinentry-prompt:$pinentryPath");
    }

    @Override
    public String doHandle(String s) throws SecDispatcherException {
        try {
            PinEntry.Result result = new PinEntry(s).setTimeout(Duration.ofSeconds(30L)).setKeyInfo("Maven: n/masterPassword").setTitle("Maven Master Password").setDescription("Please enter the Maven master password").setPrompt("Maven master password").setOk("Ok").setCancel("Cancel").getPin();
            if (result.outcome() == PinEntry.Outcome.SUCCESS) {
                return result.payload();
            }
            if (result.outcome() == PinEntry.Outcome.CANCELED) {
                throw new SecDispatcherException("User canceled the operation");
            }
            if (result.outcome() == PinEntry.Outcome.TIMEOUT) {
                throw new SecDispatcherException("Timeout");
            }
            throw new SecDispatcherException("Failure: " + result.payload());
        }
        catch (IOException e) {
            throw new SecDispatcherException("Could not collect the password", e);
        }
    }

    @Override
    protected SecDispatcher.ValidationResponse doValidateConfiguration(String transformed) {
        HashMap<SecDispatcher.ValidationResponse.Level, List<String>> report = new HashMap<SecDispatcher.ValidationResponse.Level, List<String>>();
        boolean valid = false;
        Path pinentry = Paths.get(transformed, new String[0]);
        if (!Files.exists(pinentry, new LinkOption[0])) {
            report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add("Configured pinentry command not found");
        } else if (!Files.isExecutable(pinentry)) {
            report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add("Configured pinentry command is not executable");
        } else {
            report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.INFO, k -> new ArrayList()).add("Configured pinentry command exists and is executable");
            valid = true;
        }
        return new SecDispatcher.ValidationResponse(this.getClass().getSimpleName(), valid, report, List.of());
    }
}

