/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.testng.TestNGException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Configuration;
import org.testng.annotations.DataProvider;
import org.testng.annotations.ExpectedExceptions;
import org.testng.annotations.Factory;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.testng.internal.annotations.ConfigurationAnnotation;
import org.testng.internal.annotations.DataProviderAnnotation;
import org.testng.internal.annotations.ExpectedExceptionsAnnotation;
import org.testng.internal.annotations.FactoryAnnotation;
import org.testng.internal.annotations.IAfterClass;
import org.testng.internal.annotations.IAfterGroups;
import org.testng.internal.annotations.IAfterMethod;
import org.testng.internal.annotations.IAfterSuite;
import org.testng.internal.annotations.IAfterTest;
import org.testng.internal.annotations.IAnnotation;
import org.testng.internal.annotations.IAnnotationTransformer;
import org.testng.internal.annotations.IBeforeClass;
import org.testng.internal.annotations.IBeforeGroups;
import org.testng.internal.annotations.IBeforeMethod;
import org.testng.internal.annotations.IBeforeSuite;
import org.testng.internal.annotations.IBeforeTest;
import org.testng.internal.annotations.IConfiguration;
import org.testng.internal.annotations.IDataProvider;
import org.testng.internal.annotations.IExpectedExceptions;
import org.testng.internal.annotations.IFactory;
import org.testng.internal.annotations.IParameters;
import org.testng.internal.annotations.ITest;
import org.testng.internal.annotations.ParametersAnnotation;
import org.testng.internal.annotations.TestAnnotation;

public class JDK15TagFactory {
    public IAnnotation createTag(Class cls, Annotation a, Class annotationClass, IAnnotationTransformer transformer) {
        IAnnotation result = null;
        if (a != null) {
            if (annotationClass == IConfiguration.class) {
                result = this.createConfigurationTag(cls, a);
            } else if (annotationClass == IDataProvider.class) {
                result = this.createDataProviderTag(a);
            } else if (annotationClass == IExpectedExceptions.class) {
                result = this.createExpectedExceptionsTag(a);
            } else if (annotationClass == IFactory.class) {
                result = this.createFactoryTag(a);
            } else if (annotationClass == IParameters.class) {
                result = this.createParametersTag(a);
            } else if (annotationClass == ITest.class) {
                result = this.createTestTag(cls, a, transformer);
            } else if (annotationClass == IBeforeSuite.class || annotationClass == IAfterSuite.class || annotationClass == IBeforeTest.class || annotationClass == IAfterTest.class || annotationClass == IBeforeGroups.class || annotationClass == IAfterGroups.class || annotationClass == IBeforeClass.class || annotationClass == IAfterClass.class || annotationClass == IBeforeMethod.class || annotationClass == IAfterMethod.class) {
                result = this.maybeCreateNewConfigurationTag(cls, a, annotationClass);
            } else {
                throw new TestNGException("Unknown annotation requested:" + annotationClass);
            }
        }
        return result;
    }

    private IAnnotation maybeCreateNewConfigurationTag(Class cls, Annotation a, Class annotationClass) {
        IAnnotation result = null;
        if (annotationClass == IBeforeSuite.class) {
            BeforeSuite bs = (BeforeSuite)a;
            result = this.createConfigurationTag(cls, a, true, false, false, false, new String[0], new String[0], false, false, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), null);
        } else if (annotationClass == IAfterSuite.class) {
            AfterSuite bs = (AfterSuite)a;
            result = this.createConfigurationTag(cls, a, false, true, false, false, new String[0], new String[0], false, false, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), null);
        } else if (annotationClass == IBeforeTest.class) {
            BeforeTest bs = (BeforeTest)a;
            result = this.createConfigurationTag(cls, a, false, false, true, false, new String[0], new String[0], false, false, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), null);
        } else if (annotationClass == IAfterTest.class) {
            AfterTest bs = (AfterTest)a;
            result = this.createConfigurationTag(cls, a, false, false, false, true, new String[0], new String[0], false, false, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), null);
        } else if (annotationClass == IBeforeGroups.class) {
            BeforeGroups bs = (BeforeGroups)a;
            String[] groups = bs.value().length > 0 ? bs.value() : bs.groups();
            result = this.createConfigurationTag(cls, a, false, false, false, false, groups, new String[0], false, false, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), null);
        } else if (annotationClass == IAfterGroups.class) {
            AfterGroups bs = (AfterGroups)a;
            String[] groups = bs.value().length > 0 ? bs.value() : bs.groups();
            result = this.createConfigurationTag(cls, a, false, false, false, false, new String[0], groups, false, false, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), null);
        } else if (annotationClass == IBeforeClass.class) {
            BeforeClass bs = (BeforeClass)a;
            result = this.createConfigurationTag(cls, a, false, false, false, false, new String[0], new String[0], true, false, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), null);
        } else if (annotationClass == IAfterClass.class) {
            AfterClass bs = (AfterClass)a;
            result = this.createConfigurationTag(cls, a, false, false, false, false, new String[0], new String[0], false, true, false, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), null);
        } else if (annotationClass == IBeforeMethod.class) {
            BeforeMethod bs = (BeforeMethod)a;
            result = this.createConfigurationTag(cls, a, false, false, false, false, new String[0], new String[0], false, false, true, false, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), null);
        } else if (annotationClass == IAfterMethod.class) {
            AfterMethod bs = (AfterMethod)a;
            result = this.createConfigurationTag(cls, a, false, false, false, false, new String[0], new String[0], false, false, false, true, bs.alwaysRun(), bs.dependsOnGroups(), bs.dependsOnMethods(), bs.description(), bs.enabled(), bs.groups(), bs.inheritGroups(), null);
        }
        return result;
    }

    private IAnnotation createConfigurationTag(Class cls, Annotation a) {
        ConfigurationAnnotation result = new ConfigurationAnnotation();
        Configuration c = (Configuration)a;
        result.setBeforeTestClass(c.beforeTestClass());
        result.setAfterTestClass(c.afterTestClass());
        result.setBeforeTestMethod(c.beforeTestMethod());
        result.setAfterTestMethod(c.afterTestMethod());
        result.setBeforeTest(c.beforeTest());
        result.setAfterTest(c.afterTest());
        result.setBeforeSuite(c.beforeSuite());
        result.setAfterSuite(c.afterSuite());
        result.setBeforeGroups(c.beforeGroups());
        result.setAfterGroups(c.afterGroups());
        result.setParameters(c.parameters());
        result.setEnabled(c.enabled());
        result.setGroups(this.join(c.groups(), this.findInheritedStringArray(cls, Test.class, "groups")));
        result.setDependsOnGroups(c.dependsOnGroups());
        result.setDependsOnMethods(c.dependsOnMethods());
        result.setAlwaysRun(c.alwaysRun());
        result.setInheritGroups(c.inheritGroups());
        result.setDescription(c.description());
        return result;
    }

    private IAnnotation createConfigurationTag(Class cls, Annotation a, boolean beforeSuite, boolean afterSuite, boolean beforeTest, boolean afterTest, String[] beforeGroups, String[] afterGroups, boolean beforeClass, boolean afterClass, boolean beforeMethod, boolean afterMethod, boolean alwaysRun, String[] dependsOnGroups, String[] dependsOnMethods, String description, boolean enabled, String[] groups, boolean inheritGroups, String[] parameters) {
        ConfigurationAnnotation result = new ConfigurationAnnotation();
        result.setFakeConfiguration(true);
        result.setBeforeSuite(beforeSuite);
        result.setAfterSuite(afterSuite);
        result.setBeforeTestClass(beforeTest);
        result.setAfterTestClass(afterTest);
        result.setBeforeTestClass(beforeClass);
        result.setAfterTestClass(afterClass);
        result.setBeforeGroups(beforeGroups);
        result.setAfterGroups(afterGroups);
        result.setBeforeTestMethod(beforeMethod);
        result.setAfterTestMethod(afterMethod);
        result.setAlwaysRun(alwaysRun);
        result.setDependsOnGroups(dependsOnGroups);
        result.setDependsOnMethods(dependsOnMethods);
        result.setDescription(description);
        result.setEnabled(enabled);
        result.setGroups(groups);
        result.setInheritGroups(inheritGroups);
        result.setParameters(parameters);
        return result;
    }

    private IAnnotation createDataProviderTag(Annotation a) {
        DataProviderAnnotation result = new DataProviderAnnotation();
        DataProvider c = (DataProvider)a;
        result.setName(c.name());
        return result;
    }

    private IAnnotation createExpectedExceptionsTag(Annotation a) {
        ExpectedExceptionsAnnotation result = new ExpectedExceptionsAnnotation();
        ExpectedExceptions c = (ExpectedExceptions)a;
        result.setValue(c.value());
        return result;
    }

    private IAnnotation createFactoryTag(Annotation a) {
        FactoryAnnotation result = new FactoryAnnotation();
        Factory c = (Factory)a;
        result.setParameters(c.parameters());
        return result;
    }

    private IAnnotation createParametersTag(Annotation a) {
        ParametersAnnotation result = new ParametersAnnotation();
        Parameters c = (Parameters)a;
        result.setValue(c.value());
        return result;
    }

    private IAnnotation createTestTag(Class cls, Annotation a, IAnnotationTransformer transformer) {
        TestAnnotation result = new TestAnnotation();
        Test test = (Test)a;
        result.setEnabled(test.enabled());
        result.setGroups(this.join(test.groups(), this.findInheritedStringArray(cls, Test.class, "groups")));
        result.setParameters(test.parameters());
        result.setDependsOnGroups(this.join(test.dependsOnGroups(), this.findInheritedStringArray(cls, Test.class, "dependsOnGroups")));
        result.setDependsOnMethods(this.join(test.dependsOnMethods(), this.findInheritedStringArray(cls, Test.class, "dependsOnMethods")));
        result.setTimeOut(test.timeOut());
        result.setInvocationCount(test.invocationCount());
        result.setThreadPoolSize(test.threadPoolSize());
        result.setSuccessPercentage(test.successPercentage());
        result.setDataProvider(test.dataProvider());
        result.setDataProviderClass(test.dataProviderClass() != Object.class ? test.dataProviderClass() : null);
        result.setAlwaysRun(test.alwaysRun());
        result.setDescription(test.description());
        result.setExpectedExceptions(test.expectedExceptions());
        result.setSuiteName(test.suiteName());
        result.setTestName(test.testName());
        result.setSequential(test.sequential());
        return result;
    }

    private String[] join(String[] strings, String[] strings2) {
        HashMap<String, String> vResult = new HashMap<String, String>();
        for (String s : strings) {
            vResult.put(s, s);
        }
        for (String s : strings2) {
            vResult.put(s, s);
        }
        return vResult.keySet().toArray(new String[vResult.size()]);
    }

    private String[] findInheritedStringArray(Class cls, Class annotationClass, String methodName) {
        if (null == cls) {
            return new String[0];
        }
        HashMap<String, String> vResult = new HashMap<String, String>();
        while (cls != null && cls != Object.class) {
            Object annotation = cls.getAnnotation(annotationClass);
            if (annotation != null) {
                String[] g;
                for (String s : g = (String[])this.invokeMethod((Annotation)annotation, methodName)) {
                    vResult.put(s, s);
                }
            }
            cls = cls.getSuperclass();
        }
        String[] result = vResult.keySet().toArray(new String[vResult.size()]);
        return result;
    }

    private Object invokeMethod(Annotation test, String methodName) {
        Object result = null;
        try {
            Method m = test.getClass().getMethod(methodName, new Class[0]);
            result = m.invoke((Object)test, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void ppp(String string) {
        System.out.println("[JDK15TagFactory] " + string);
    }
}

