/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.DeadlineClock;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.LifecycleScope;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.RandomizedRunner$TestCandidate;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.RandomizedRunner$UncaughtException;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.Randomness;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.SysGlobals;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ThreadFilter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ThreadLeakControl$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ThreadLeakControl$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ThreadLeakControl$3;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ThreadLeakControl$4;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ThreadLeakControl$AwaitCond;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ThreadLeakControl$DefaultAnnotationValues;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ThreadLeakControl$KnownSystemThread;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ThreadLeakControl$StatementRunner;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ThreadLeakControl$SubNotifier;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ThreadLeakControl$ThisThreadFilter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ThreadLeakControl$TimeoutValue;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ThreadLeakError;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.Threads;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.UncaughtExceptionError;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.annotations.ThreadLeakAction;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.annotations.ThreadLeakAction$Action;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.annotations.ThreadLeakFilters;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.annotations.ThreadLeakGroup;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.annotations.ThreadLeakLingering;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope$Scope;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.annotations.ThreadLeakZombies;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.annotations.Timeout;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.annotations.TimeoutSuite;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.reflect.AnnotatedElement;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Logger;
import org.junit.AssumptionViolatedException;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.Statement;

class ThreadLeakControl {
    private static final Logger LOGGER = RandomizedRunner.logger;
    private final int killAttempts;
    private final int killWait;
    private final RunNotifier targetNotifier;
    private final Set expectedSuiteState;
    private final Object notifierLock = new Object();
    private final ThreadLeakControl$SubNotifier subNotifier;
    private ThreadLeakControl$TimeoutValue testTimeout;
    private ThreadLeakControl$TimeoutValue suiteTimeout;
    private final List builtinFilters;
    private ThreadFilter suiteFilters;
    private final RandomizedRunner runner;
    private AtomicBoolean suiteTimedOut = new AtomicBoolean();
    ThreadLeakGroup threadLeakGroup;

    private static ThreadFilter or(ThreadFilter ... threadFilterArray) {
        return new ThreadLeakControl$1(threadFilterArray);
    }

    ThreadLeakControl(RunNotifier runNotifier, RandomizedRunner randomizedRunner) {
        this.targetNotifier = runNotifier;
        this.subNotifier = new ThreadLeakControl$SubNotifier(this);
        this.runner = randomizedRunner;
        this.killAttempts = RandomizedTest.systemPropertyAsInt(SysGlobals.SYSPROP_KILLATTEMPTS(), 5);
        this.killWait = RandomizedTest.systemPropertyAsInt(SysGlobals.SYSPROP_KILLWAIT(), 500);
        this.testTimeout = new ThreadLeakControl$TimeoutValue(SysGlobals.SYSPROP_TIMEOUT(), 0);
        this.suiteTimeout = new ThreadLeakControl$TimeoutValue(SysGlobals.SYSPROP_TIMEOUT_SUITE(), 0);
        this.builtinFilters = Arrays.asList(new ThreadLeakControl$ThisThreadFilter(Thread.currentThread()), new ThreadLeakControl$KnownSystemThread(null));
        this.expectedSuiteState = Collections.unmodifiableSet(Threads.getAllThreads());
    }

    private static void checkZombies() {
        if (RandomizedRunner.hasZombieThreads()) {
            throw new AssumptionViolatedException("Leaked background threads present (zombies).");
        }
    }

    Statement forSuite(Statement statement, Description description) {
        Class clazz = RandomizedContext.current().getTargetClass();
        int n = this.determineTimeout(clazz);
        return new ThreadLeakControl$2(this, clazz, statement, n, description);
    }

    Statement forTest(Statement statement, RandomizedRunner$TestCandidate randomizedRunner$TestCandidate) {
        int n = this.determineTimeout(randomizedRunner$TestCandidate);
        return new ThreadLeakControl$3(this, statement, n, randomizedRunner$TestCandidate);
    }

    protected Set refilter(Set set, ThreadFilter threadFilter) {
        HashSet hashSet = new HashSet(set);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            if (!threadFilter.reject((Thread)iterator.next())) continue;
            iterator.remove();
        }
        return hashSet;
    }

    private ThreadFilter instantiateFilters(List list, Class clazz) {
        ThreadLeakFilters threadLeakFilters = (ThreadLeakFilters)ThreadLeakControl.firstAnnotated(ThreadLeakFilters.class, new AnnotatedElement[]{clazz, ThreadLeakControl$DefaultAnnotationValues.class});
        ArrayList arrayList = new ArrayList();
        for (Class clazz2 : threadLeakFilters.filters()) {
            try {
                arrayList.add(clazz2.newInstance());
            }
            catch (Throwable throwable) {
                list.add(throwable);
            }
        }
        if (threadLeakFilters.defaultFilters()) {
            arrayList.addAll(this.builtinFilters);
        }
        return ThreadLeakControl.or(arrayList.toArray(new ThreadFilter[arrayList.size()]));
    }

    private static Throwable emptyStack(Throwable throwable) {
        throwable.setStackTrace(new StackTraceElement[0]);
        return throwable;
    }

    protected void processUncaught(List list, List list2) {
        for (RandomizedRunner$UncaughtException randomizedRunner$UncaughtException : list2) {
            list.add(ThreadLeakControl.emptyStack(new UncaughtExceptionError("Captured an uncaught exception in thread: " + randomizedRunner$UncaughtException.threadName, randomizedRunner$UncaughtException.error)));
        }
    }

    protected void checkThreadLeaks(Set set, List list, LifecycleScope lifecycleScope, Description description, AnnotatedElement ... annotatedElementArray) {
        Object object;
        ThreadLeakScope threadLeakScope = (ThreadLeakScope)ThreadLeakControl.firstAnnotated(ThreadLeakScope.class, annotatedElementArray);
        if (threadLeakScope.value() == ThreadLeakScope$Scope.NONE) {
            return;
        }
        if (threadLeakScope.value() == ThreadLeakScope$Scope.SUITE && lifecycleScope == LifecycleScope.TEST) {
            return;
        }
        int n = ((ThreadLeakLingering)ThreadLeakControl.firstAnnotated(ThreadLeakLingering.class, annotatedElementArray)).linger();
        Serializable serializable = this.getThreads(this.suiteFilters);
        ((AbstractSet)((Object)serializable)).removeAll(set);
        if (n > 0 && !((HashSet)serializable).isEmpty()) {
            object = new DeadlineClock(TimeUnit.MILLISECONDS, n);
            try {
                LOGGER.warning("Will linger awaiting termination of " + ((HashSet)serializable).size() + " leaked thread(s).");
                do {
                    Thread.sleep(100L);
                    serializable = this.getThreads(this.suiteFilters);
                    ((AbstractSet)((Object)serializable)).removeAll(set);
                } while (!((HashSet)serializable).isEmpty() && !((DeadlineClock)object).isAfterDeadline());
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warning("Lingering interrupted.");
            }
        }
        if (((HashSet)serializable).isEmpty()) {
            return;
        }
        HashMap hashMap = this.getThreadsWithTraces(this.suiteFilters);
        hashMap.keySet().removeAll(set);
        if (hashMap.isEmpty()) {
            return;
        }
        serializable = new StringBuilder(hashMap.size() + " thread" + (hashMap.size() == 1 ? "" : "s") + " leaked from " + (Object)((Object)lifecycleScope) + " scope at " + description + ": ");
        ((StringBuilder)serializable).append(this.formatThreadStacks(hashMap));
        list.add(RandomizedRunner.augmentStackTrace(ThreadLeakControl.emptyStack(new ThreadLeakError(((StringBuilder)serializable).toString())), new Randomness[0]));
        object = EnumSet.noneOf(ThreadLeakAction$Action.class);
        ((AbstractCollection)object).addAll(Arrays.asList(((ThreadLeakAction)ThreadLeakControl.firstAnnotated(ThreadLeakAction.class, annotatedElementArray)).value()));
        if (((AbstractCollection)object).contains((Object)ThreadLeakAction$Action.WARN)) {
            LOGGER.severe(((StringBuilder)serializable).toString());
        }
        Set set2 = Collections.emptySet();
        if (((AbstractCollection)object).contains((Object)ThreadLeakAction$Action.INTERRUPT)) {
            set2 = this.tryToInterruptAll(list, hashMap.keySet());
        }
        if (!set2.isEmpty()) {
            switch (((ThreadLeakZombies)ThreadLeakControl.firstAnnotated(ThreadLeakZombies.class, annotatedElementArray)).value()) {
                case CONTINUE: {
                    break;
                }
                case IGNORE_REMAINING_TESTS: {
                    RandomizedRunner.zombieMarker.set(true);
                    break;
                }
                default: {
                    throw new RuntimeException("Missing case.");
                }
            }
        }
    }

    private String formatThreadStacks(Map map) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        Formatter formatter = new Formatter(stringBuilder, Locale.ROOT);
        for (Map.Entry entry : map.entrySet()) {
            formatter.format(Locale.ROOT, "\n  %2d) %s", n++, Threads.threadName((Thread)entry.getKey())).flush();
            if (((StackTraceElement[])entry.getValue()).length == 0) {
                stringBuilder.append("\n        at (empty stack)");
                continue;
            }
            for (StackTraceElement stackTraceElement : (StackTraceElement[])entry.getValue()) {
                stringBuilder.append("\n        at ").append(stackTraceElement);
            }
        }
        return stringBuilder.toString();
    }

    private String threadNames(Collection collection) {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder, Locale.ROOT);
        int n = 1;
        for (Thread thread : collection) {
            formatter.format(Locale.ROOT, "\n  %2d) %s", n++, Threads.threadName(thread));
        }
        return stringBuilder.toString();
    }

    private String formatThreadStacksFull() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n==== jstack at approximately timeout time ====\n");
            for (ThreadInfo threadInfo : ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                Threads.append(stringBuilder, threadInfo);
            }
            stringBuilder.append("^^==============================================\n");
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            return this.formatThreadStacks(this.getThreadsWithTraces(new ThreadFilter[0]));
        }
    }

    private static StackTraceElement[] getStackTrace(Thread thread) {
        return (StackTraceElement[])AccessController.doPrivileged(new ThreadLeakControl$4(thread));
    }

    private HashMap getThreadsWithTraces(ThreadFilter ... threadFilterArray) {
        HashSet hashSet = this.getThreads(threadFilterArray);
        HashMap<Thread, StackTraceElement[]> hashMap = new HashMap<Thread, StackTraceElement[]>();
        for (Thread thread : hashSet) {
            hashMap.put(thread, ThreadLeakControl.getStackTrace(thread));
        }
        return hashMap;
    }

    private HashSet getThreads(ThreadFilter ... threadFilterArray) {
        HashSet hashSet;
        switch (this.threadLeakGroup.value()) {
            case ALL: {
                hashSet = Threads.getAllThreads();
                break;
            }
            case MAIN: {
                hashSet = Threads.getThreads(RandomizedRunner.mainThreadGroup);
                break;
            }
            case TESTGROUP: {
                hashSet = Threads.getThreads(this.runner.runnerThreadGroup);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        ThreadFilter threadFilter = ThreadLeakControl.or(threadFilterArray);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            if (thread.isAlive() && !threadFilter.reject(thread)) continue;
            iterator.remove();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set tryToInterruptAll(List list, Set set) {
        LOGGER.info("Starting to interrupt leaked threads:" + this.threadNames(set));
        this.runner.handler.stopReporting();
        try {
            Object object;
            Object object22;
            boolean bl;
            HashSet hashSet = new HashSet(set);
            int n = this.killAttempts;
            int n2 = this.killWait;
            int n3 = Thread.currentThread().getPriority();
            do {
                bl = true;
                try {
                    Thread.currentThread().setPriority(10);
                    for (Object object22 : hashSet) {
                        ((Thread)object22).interrupt();
                    }
                    object = new DeadlineClock(TimeUnit.MILLISECONDS, n2);
                    object22 = hashSet.iterator();
                    while (object22.hasNext()) {
                        Thread thread = (Thread)object22.next();
                        if (thread.isAlive()) {
                            bl = false;
                            ThreadLeakControl.join(thread, Math.max(1L, ((DeadlineClock)object).timeUntilDeadline(TimeUnit.MILLISECONDS)), Thread::sleep);
                            continue;
                        }
                        object22.remove();
                    }
                }
                catch (InterruptedException interruptedException) {
                    n = 0;
                }
            } while (!bl && --n > 0);
            Thread.currentThread().setPriority(n3);
            object = new HashMap();
            for (Thread thread : hashSet) {
                if (!thread.isAlive()) continue;
                ((HashMap)object).put(thread, ThreadLeakControl.getStackTrace(thread));
            }
            if (((HashMap)object).isEmpty()) {
                LOGGER.info("All leaked threads terminated.");
            } else {
                object22 = "There are still zombie threads that couldn't be terminated:" + this.formatThreadStacks((Map)object);
                LOGGER.severe((String)object22);
                list.add(RandomizedRunner.augmentStackTrace(ThreadLeakControl.emptyStack(new ThreadLeakError(((String)object22).toString())), new Randomness[0]));
            }
            object22 = ((HashMap)object).keySet();
            return object22;
        }
        finally {
            this.runner.handler.resumeReporting();
        }
    }

    boolean forkTimeoutingTask(ThreadLeakControl$StatementRunner threadLeakControl$StatementRunner, int n, List list) {
        boolean bl;
        if (n == 0) {
            threadLeakControl$StatementRunner.run();
        } else {
            Thread thread = Thread.currentThread();
            AtomicBoolean atomicBoolean = new AtomicBoolean();
            Thread thread2 = new Thread(() -> {
                try {
                    threadLeakControl$StatementRunner.run();
                }
                finally {
                    atomicBoolean.set(true);
                    LockSupport.unpark(thread);
                }
            }, Thread.currentThread().getName() + "-worker");
            RandomizedContext.cloneFor(thread2);
            thread2.start();
            ThreadLeakControl.join(thread2, n, l -> {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(l));
                if (atomicBoolean.get()) {
                    thread2.join();
                }
            });
        }
        boolean bl2 = bl = !threadLeakControl$StatementRunner.completed;
        if (threadLeakControl$StatementRunner.error != null) {
            list.add(threadLeakControl$StatementRunner.error);
        }
        return bl;
    }

    static void join(Thread thread, long l, ThreadLeakControl$AwaitCond threadLeakControl$AwaitCond) {
        long l2;
        if (l <= 0L) {
            throw new IllegalArgumentException("Timeout must be positive: " + l);
        }
        DeadlineClock deadlineClock = new DeadlineClock(TimeUnit.MILLISECONDS, l);
        while (thread.isAlive() && (l2 = deadlineClock.timeUntilDeadline(TimeUnit.MILLISECONDS)) > 0L) {
            threadLeakControl$AwaitCond.await(Math.min(250L, l2));
        }
    }

    boolean isTimedOut() {
        return this.suiteTimedOut.get();
    }

    RunNotifier notifier() {
        return this.subNotifier;
    }

    private int determineTimeout(Class clazz) {
        TimeoutSuite timeoutSuite = clazz.getAnnotation(TimeoutSuite.class);
        return this.suiteTimeout.getTimeout(timeoutSuite == null ? null : Integer.valueOf(timeoutSuite.millis()));
    }

    private int determineTimeout(RandomizedRunner$TestCandidate randomizedRunner$TestCandidate) {
        Test test;
        Integer n = null;
        Timeout timeout = randomizedRunner$TestCandidate.getTestClass().getAnnotation(Timeout.class);
        if (timeout != null) {
            n = Math.min(Integer.MAX_VALUE, timeout.millis());
        }
        if ((test = randomizedRunner$TestCandidate.method.getAnnotation(Test.class)) != null && test.timeout() > 0L) {
            n = (int)Math.min(Integer.MAX_VALUE, test.timeout());
        }
        if ((timeout = randomizedRunner$TestCandidate.method.getAnnotation(Timeout.class)) != null) {
            n = timeout.millis();
        }
        return this.testTimeout.getTimeout(n);
    }

    private static Annotation firstAnnotated(Class clazz, AnnotatedElement ... annotatedElementArray) {
        for (AnnotatedElement annotatedElement : annotatedElementArray) {
            Object t = annotatedElement.getAnnotation(clazz);
            if (t == null) continue;
            return t;
        }
        throw new RuntimeException("default annotation value must be within elements.");
    }

    static /* synthetic */ Object access$000(ThreadLeakControl threadLeakControl) {
        return threadLeakControl.notifierLock;
    }

    static /* synthetic */ RunNotifier access$100(ThreadLeakControl threadLeakControl) {
        return threadLeakControl.targetNotifier;
    }

    static /* synthetic */ StackTraceElement[] access$200(Thread thread) {
        return ThreadLeakControl.getStackTrace(thread);
    }

    static /* synthetic */ void access$500() {
        ThreadLeakControl.checkZombies();
    }

    static /* synthetic */ Annotation access$600(Class clazz, AnnotatedElement[] annotatedElementArray) {
        return ThreadLeakControl.firstAnnotated(clazz, annotatedElementArray);
    }

    static /* synthetic */ ThreadFilter access$702(ThreadLeakControl threadLeakControl, ThreadFilter threadFilter) {
        threadLeakControl.suiteFilters = threadFilter;
        return threadLeakControl.suiteFilters;
    }

    static /* synthetic */ ThreadFilter access$800(ThreadLeakControl threadLeakControl, List list, Class clazz) {
        return threadLeakControl.instantiateFilters(list, clazz);
    }

    static /* synthetic */ AtomicBoolean access$900(ThreadLeakControl threadLeakControl) {
        return threadLeakControl.suiteTimedOut;
    }

    static /* synthetic */ String access$1000(ThreadLeakControl threadLeakControl) {
        return threadLeakControl.formatThreadStacksFull();
    }

    static /* synthetic */ Logger access$1100() {
        return LOGGER;
    }

    static /* synthetic */ ThreadLeakControl$SubNotifier access$1200(ThreadLeakControl threadLeakControl) {
        return threadLeakControl.subNotifier;
    }

    static /* synthetic */ Throwable access$1300(Throwable throwable) {
        return ThreadLeakControl.emptyStack(throwable);
    }

    static /* synthetic */ Set access$1400(ThreadLeakControl threadLeakControl) {
        return threadLeakControl.expectedSuiteState;
    }

    static /* synthetic */ ThreadFilter access$700(ThreadLeakControl threadLeakControl) {
        return threadLeakControl.suiteFilters;
    }

    static /* synthetic */ RandomizedRunner access$1500(ThreadLeakControl threadLeakControl) {
        return threadLeakControl.runner;
    }

    static /* synthetic */ HashSet access$1600(ThreadLeakControl threadLeakControl, ThreadFilter[] threadFilterArray) {
        return threadLeakControl.getThreads(threadFilterArray);
    }
}

