/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.scraper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.prometheus.client.Collector;
import io.prometheus.client.Counter;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.prometheus.collector.MetricSamples;
import org.apache.solr.prometheus.exporter.MetricsQuery;
import org.apache.solr.prometheus.exporter.SolrExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolrScraper
implements Closeable {
    private static final Counter scrapeErrorTotal = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("solr_exporter_scrape_error_total")).help("Number of scrape error.")).register(SolrExporter.defaultRegistry);
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final ExecutorService executor;

    public abstract Map<String, MetricSamples> metricsForAllHosts(MetricsQuery var1) throws IOException;

    public abstract Map<String, MetricSamples> pingAllCores(MetricsQuery var1) throws IOException;

    public abstract Map<String, MetricSamples> pingAllCollections(MetricsQuery var1) throws IOException;

    public abstract MetricSamples search(MetricsQuery var1) throws IOException;

    public abstract MetricSamples collections(MetricsQuery var1) throws IOException;

    public SolrScraper(ExecutorService executor) {
        this.executor = executor;
    }

    protected Map<String, MetricSamples> sendRequestsInParallel(Collection<String> items, Function<String, MetricSamples> samplesCallable) throws IOException {
        HashMap<String, MetricSamples> result = new HashMap<String, MetricSamples>();
        try {
            this.executor.invokeAll(items.stream().map(item -> () -> {
                try {
                    MetricSamples samples = (MetricSamples)samplesCallable.apply((String)item);
                    Map map = result;
                    synchronized (map) {
                        result.put((String)item, samples);
                    }
                }
                catch (Exception e) {
                    log.warn("Error occurred during metrics collection", (Throwable)e);
                }
                return null;
            }).collect(Collectors.toList()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return result;
    }

    protected MetricSamples request(SolrClient client, MetricsQuery query) throws IOException {
        MetricSamples samples = new MetricSamples();
        QueryRequest queryRequest = new QueryRequest((SolrParams)query.getParameters());
        queryRequest.setPath(query.getPath());
        NamedList queryResponse = null;
        try {
            if (!query.getCollection().isPresent() && !query.getCore().isPresent()) {
                queryResponse = client.request((SolrRequest)queryRequest);
            } else if (query.getCore().isPresent()) {
                queryResponse = client.request((SolrRequest)queryRequest, query.getCore().get());
            } else if (query.getCollection().isPresent()) {
                queryResponse = client.request((SolrRequest)queryRequest, query.getCollection().get());
            }
        }
        catch (IOException | SolrServerException e) {
            log.error("failed to request: {}", (Object)queryRequest.getPath(), (Object)e);
        }
        JsonNode jsonNode = OBJECT_MAPPER.readTree((String)queryResponse.get("response"));
        for (JsonQuery jsonQuery : query.getJsonQueries()) {
            try {
                List results = jsonQuery.apply(jsonNode);
                for (JsonNode result : results) {
                    String type = result.get("type").textValue();
                    String name = result.get("name").textValue();
                    String help = result.get("help").textValue();
                    double value = result.get("value").doubleValue();
                    ArrayList<String> labelNames = new ArrayList<String>();
                    ArrayList<String> labelValues = new ArrayList<String>();
                    for (JsonNode item : result.get("label_names")) {
                        labelNames.add(item.textValue());
                    }
                    for (JsonNode item : result.get("label_values")) {
                        labelValues.add(item.textValue());
                    }
                    if (client instanceof HttpSolrClient) {
                        labelNames.add("base_url");
                        labelValues.add(((HttpSolrClient)client).getBaseURL());
                    }
                    if (client instanceof CloudSolrClient) {
                        labelNames.add("zk_host");
                        labelValues.add(((CloudSolrClient)client).getZkHost());
                    }
                    if (labelNames.indexOf("core") < 0 && labelNames.indexOf("collection") >= 0 && labelNames.indexOf("shard") >= 0 && labelNames.indexOf("replica") >= 0) {
                        labelNames.add("core");
                        String collection = (String)labelValues.get(labelNames.indexOf("collection"));
                        String shard = (String)labelValues.get(labelNames.indexOf("shard"));
                        String replica = (String)labelValues.get(labelNames.indexOf("replica"));
                        labelValues.add(collection + "_" + shard + "_" + replica);
                    }
                    samples.addSamplesIfNotPresent(name, new Collector.MetricFamilySamples(name, Collector.Type.valueOf((String)type), help, new ArrayList()));
                    samples.addSampleIfMetricExists(name, new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, value));
                }
            }
            catch (JsonQueryException e) {
                log.error("Error apply JSON query={} to result", (Object)jsonQuery, (Object)e);
                scrapeErrorTotal.inc();
            }
        }
        return samples;
    }
}

