/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.monitor.CandidateMatcher;
import org.apache.lucene.monitor.MatcherFactory;
import org.apache.lucene.monitor.QueryMatch;
import org.apache.lucene.search.Query;

public interface QueryTimeListener {
    public void logQueryTime(String var1, long var2);

    public static <T extends QueryMatch> MatcherFactory<T> timingMatcher(MatcherFactory<T> factory, final QueryTimeListener listener) {
        return searcher -> {
            final CandidateMatcher matcher = factory.createMatcher(searcher);
            return new CandidateMatcher<T>(searcher){

                @Override
                protected void matchQuery(String queryId, Query matchQuery, Map<String, String> metadata) throws IOException {
                    long t = System.nanoTime();
                    matcher.matchQuery(queryId, matchQuery, metadata);
                    t = System.nanoTime() - t;
                    listener.logQueryTime(queryId, t);
                }

                @Override
                public T resolve(T match1, T match2) {
                    return matcher.resolve(match1, match2);
                }

                @Override
                protected void doFinish() {
                    this.copyMatches(matcher);
                }
            };
        };
    }
}

