/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.documents;

import java.io.IOException;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.util.BytesRef;

public final class TermPosting {
    private int position = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private BytesRef payload;

    static TermPosting of(int position, PostingsEnum penum) throws IOException {
        TermPosting posting = new TermPosting();
        posting.position = position;
        int sOffset = penum.startOffset();
        int eOffset = penum.endOffset();
        if (sOffset >= 0 && eOffset >= 0) {
            posting.startOffset = sOffset;
            posting.endOffset = eOffset;
        }
        if (penum.getPayload() != null) {
            posting.payload = BytesRef.deepCopyOf((BytesRef)penum.getPayload());
        }
        return posting;
    }

    public int getPosition() {
        return this.position;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public BytesRef getPayload() {
        return this.payload;
    }

    public String toString() {
        return "TermPosting{position=" + this.position + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", payload=" + String.valueOf(this.payload) + "}";
    }

    private TermPosting() {
    }
}

