/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.luke.app.DirectoryHandler;
import org.apache.lucene.luke.app.DirectoryObserver;
import org.apache.lucene.luke.app.IndexHandler;
import org.apache.lucene.luke.app.IndexObserver;
import org.apache.lucene.luke.app.LukeState;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.components.TableModelBase;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.TableUtils;
import org.apache.lucene.luke.models.commits.Commit;
import org.apache.lucene.luke.models.commits.Commits;
import org.apache.lucene.luke.models.commits.CommitsFactory;
import org.apache.lucene.luke.models.commits.File;
import org.apache.lucene.luke.models.commits.Segment;

public final class CommitsPanelProvider {
    private final CommitsFactory commitsFactory = new CommitsFactory();
    private final JComboBox<Long> commitGenCombo = new JComboBox();
    private final JLabel deletedLbl = new JLabel();
    private final JLabel segCntLbl = new JLabel();
    private final JTextArea userDataTA = new JTextArea();
    private final JTable filesTable = new JTable();
    private final JTable segmentsTable = new JTable();
    private final JRadioButton diagRB = new JRadioButton();
    private final JRadioButton attrRB = new JRadioButton();
    private final JRadioButton codecRB = new JRadioButton();
    private final ButtonGroup rbGroup = new ButtonGroup();
    private final JList<String> segDetailList = new JList();
    private ListenerFunctions listeners = new ListenerFunctions();
    private Commits commitsModel;

    public CommitsPanelProvider() {
        IndexHandler.getInstance().addObserver(new Observer());
        DirectoryHandler.getInstance().addObserver(new Observer());
    }

    public JPanel get() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createLineBorder(Color.gray));
        JSplitPane splitPane = new JSplitPane(0, this.initUpperPanel(), this.initLowerPanel());
        splitPane.setOpaque(false);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        splitPane.setDividerLocation(120);
        panel.add(splitPane);
        return panel;
    }

    private JPanel initUpperPanel() {
        JPanel panel = new JPanel(new BorderLayout(20, 0));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel left = new JPanel(new FlowLayout(3));
        left.setOpaque(false);
        left.add(new JLabel(MessageUtils.getLocalizedMessage("commits.label.select_gen")));
        this.commitGenCombo.addActionListener(this.listeners::selectGeneration);
        left.add(this.commitGenCombo);
        panel.add((Component)left, "Before");
        JPanel right = new JPanel(new GridBagLayout());
        right.setOpaque(false);
        GridBagConstraints c1 = new GridBagConstraints();
        c1.ipadx = 5;
        c1.ipady = 5;
        c1.gridx = 0;
        c1.gridy = 0;
        c1.weightx = 0.2;
        c1.anchor = 13;
        right.add((Component)new JLabel(MessageUtils.getLocalizedMessage("commits.label.deleted")), c1);
        c1.gridx = 1;
        c1.gridy = 0;
        c1.weightx = 0.5;
        c1.anchor = 17;
        right.add((Component)this.deletedLbl, c1);
        c1.gridx = 0;
        c1.gridy = 1;
        c1.weightx = 0.2;
        c1.anchor = 13;
        right.add((Component)new JLabel(MessageUtils.getLocalizedMessage("commits.label.segcount")), c1);
        c1.gridx = 1;
        c1.gridy = 1;
        c1.weightx = 0.5;
        c1.anchor = 17;
        right.add((Component)this.segCntLbl, c1);
        c1.gridx = 0;
        c1.gridy = 2;
        c1.weightx = 0.2;
        c1.anchor = 13;
        right.add((Component)new JLabel(MessageUtils.getLocalizedMessage("commits.label.userdata")), c1);
        this.userDataTA.setRows(3);
        this.userDataTA.setColumns(30);
        this.userDataTA.setLineWrap(true);
        this.userDataTA.setWrapStyleWord(true);
        this.userDataTA.setEditable(false);
        JScrollPane userDataScroll = new JScrollPane(this.userDataTA, 20, 31);
        c1.gridx = 1;
        c1.gridy = 2;
        c1.weightx = 0.5;
        c1.anchor = 17;
        right.add((Component)userDataScroll, c1);
        panel.add((Component)right, "Center");
        return panel;
    }

    private JPanel initLowerPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JSplitPane splitPane = new JSplitPane(1, this.initFilesPanel(), this.initSegmentsPanel());
        splitPane.setOpaque(false);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        splitPane.setDividerLocation(300);
        panel.add(splitPane);
        return panel;
    }

    private JPanel initFilesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel header = new JPanel(new FlowLayout(3));
        header.setOpaque(false);
        header.add(new JLabel(MessageUtils.getLocalizedMessage("commits.label.files")));
        panel.add((Component)header, "First");
        TableUtils.setupTable(this.filesTable, 0, new FilesTableModel(), null, FilesTableModel.Column.FILENAME.getColumnWidth());
        panel.add((Component)new JScrollPane(this.filesTable), "Center");
        return panel;
    }

    private JPanel initSegmentsPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel segments = new JPanel(new FlowLayout(3));
        segments.setOpaque(false);
        segments.add(new JLabel(MessageUtils.getLocalizedMessage("commits.label.segments")));
        panel.add(segments);
        TableUtils.setupTable(this.segmentsTable, 0, new SegmentsTableModel(), new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CommitsPanelProvider.this.listeners.showSegmentDetails(e);
            }
        }, SegmentsTableModel.Column.NAME.getColumnWidth(), SegmentsTableModel.Column.MAXDOCS.getColumnWidth(), SegmentsTableModel.Column.DELS.getColumnWidth(), SegmentsTableModel.Column.DELGEN.getColumnWidth(), SegmentsTableModel.Column.VERSION.getColumnWidth(), SegmentsTableModel.Column.CODEC.getColumnWidth());
        panel.add(new JScrollPane(this.segmentsTable));
        JPanel segDetails = new JPanel(new FlowLayout(3));
        segDetails.setOpaque(false);
        segDetails.add(new JLabel(MessageUtils.getLocalizedMessage("commits.label.segdetails")));
        panel.add(segDetails);
        JPanel buttons = new JPanel(new FlowLayout(3));
        buttons.setOpaque(false);
        this.diagRB.setText("Diagnostics");
        this.diagRB.setActionCommand(ActionCommand.DIAGNOSTICS.name());
        this.diagRB.setSelected(true);
        this.diagRB.setEnabled(false);
        this.diagRB.setOpaque(false);
        this.diagRB.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CommitsPanelProvider.this.listeners.showSegmentDetails(e);
            }
        });
        buttons.add(this.diagRB);
        this.attrRB.setText("Attributes");
        this.attrRB.setActionCommand(ActionCommand.ATTRIBUTES.name());
        this.attrRB.setSelected(false);
        this.attrRB.setEnabled(false);
        this.attrRB.setOpaque(false);
        this.attrRB.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CommitsPanelProvider.this.listeners.showSegmentDetails(e);
            }
        });
        buttons.add(this.attrRB);
        this.codecRB.setText("Codec");
        this.codecRB.setActionCommand(ActionCommand.CODEC.name());
        this.codecRB.setSelected(false);
        this.codecRB.setEnabled(false);
        this.codecRB.setOpaque(false);
        this.codecRB.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CommitsPanelProvider.this.listeners.showSegmentDetails(e);
            }
        });
        buttons.add(this.codecRB);
        this.rbGroup.add(this.diagRB);
        this.rbGroup.add(this.attrRB);
        this.rbGroup.add(this.codecRB);
        panel.add(buttons);
        this.segDetailList.setVisibleRowCount(10);
        panel.add(new JScrollPane(this.segDetailList));
        return panel;
    }

    private void selectGeneration() {
        this.diagRB.setEnabled(false);
        this.attrRB.setEnabled(false);
        this.codecRB.setEnabled(false);
        this.segDetailList.setModel(new DefaultListModel());
        long commitGen = (Long)this.commitGenCombo.getSelectedItem();
        this.commitsModel.getCommit(commitGen).ifPresent(commit -> {
            this.deletedLbl.setText(String.valueOf(commit.isDeleted()));
            this.segCntLbl.setText(String.valueOf(commit.getSegCount()));
            this.userDataTA.setText(commit.getUserData());
        });
        this.filesTable.setModel(new FilesTableModel(this.commitsModel.getFiles(commitGen)));
        this.filesTable.setShowGrid(true);
        this.filesTable.getColumnModel().getColumn(FilesTableModel.Column.FILENAME.getIndex()).setPreferredWidth(FilesTableModel.Column.FILENAME.getColumnWidth());
        this.segmentsTable.setModel(new SegmentsTableModel(this.commitsModel.getSegments(commitGen)));
        this.segmentsTable.setShowGrid(true);
        this.segmentsTable.getColumnModel().getColumn(SegmentsTableModel.Column.NAME.getIndex()).setPreferredWidth(SegmentsTableModel.Column.NAME.getColumnWidth());
        this.segmentsTable.getColumnModel().getColumn(SegmentsTableModel.Column.MAXDOCS.getIndex()).setPreferredWidth(SegmentsTableModel.Column.MAXDOCS.getColumnWidth());
        this.segmentsTable.getColumnModel().getColumn(SegmentsTableModel.Column.DELS.getIndex()).setPreferredWidth(SegmentsTableModel.Column.DELS.getColumnWidth());
        this.segmentsTable.getColumnModel().getColumn(SegmentsTableModel.Column.DELGEN.getIndex()).setPreferredWidth(SegmentsTableModel.Column.DELGEN.getColumnWidth());
        this.segmentsTable.getColumnModel().getColumn(SegmentsTableModel.Column.VERSION.getIndex()).setPreferredWidth(SegmentsTableModel.Column.VERSION.getColumnWidth());
        this.segmentsTable.getColumnModel().getColumn(SegmentsTableModel.Column.CODEC.getIndex()).setPreferredWidth(SegmentsTableModel.Column.CODEC.getColumnWidth());
    }

    private void showSegmentDetails() {
        int selectedRow = this.segmentsTable.getSelectedRow();
        if (this.commitGenCombo.getSelectedItem() == null || selectedRow < 0 || selectedRow >= this.segmentsTable.getRowCount()) {
            return;
        }
        this.diagRB.setEnabled(true);
        this.attrRB.setEnabled(true);
        this.codecRB.setEnabled(true);
        long commitGen = (Long)this.commitGenCombo.getSelectedItem();
        String segName = (String)this.segmentsTable.getValueAt(selectedRow, SegmentsTableModel.Column.NAME.getIndex());
        ActionCommand command = ActionCommand.valueOf(this.rbGroup.getSelection().getActionCommand());
        DefaultListModel detailsModel = new DefaultListModel();
        switch (command.ordinal()) {
            case 0: {
                this.commitsModel.getSegmentDiagnostics(commitGen, segName).entrySet().stream().map(entry -> (String)entry.getKey() + " = " + (String)entry.getValue()).forEach(detailsModel::addElement);
                break;
            }
            case 1: {
                this.commitsModel.getSegmentAttributes(commitGen, segName).entrySet().stream().map(entry -> (String)entry.getKey() + " = " + (String)entry.getValue()).forEach(detailsModel::addElement);
                break;
            }
            case 2: {
                this.commitsModel.getSegmentCodec(commitGen, segName).ifPresent(codec -> {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("Codec name", codec.getName());
                    map.put("Codec class name", codec.getClass().getName());
                    map.put("Compound format", codec.compoundFormat().getClass().getName());
                    map.put("DocValues format", codec.docValuesFormat().getClass().getName());
                    map.put("FieldInfos format", codec.fieldInfosFormat().getClass().getName());
                    map.put("LiveDocs format", codec.liveDocsFormat().getClass().getName());
                    map.put("Norms format", codec.normsFormat().getClass().getName());
                    map.put("Points format", codec.pointsFormat().getClass().getName());
                    map.put("Postings format", codec.postingsFormat().getClass().getName());
                    map.put("SegmentInfo format", codec.segmentInfoFormat().getClass().getName());
                    map.put("StoredFields format", codec.storedFieldsFormat().getClass().getName());
                    map.put("TermVectors format", codec.termVectorsFormat().getClass().getName());
                    map.entrySet().stream().map(entry -> (String)entry.getKey() + " = " + (String)entry.getValue()).forEach(detailsModel::addElement);
                });
            }
        }
        this.segDetailList.setModel(detailsModel);
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void selectGeneration(ActionEvent e) {
            CommitsPanelProvider.this.selectGeneration();
        }

        void showSegmentDetails(MouseEvent e) {
            CommitsPanelProvider.this.showSegmentDetails();
        }
    }

    private class Observer
    implements IndexObserver,
    DirectoryObserver {
        private Observer() {
        }

        @Override
        public void openDirectory(LukeState state) {
            CommitsPanelProvider.this.commitsModel = CommitsPanelProvider.this.commitsFactory.newInstance(state.getDirectory(), state.getIndexPath());
            this.populateCommitGenerations();
        }

        @Override
        public void closeDirectory() {
            this.close();
        }

        @Override
        public void openIndex(LukeState state) {
            if (state.hasDirectoryReader()) {
                DirectoryReader dr = (DirectoryReader)state.getIndexReader();
                CommitsPanelProvider.this.commitsModel = CommitsPanelProvider.this.commitsFactory.newInstance(dr, state.getIndexPath());
                this.populateCommitGenerations();
            }
        }

        @Override
        public void closeIndex() {
            this.close();
        }

        private void populateCommitGenerations() {
            DefaultComboBoxModel<Long> segGenList = new DefaultComboBoxModel<Long>();
            for (Commit commit : CommitsPanelProvider.this.commitsModel.listCommits()) {
                segGenList.addElement(commit.getGeneration());
            }
            CommitsPanelProvider.this.commitGenCombo.setModel(segGenList);
            if (segGenList.getSize() > 0) {
                CommitsPanelProvider.this.commitGenCombo.setSelectedIndex(0);
            }
        }

        private void close() {
            CommitsPanelProvider.this.commitsModel = null;
            CommitsPanelProvider.this.commitGenCombo.setModel(new DefaultComboBoxModel());
            CommitsPanelProvider.this.deletedLbl.setText("");
            CommitsPanelProvider.this.segCntLbl.setText("");
            CommitsPanelProvider.this.userDataTA.setText("");
            TableUtils.setupTable(CommitsPanelProvider.this.filesTable, 0, new FilesTableModel(), null, FilesTableModel.Column.FILENAME.getColumnWidth());
            TableUtils.setupTable(CommitsPanelProvider.this.segmentsTable, 0, new SegmentsTableModel(), null, SegmentsTableModel.Column.NAME.getColumnWidth(), SegmentsTableModel.Column.MAXDOCS.getColumnWidth(), SegmentsTableModel.Column.DELS.getColumnWidth(), SegmentsTableModel.Column.DELGEN.getColumnWidth(), SegmentsTableModel.Column.VERSION.getColumnWidth(), SegmentsTableModel.Column.CODEC.getColumnWidth());
            CommitsPanelProvider.this.diagRB.setEnabled(false);
            CommitsPanelProvider.this.attrRB.setEnabled(false);
            CommitsPanelProvider.this.codecRB.setEnabled(false);
            CommitsPanelProvider.this.segDetailList.setModel(new DefaultListModel());
        }
    }

    static final class FilesTableModel
    extends TableModelBase<Column> {
        FilesTableModel() {
        }

        FilesTableModel(List<File> files) {
            super(files.size());
            for (int i = 0; i < files.size(); ++i) {
                File file = files.get(i);
                this.data[i][Column.FILENAME.getIndex()] = file.getFileName();
                this.data[i][Column.SIZE.getIndex()] = file.getDisplaySize();
            }
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            FILENAME("Filename", 0, String.class, 200),
            SIZE("Size", 1, String.class, Integer.MAX_VALUE);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }

    static final class SegmentsTableModel
    extends TableModelBase<Column> {
        SegmentsTableModel() {
        }

        SegmentsTableModel(List<Segment> segments) {
            super(segments.size());
            for (int i = 0; i < segments.size(); ++i) {
                Segment segment = segments.get(i);
                this.data[i][Column.NAME.getIndex()] = segment.getName();
                this.data[i][Column.MAXDOCS.getIndex()] = segment.getMaxDoc();
                this.data[i][Column.DELS.getIndex()] = segment.getDelCount();
                this.data[i][Column.DELGEN.getIndex()] = segment.getDelGen();
                this.data[i][Column.VERSION.getIndex()] = segment.getLuceneVer();
                this.data[i][Column.CODEC.getIndex()] = segment.getCodecName();
                this.data[i][Column.SIZE.getIndex()] = segment.getDisplaySize();
            }
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            NAME("Name", 0, String.class, 60),
            MAXDOCS("Max docs", 1, Integer.class, 60),
            DELS("Dels", 2, Integer.class, 60),
            DELGEN("Del gen", 3, Long.class, 60),
            VERSION("Lucene ver.", 4, String.class, 60),
            CODEC("Codec", 5, String.class, 100),
            SIZE("Size", 6, String.class, 150);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }

    static enum ActionCommand {
        DIAGNOSTICS,
        ATTRIBUTES,
        CODEC;

    }
}

