/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.luke.app.AbstractHandler;
import org.apache.lucene.luke.app.DirectoryObserver;
import org.apache.lucene.luke.app.LukeState;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.models.util.IndexUtils;
import org.apache.lucene.store.Directory;

public final class DirectoryHandler
extends AbstractHandler<DirectoryObserver> {
    private static final DirectoryHandler instance = new DirectoryHandler();
    private LukeStateImpl state;

    public static DirectoryHandler getInstance() {
        return instance;
    }

    @Override
    protected void notifyOne(DirectoryObserver observer) {
        if (this.state.closed) {
            observer.closeDirectory();
        } else {
            observer.openDirectory(this.state);
        }
    }

    public boolean directoryOpened() {
        return this.state != null && !this.state.closed;
    }

    public void open(String indexPath, String dirImpl) {
        Directory dir;
        Objects.requireNonNull(indexPath);
        if (this.directoryOpened()) {
            this.close();
        }
        try {
            dir = IndexUtils.openDirectory(indexPath, dirImpl);
        }
        catch (IOException e) {
            throw new LukeException(MessageUtils.getLocalizedMessage("openindex.message.index_path_invalid", indexPath), e);
        }
        this.state = new LukeStateImpl();
        this.state.indexPath = indexPath;
        this.state.dirImpl = dirImpl;
        this.state.dir = dir;
        this.notifyObservers();
    }

    public void close() {
        if (this.state == null) {
            return;
        }
        IndexUtils.close(this.state.dir);
        this.state.closed = true;
        this.notifyObservers();
    }

    public LukeState getState() {
        return this.state;
    }

    private static class LukeStateImpl
    implements LukeState {
        private boolean closed = false;
        private String indexPath;
        private String dirImpl;
        private Directory dir;

        private LukeStateImpl() {
        }

        @Override
        public String getIndexPath() {
            return this.indexPath;
        }

        @Override
        public String getDirImpl() {
            return this.dirImpl;
        }

        @Override
        public Directory getDirectory() {
            return this.dir;
        }
    }
}

