/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import org.apache.lucene.search.FilterScorable;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.tests.search.AssertingScorer;

public class AssertingScorable
extends FilterScorable {
    public AssertingScorable(Scorable in) {
        super(in);
    }

    public float score() throws IOException {
        float score = this.in.score();
        assert (score >= 0.0f) : "score=" + score + " for in=" + String.valueOf(this.in);
        return score;
    }

    public void setMinCompetitiveScore(float minScore) throws IOException {
        this.in.setMinCompetitiveScore(minScore);
    }

    public static Scorable wrap(Scorable in) {
        if (in instanceof AssertingScorable) {
            return in;
        }
        if (in instanceof Scorer) {
            return new WrappedScorer((Scorer)in);
        }
        return new AssertingScorable(in);
    }

    public static Scorable unwrap(Scorable in) {
        while (true) {
            if (in instanceof AssertingScorable) {
                in = ((AssertingScorable)in).in;
                continue;
            }
            if (in instanceof AssertingScorer) {
                in = ((AssertingScorer)in).in;
                continue;
            }
            if (!(in instanceof WrappedScorer)) break;
            in = ((WrappedScorer)in).unwrap();
        }
        return in;
    }

    private static class WrappedScorer
    extends FilterScorer {
        WrappedScorer(Scorer in) {
            super(in);
        }

        public float score() throws IOException {
            return new AssertingScorable((Scorable)this.in).score();
        }

        public void setMinCompetitiveScore(float minScore) throws IOException {
            this.in.setMinCompetitiveScore(minScore);
        }

        public float getMaxScore(int upTo) throws IOException {
            return this.in.getMaxScore(upTo);
        }
    }
}

