/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.doc.internal;

import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ReviewTag
implements Taglet {
    private static final String NAME = "review";
    static final Set<String> TO_REVIEW = Collections.synchronizedSet(new LinkedHashSet());

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (TO_REVIEW.size() > 0) {
                    System.out.println("[INFO] No files needing review");
                } else {
                    System.out.println("[WARNING] " + TO_REVIEW.size() + " files needing review");
                }
                for (String s : TO_REVIEW) {
                    System.out.println("[NEEDS-REVIEW] " + s);
                }
            }
        });
    }

    public String getName() {
        return NAME;
    }

    public boolean inField() {
        return true;
    }

    public boolean inConstructor() {
        return true;
    }

    public boolean inMethod() {
        return true;
    }

    public boolean inOverview() {
        return true;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inType() {
        return true;
    }

    public boolean isInlineTag() {
        return true;
    }

    public static void register(Map tagletMap) {
        ReviewTag tag = new ReviewTag();
        tagletMap.put(tag.getName(), tag);
    }

    public String toString(Tag tag) {
        String label = tag.text();
        if (label == null || label.isEmpty()) {
            label = "Needs Review";
        }
        String file = tag.position().file().getAbsolutePath().replaceFirst("\\/juneau\\/.*\\/java\\/", "/juneau/target/site/apidocs/").replace(".java", ".html");
        TO_REVIEW.add(file);
        return "<review>" + label + "</review>";
    }

    public String toString(Tag[] tags) {
        return null;
    }
}

