/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.jsonschema;

import java.io.Reader;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.bean.jsonschema.JsonSchema;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.json.JsonParser;

public abstract class JsonSchemaMap
extends ConcurrentHashMap<URI, JsonSchema> {
    private static final long serialVersionUID = 1L;

    public JsonSchemaMap add(JsonSchema ... schemas) {
        for (JsonSchema schema : schemas) {
            if (schema.getId() == null) {
                throw ThrowableUtils.illegalArg("Schema with no ID passed to JsonSchemaMap.add(Schema...)", new Object[0]);
            }
            this.put(schema.getId(), schema);
            schema.setSchemaMap(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonSchema get(Object uri) {
        URI u = StringUtils.toUri(uri);
        JsonSchema s = (JsonSchema)super.get(u);
        if (Utils.nn(s)) {
            return s;
        }
        JsonSchemaMap jsonSchemaMap = this;
        synchronized (jsonSchemaMap) {
            s = this.load(u);
            if (Utils.nn(s)) {
                s.setSchemaMap(this);
                this.put(u, s);
            }
            return s;
        }
    }

    public Reader getReader(URI uri) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonSchema load(URI uri) {
        try (Reader r = this.getReader(uri);){
            if (r == null) {
                JsonSchema jsonSchema2 = null;
                return jsonSchema2;
            }
            JsonSchema jsonSchema = JsonParser.DEFAULT.parse((Object)r, JsonSchema.class);
            return jsonSchema;
        }
        catch (Exception e) {
            throw ThrowableUtils.toRex(e);
        }
    }
}

