/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.staticfile;

import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.activation.MimetypesFileTypeMap;
import org.apache.http.Header;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.http.resource.HttpResource;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.rest.staticfile.BasicStaticFiles;
import org.apache.juneau.utils.ExtendedMimetypesFileTypeMap;

public interface StaticFiles
extends FileFinder {
    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public Optional<HttpResource> resolve(String var1, Locale var2);

    @FluentSetters
    public static class Builder
    extends BeanBuilder<StaticFiles> {
        List<Header> headers = CollectionUtils.list(new Header[0]);
        MimetypesFileTypeMap mimeTypes;
        FileFinder.Builder fileFinder;

        protected Builder(BeanStore beanStore) {
            super(BasicStaticFiles.class, beanStore);
            this.fileFinder = FileFinder.create(beanStore);
            this.mimeTypes = new ExtendedMimetypesFileTypeMap();
        }

        @Override
        protected StaticFiles buildDefault() {
            return new BasicStaticFiles(this);
        }

        @FluentSetter
        public Builder headers(Header ... headers) {
            CollectionUtils.addAll(this.headers, headers);
            return this;
        }

        @FluentSetter
        public Builder addMimeTypes(String mimeTypes) {
            this.mimeTypes.addMimeTypes(mimeTypes);
            return this;
        }

        @FluentSetter
        public Builder mimeTypes(MimetypesFileTypeMap mimeTypes) {
            this.mimeTypes = mimeTypes;
            return this;
        }

        @FluentSetter
        public Builder caching(long cachingLimit) {
            this.fileFinder.caching(cachingLimit);
            return this;
        }

        @FluentSetter
        public Builder cp(Class<?> c, String path, boolean recursive) {
            this.fileFinder.cp(c, path, recursive);
            return this;
        }

        @FluentSetter
        public Builder dir(String path) {
            this.fileFinder.dir(path);
            return this;
        }

        @FluentSetter
        public Builder exclude(String ... patterns) {
            this.fileFinder.exclude(patterns);
            return this;
        }

        @FluentSetter
        public Builder include(String ... patterns) {
            this.fileFinder.include(patterns);
            return this;
        }

        @FluentSetter
        public Builder path(Path path) {
            this.fileFinder.path(path);
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }
    }

    public static abstract class Void
    implements StaticFiles {
    }
}

