/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.http.part.BasicPart;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;

public class BasicLongPart
extends BasicPart {
    private final Long value;
    private final Supplier<Long> supplier;

    public static BasicLongPart of(String name, Long value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicLongPart(name, value);
    }

    public static BasicLongPart of(String name, Supplier<Long> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicLongPart(name, value);
    }

    public BasicLongPart(String name, Long value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicLongPart(String name, Supplier<Long> value) {
        super(name, value);
        this.value = null;
        this.supplier = value;
    }

    public BasicLongPart(String name, String value) {
        super(name, value);
        this.value = StringUtils.isEmpty(value) ? null : Long.valueOf(value);
        this.supplier = null;
    }

    @Override
    public String getValue() {
        return StringUtils.stringify(this.value());
    }

    public Optional<Long> asLong() {
        return CollectionUtils.optional(this.value());
    }

    public Long toLong() {
        return this.value();
    }

    public FluentLongAssertion<BasicLongPart> assertLong() {
        return new FluentLongAssertion<BasicLongPart>(this.value(), this);
    }

    public Long orElse(Long other) {
        Long x = this.value();
        return x != null ? x : other;
    }

    private Long value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

