/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import javax.servlet.http.Part;
import org.apache.http.NameValuePair;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.httppart.RequestHttpPart;

public class RequestFormParam
extends RequestHttpPart
implements NameValuePair {
    private final Part part;
    private String value;

    public RequestFormParam(RestRequest request, Part part) {
        super(HttpPartType.FORMDATA, request, part.getName());
        this.part = part;
    }

    public RequestFormParam(RestRequest request, String name, String value) {
        super(HttpPartType.FORMDATA, request, name);
        this.value = value;
        this.part = null;
    }

    @Override
    public String getValue() {
        if (this.value == null && this.part != null) {
            try {
                this.value = IOUtils.read((InputStream)this.part.getInputStream());
            }
            catch (IOException e) {
                throw ThrowableUtils.runtimeException((Throwable)e);
            }
        }
        return this.value;
    }

    public FluentStringAssertion<RequestFormParam> assertString() {
        return new FluentStringAssertion(this.orElse(null), (Object)this);
    }

    public FluentIntegerAssertion<RequestFormParam> assertInteger() {
        return new FluentIntegerAssertion((Integer)this.asIntegerPart().asInteger().orElse(null), (Object)this);
    }

    public FluentLongAssertion<RequestFormParam> assertLong() {
        return new FluentLongAssertion((Long)this.asLongPart().asLong().orElse(null), (Object)this);
    }

    public FluentZonedDateTimeAssertion<RequestFormParam> assertDate() {
        return new FluentZonedDateTimeAssertion((ZonedDateTime)this.asDatePart().asZonedDateTime().orElse(null), (Object)this);
    }

    public FluentListAssertion<String, RequestFormParam> assertCsvArray() {
        return new FluentListAssertion(this.asCsvArrayPart().toList(), (Object)this);
    }

    @Override
    public RequestFormParam schema(HttpPartSchema value) {
        super.schema(value);
        return this;
    }

    @Override
    public RequestFormParam parser(HttpPartParserSession value) {
        super.parser(value);
        return this;
    }
}

