/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.Value;
import org.apache.juneau.ValueListener;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.arg.ArgException;
import org.apache.juneau.rest.arg.RestOpArg;

public class ResponseBeanArg
implements RestOpArg {
    final ResponseBeanMeta meta;
    private final Type type;

    public static ResponseBeanArg create(ParamInfo paramInfo, AnnotationWorkList annotations) {
        if (paramInfo.hasAnnotation(Response.class) || paramInfo.getParameterType().hasAnnotation(Response.class)) {
            return new ResponseBeanArg(paramInfo, annotations);
        }
        return null;
    }

    protected ResponseBeanArg(ParamInfo paramInfo, AnnotationWorkList annotations) {
        Class c;
        this.type = paramInfo.getParameterType().innerType();
        this.meta = ResponseBeanMeta.create(paramInfo, annotations);
        Class clazz = this.type instanceof Class ? (Class)this.type : (c = this.type instanceof ParameterizedType ? (Class)((ParameterizedType)this.type).getRawType() : null);
        if (c != Value.class) {
            throw new ArgException(paramInfo, "Type must be Value<?> on parameter annotated with @Response annotation", new Object[0]);
        }
    }

    @Override
    public Object resolve(final RestOpSession opSession) throws Exception {
        Value v = new Value();
        v.listener(new ValueListener(){

            public void onSet(Object o) {
                RestRequest req = opSession.getRequest();
                RestResponse res = opSession.getResponse();
                ResponseBeanMeta meta = req.getOpContext().getResponseBeanMeta(o);
                if (meta == null) {
                    meta = ResponseBeanArg.this.meta;
                }
                res.setResponseBeanMeta(meta);
                res.setContent(o);
            }
        });
        return v;
    }
}

