/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.parser.ParseException;

public final class SetBuilder<E> {
    private Set<E> set;
    private boolean unmodifiable;
    private boolean sparse;
    private Comparator<E> comparator;
    private Class<E> elementType;
    private Type[] elementTypeArgs;

    public SetBuilder(Class<E> elementType, Type ... elementTypeArgs) {
        this.elementType = elementType;
        this.elementTypeArgs = elementTypeArgs;
    }

    public SetBuilder(Set<E> addTo) {
        this.set = addTo;
    }

    public Set<E> build() {
        if (this.sparse) {
            if (this.set != null && this.set.isEmpty()) {
                this.set = null;
            }
        } else if (this.set == null) {
            this.set = new LinkedHashSet(0);
        }
        if (this.set != null) {
            if (this.comparator != null) {
                TreeSet<E> s = new TreeSet<E>(this.comparator);
                s.addAll(this.set);
                this.set = s;
            }
            if (this.unmodifiable) {
                this.set = Collections.unmodifiableSet(this.set);
            }
        }
        return this.set;
    }

    public SetBuilder<E> sparse() {
        this.sparse = true;
        return this;
    }

    public SetBuilder<E> unmodifiable() {
        this.unmodifiable = true;
        return this;
    }

    public SetBuilder<E> copy() {
        if (this.set != null) {
            this.set = new LinkedHashSet<E>(this.set);
        }
        return this;
    }

    public SetBuilder<E> sorted() {
        return this.sorted(Comparator.naturalOrder());
    }

    public SetBuilder<E> sorted(Comparator<E> comparator) {
        this.comparator = comparator;
        return this;
    }

    public SetBuilder<E> addAll(Collection<E> value) {
        if (value != null) {
            if (this.set == null) {
                this.set = new LinkedHashSet<E>(value);
            } else {
                this.set.addAll(value);
            }
        }
        return this;
    }

    public SetBuilder<E> add(E value) {
        if (this.set == null) {
            this.set = new LinkedHashSet();
        }
        this.set.add(value);
        return this;
    }

    public SetBuilder<E> add(E ... values) {
        for (E v : values) {
            this.add(v);
        }
        return this;
    }

    public SetBuilder<E> addJson(String ... values) {
        return this.addAny(values);
    }

    public SetBuilder<E> addAny(Object ... values) {
        block9: {
            if (this.elementType == null) {
                throw ThrowableUtils.runtimeException("Unknown element type.  Cannot use this method.", new Object[0]);
            }
            try {
                if (values == null) break block9;
                for (Object o : values) {
                    if (o == null) continue;
                    if (o instanceof Collection) {
                        ((Collection)o).forEach(x -> this.addAny(x));
                        continue;
                    }
                    if (o.getClass().isArray()) {
                        for (int i = 0; i < Array.getLength(o); ++i) {
                            this.addAny(Array.get(o, i));
                        }
                        continue;
                    }
                    if (StringUtils.isJsonArray(o, false)) {
                        new JsonList(o.toString()).forEach(x -> this.addAny(x));
                        continue;
                    }
                    if (this.elementType.isInstance(o)) {
                        this.add(this.elementType.cast(o));
                        continue;
                    }
                    this.add(ConverterUtils.toType(o, this.elementType, this.elementTypeArgs));
                }
            }
            catch (ParseException e) {
                throw ThrowableUtils.runtimeException(e);
            }
        }
        return this;
    }

    public SetBuilder<E> addIf(boolean flag, E value) {
        if (flag) {
            this.add(value);
        }
        return this;
    }
}

