/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.assertions.FluentComparableAssertion;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;

@FluentSetters(returns="FluentDateAssertion<R>")
public class FluentDateAssertion<R>
extends FluentComparableAssertion<Date, R> {
    private static final Messages MESSAGES = Messages.of(FluentDateAssertion.class, "Messages");
    private static final String MSG_unexpectedValue = MESSAGES.getString("unexpectedValue");
    private static final String MSG_valueWasNotAfterExpected = MESSAGES.getString("valueWasNotAfterExpected");
    private static final String MSG_valueWasNotBeforeExpected = MESSAGES.getString("valueWasNotBeforeExpected");

    public FluentDateAssertion(Date value, R returns) {
        this((Assertion)null, value, returns);
    }

    public FluentDateAssertion(Assertion creator, Date value, R returns) {
        super(creator, value, returns);
    }

    public FluentLongAssertion<R> asEpochMillis() {
        return new FluentLongAssertion((Assertion)this, this.valueIsNull() ? null : Long.valueOf(((Date)this.value()).getTime()), this.returns());
    }

    public FluentLongAssertion<R> asEpochSeconds() {
        return new FluentLongAssertion((Assertion)this, this.valueIsNull() ? null : Long.valueOf(((Date)this.value()).getTime() / 1000L), this.returns());
    }

    public R is(Date value, ChronoUnit precision) throws AssertionError {
        if (ObjectUtils.ne(this.value(), value, (x, y) -> x.toInstant().truncatedTo(precision).equals(y.toInstant().truncatedTo(precision)))) {
            throw this.error(MSG_unexpectedValue, value, this.value());
        }
        return this.returns();
    }

    public R isAfter(Date value) throws AssertionError {
        Assertions.assertArgNotNull("value", value);
        if (!((Date)this.value()).after(value)) {
            throw this.error(MSG_valueWasNotAfterExpected, value, this.value());
        }
        return this.returns();
    }

    public R isAfterNow() throws AssertionError {
        return this.isAfter(new Date());
    }

    public R isBefore(Date value) throws AssertionError {
        Assertions.assertArgNotNull("value", value);
        if (!((Date)this.value()).before(value)) {
            throw this.error(MSG_valueWasNotBeforeExpected, value, this.value());
        }
        return this.returns();
    }

    public R isBeforeNow() throws AssertionError {
        return this.isBefore(new Date());
    }

    public R isBetween(Date lower, Date upper) throws AssertionError {
        this.isExists();
        Assertions.assertArgNotNull("lower", lower);
        Assertions.assertArgNotNull("upper", upper);
        this.isLte(upper);
        this.isGte(lower);
        return this.returns();
    }

    @Override
    public FluentDateAssertion<R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentDateAssertion<R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentDateAssertion<R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentDateAssertion<R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentDateAssertion<R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }
}

