/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BasicPropertyNamer;
import org.apache.juneau.BeanContext;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.TargetedAnnotationTBuilder;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.swap.BeanInterceptor;

public class BeanAnnotation {
    public static final Bean DEFAULT = BeanAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return BeanAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return BeanAnnotation.create().on(on);
    }

    public static Bean copy(Bean a, VarResolverSession r) {
        return ((Builder)BeanAnnotation.create().dictionary(a.dictionary()).example(r.resolve(a.example())).excludeProperties(r.resolve(a.excludeProperties())).findFluentSetters(a.findFluentSetters()).implClass(a.implClass()).interceptor(a.interceptor()).interfaceClass(a.interfaceClass()).on(r.resolve(a.on())).onClass((Class[])a.onClass())).p(r.resolve(a.p())).properties(r.resolve(a.properties())).propertyNamer(a.propertyNamer()).readOnlyProperties(r.resolve(a.readOnlyProperties())).ro(r.resolve(a.ro())).sort(a.sort()).stopClass(a.stopClass()).typeName(r.resolve(a.typeName())).typePropertyName(r.resolve(a.typePropertyName())).wo(r.resolve(a.wo())).writeOnlyProperties(r.resolve(a.writeOnlyProperties())).xp(r.resolve(a.xp())).build();
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Bean[] value();
    }

    public static class Applier
    extends AnnotationApplier<Bean, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Bean.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Bean> ai, BeanContext.Builder b) {
            Bean a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(BeanAnnotation.copy(a, this.vr()));
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements Bean {
        private final boolean findFluentSetters;
        private final boolean sort;
        private final Class<? extends BeanInterceptor<?>> interceptor;
        private final Class<? extends PropertyNamer> propertyNamer;
        private final Class<?> implClass;
        private final Class<?> interfaceClass;
        private final Class<?> stopClass;
        private final Class<?>[] dictionary;
        private final String example;
        private final String excludeProperties;
        private final String p;
        private final String properties;
        private final String readOnlyProperties;
        private final String ro;
        private final String typeName;
        private final String typePropertyName;
        private final String wo;
        private final String writeOnlyProperties;
        private final String xp;

        Impl(Builder b) {
            super(b);
            this.dictionary = ArrayUtils.copyOf(b.dictionary);
            this.example = b.example;
            this.excludeProperties = b.excludeProperties;
            this.findFluentSetters = b.findFluentSetters;
            this.implClass = b.implClass;
            this.interceptor = b.interceptor;
            this.interfaceClass = b.interfaceClass;
            this.p = b.p;
            this.properties = b.properties;
            this.propertyNamer = b.propertyNamer;
            this.readOnlyProperties = b.readOnlyProperties;
            this.ro = b.ro;
            this.sort = b.sort;
            this.stopClass = b.stopClass;
            this.typeName = b.typeName;
            this.typePropertyName = b.typePropertyName;
            this.wo = b.wo;
            this.writeOnlyProperties = b.writeOnlyProperties;
            this.xp = b.xp;
            this.postConstruct();
        }

        @Override
        public Class<?>[] dictionary() {
            return this.dictionary;
        }

        @Override
        public String example() {
            return this.example;
        }

        @Override
        public String excludeProperties() {
            return this.excludeProperties;
        }

        @Override
        public boolean findFluentSetters() {
            return this.findFluentSetters;
        }

        @Override
        public Class<?> implClass() {
            return this.implClass;
        }

        @Override
        public Class<? extends BeanInterceptor<?>> interceptor() {
            return this.interceptor;
        }

        @Override
        public Class<?> interfaceClass() {
            return this.interfaceClass;
        }

        @Override
        public String p() {
            return this.p;
        }

        @Override
        public String properties() {
            return this.properties;
        }

        @Override
        public Class<? extends PropertyNamer> propertyNamer() {
            return this.propertyNamer;
        }

        @Override
        public String readOnlyProperties() {
            return this.readOnlyProperties;
        }

        @Override
        public String ro() {
            return this.ro;
        }

        @Override
        public boolean sort() {
            return this.sort;
        }

        @Override
        public Class<?> stopClass() {
            return this.stopClass;
        }

        @Override
        public String typeName() {
            return this.typeName;
        }

        @Override
        public String typePropertyName() {
            return this.typePropertyName;
        }

        @Override
        public String writeOnlyProperties() {
            return this.writeOnlyProperties;
        }

        @Override
        public String wo() {
            return this.wo;
        }

        @Override
        public String xp() {
            return this.xp;
        }
    }

    public static class Builder
    extends TargetedAnnotationTBuilder {
        Class<?>[] dictionary = new Class[0];
        Class<?> implClass = Void.TYPE;
        Class<?> interfaceClass = Void.TYPE;
        Class<?> stopClass = Void.TYPE;
        Class<? extends BeanInterceptor<?>> interceptor = BeanInterceptor.Void.class;
        Class<? extends PropertyNamer> propertyNamer = BasicPropertyNamer.class;
        String example = "";
        String excludeProperties = "";
        String p = "";
        String properties = "";
        String readOnlyProperties = "";
        String ro = "";
        String typeName = "";
        String typePropertyName = "";
        String wo = "";
        String writeOnlyProperties = "";
        String xp = "";
        boolean findFluentSetters;
        boolean sort;

        protected Builder() {
            super(Bean.class);
        }

        public Bean build() {
            return new Impl(this);
        }

        public Builder dictionary(Class<?> ... value) {
            this.dictionary = value;
            return this;
        }

        public Builder example(String value) {
            this.example = value;
            return this;
        }

        public Builder excludeProperties(String value) {
            this.excludeProperties = value;
            return this;
        }

        public Builder findFluentSetters(boolean value) {
            this.findFluentSetters = value;
            return this;
        }

        public Builder implClass(Class<?> value) {
            this.implClass = value;
            return this;
        }

        public Builder interceptor(Class<? extends BeanInterceptor<?>> value) {
            this.interceptor = value;
            return this;
        }

        public Builder interfaceClass(Class<?> value) {
            this.interfaceClass = value;
            return this;
        }

        public Builder properties(String value) {
            this.properties = value;
            return this;
        }

        public Builder p(String value) {
            this.p = value;
            return this;
        }

        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            this.propertyNamer = value;
            return this;
        }

        public Builder readOnlyProperties(String value) {
            this.readOnlyProperties = value;
            return this;
        }

        public Builder ro(String value) {
            this.ro = value;
            return this;
        }

        public Builder sort(boolean value) {
            this.sort = value;
            return this;
        }

        public Builder stopClass(Class<?> value) {
            this.stopClass = value;
            return this;
        }

        public Builder typeName(String value) {
            this.typeName = value;
            return this;
        }

        public Builder typePropertyName(String value) {
            this.typePropertyName = value;
            return this;
        }

        public Builder wo(String value) {
            this.wo = value;
            return this;
        }

        public Builder writeOnlyProperties(String value) {
            this.writeOnlyProperties = value;
            return this;
        }

        public Builder xp(String value) {
            this.xp = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass(value);
            return this;
        }
    }
}

